/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.languageconfig.service;

import com.arms.api.languageconfig.model.vo.LanguagePackFileVO;
import com.arms.api.languageconfig.model.vo.SingleLanguagePackVO;
import com.arms.api.languageconfig.service.LanguageConfigService;
import com.arms.api.languageconfig.util.LanguagePackFileReader;
import com.arms.api.util.GiteaFileUtil;
import com.arms.config.GiteaUserConfig;
import com.arms.egovframework.javaservice.gcframework.model.FileContent;
import com.arms.egovframework.javaservice.gcframework.model.GitFileInfo;
import com.arms.egovframework.javaservice.gcframework.model.RepoType;
import com.arms.egovframework.javaservice.gcframework.service.GitFileService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LanguageConfigServiceImpl
implements LanguageConfigService {
    private static final Logger log = LoggerFactory.getLogger(LanguageConfigServiceImpl.class);
    private final GiteaUserConfig giteaUserConfig;
    private final GitFileService gitFileService;
    @Value(value="${gitea.language-config}")
    private String languageRepositoryUrl;
    @Value(value="${gitea.lang-pack.repo-name}")
    private String repoName;
    private Map<String, Map<String, Object>> languagePacks = new HashMap();
    private List<String> availableLanguages = new ArrayList();
    private LocalDateTime lastRefreshTime;

    public List<LanguagePackFileVO> getLanguagePackFiles(RepoType repoType) {
        ArrayList<LanguagePackFileVO> fileList = new ArrayList<LanguagePackFileVO>();
        List gitFileInfos = this.gitFileService.listFilesAndDirectories(repoType, this.repoName, "/");
        for (GitFileInfo fileInfo : gitFileInfos) {
            String fileName = fileInfo.getName();
            String languageCode = fileName.replace(".json", "");
            fileList.add(LanguagePackFileVO.builder().fileName(fileName).languageCode(languageCode).filePath(fileInfo.getPath()).sha(fileInfo.getSha() != null ? fileInfo.getSha() : "").size(fileInfo.getSize()).build());
        }
        return fileList;
    }

    public List<LanguagePackFileVO> getLanguagePackFiles_old() {
        ArrayList<LanguagePackFileVO> fileList = new ArrayList<LanguagePackFileVO>();
        try {
            List languagePackFileUrls = GiteaFileUtil.getJsonFileUrlsInDirectory((String)this.languageRepositoryUrl, (String)this.giteaUserConfig.getGitBranch(), (String)this.giteaUserConfig.getGitUsername(), (String)this.giteaUserConfig.getGitPassword());
            for (String fileUrl : languagePackFileUrls) {
                String fileName = GiteaFileUtil.extractFileNameWithoutExtension((String)fileUrl);
                String languageCode = fileName.replace(".json", "");
                Map fileInfo = LanguagePackFileReader.getFileInfoFromGitea((String)fileUrl, (String)this.giteaUserConfig.getGitUsername(), (String)this.giteaUserConfig.getGitPassword());
                if (fileInfo == null) continue;
                Map languagePack = (Map)this.languagePacks.get(languageCode);
                int totalKeys = 0;
                if (languagePack != null) {
                    Map flattenedPack = LanguagePackFileReader.flattenLanguagePack((Map)languagePack);
                    totalKeys = flattenedPack.size();
                }
                LanguagePackFileVO fileVO = LanguagePackFileVO.builder().fileName(fileName).languageCode(languageCode).filePath((String)fileInfo.get("path")).sha((String)fileInfo.get("sha")).size((long)((Integer)fileInfo.get("size")).intValue()).lastModified((String)fileInfo.get("updated_at")).totalKeys(totalKeys).build();
                fileList.add(fileVO);
            }
            return fileList;
        }
        catch (Exception e) {
            log.error("[LanguageConfigServiceImpl::getLanguagePackFiles] :: Error getting language pack files: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to get language pack files", e);
        }
    }

    public SingleLanguagePackVO getSingleLanguagePack(String language) {
        log.info("[LanguageConfigServiceImpl :: getSingleLanguagePack] :: language pack for: {}", (Object)language);
        try {
            this.ensureLanguagePacksAvailable();
            if (!this.availableLanguages.contains(language)) {
                throw new RuntimeException("Language not found: " + language);
            }
            Map languagePack = (Map)this.languagePacks.get(language);
            if (languagePack == null || languagePack.isEmpty()) {
                String fileUrl = this.languageRepositoryUrl + language + ".json?ref=main";
                try {
                    languagePack = LanguagePackFileReader.readLanguagePackFile((String)fileUrl, (String)this.giteaUserConfig.getGitUsername(), (String)this.giteaUserConfig.getGitPassword());
                    this.languagePacks.put(language, languagePack);
                }
                catch (Exception e) {
                    log.error("[LanguageConfigServiceImpl :: getSingleLanguagePack] :: Error getting language pack: {}", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException("Failed to get language pack", e);
                }
            }
            Map flattenedPack = LanguagePackFileReader.flattenLanguagePack((Map)languagePack);
            return SingleLanguagePackVO.builder().language(language).languagePack(flattenedPack).totalKeys(flattenedPack.size()).lastModified(this.lastRefreshTime != null ? this.lastRefreshTime.toString() : LocalDateTime.now().toString()).build();
        }
        catch (Exception e) {
            log.error("Error getting single language pack: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to get single language pack", e);
        }
    }

    public SingleLanguagePackVO refreshSingleLanguagePack(String language) {
        this.languagePacks.remove(language);
        return this.getSingleLanguagePack(language);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public String deleteSingleLanguagePack(String language) {
        LanguageConfigServiceImpl.log.info("[LanguageConfigServiceImpl :: deleteSingleLanguagePack] :: language pack for: {}", (Object)language);
        fileName = language + ".json";
        fileUrl = this.languageRepositoryUrl + fileName + "?ref=main";
        LanguageConfigServiceImpl.log.info("[LanguageConfigServiceImpl :: deleteSingleLanguagePack] :: fileUrl: {}", (Object)fileUrl);
        try {
            block24: {
                url = new URL(fileUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                auth = this.giteaUserConfig.getGitUsername() + ":" + this.giteaUserConfig.getGitPassword();
                encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
                connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
                responseCode = connection.getResponseCode();
                if (responseCode != 200) break block24;
                try {
                    block23: {
                        block22: {
                            block21: {
                                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                                try {
                                    response = new StringBuilder();
                                    while ((inputLine = in.readLine()) != null) {
                                        response.append(inputLine);
                                    }
                                    mapper = new ObjectMapper();
                                    LanguageConfigServiceImpl.log.debug("API Response: {}", (Object)response.toString());
                                    fileNode = mapper.readTree(response.toString());
                                    fileExists = false;
                                    fileSha = null;
                                    if (!fileNode.has("name")) ** GOTO lbl57
                                    name = fileNode.get("name").asText();
                                    LanguageConfigServiceImpl.log.debug("File name from response: {}", (Object)name);
                                    if (!fileName.equals(name)) break block21;
                                    fileExists = true;
                                    if (fileNode.has("sha")) {
                                        fileSha = fileNode.get("sha").asText();
                                        LanguageConfigServiceImpl.log.debug("File SHA: {}", (Object)fileSha);
                                        break block21;
                                    }
                                    LanguageConfigServiceImpl.log.warn("SHA not found in response for file: {}", (Object)fileName);
                                    var17_23 = "Error: SHA not found";
                                }
                                catch (Throwable var10_13) {
                                    try {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable var11_15) {
                                            var10_13.addSuppressed(var11_15);
                                        }
                                        throw var10_13;
                                    }
                                    catch (Exception e) {
                                        LanguageConfigServiceImpl.log.error("Error deleting language pack: {}", (Object)e.getMessage(), (Object)e);
                                        throw new RuntimeException("Failed to delete language pack", e);
                                    }
                                }
                                in.close();
                                return var17_23;
                            }
                            break block22;
lbl57:
                            // 1 sources

                            LanguageConfigServiceImpl.log.warn("Response does not contain 'name' field: {}", (Object)fileNode.toString());
                            name = "Error: File name not found in response";
                            in.close();
                            return name;
                        }
                        if (!fileExists) break block23;
                        LanguageConfigServiceImpl.log.info("File exists. Deleting " + fileName);
                        resultOfDelete = this.deleteFileInRepository(this.languageRepositoryUrl, fileName, fileSha, this.giteaUserConfig.getGitBranch());
                        this.languagePacks.remove(language);
                        var17_24 = resultOfDelete == 200 ? fileName : String.valueOf(resultOfDelete);
                        in.close();
                        return var17_24;
                    }
                    LanguageConfigServiceImpl.log.warn("File does not exist: {}", (Object)fileName);
                    var16_20 = "Error: File not found";
                    in.close();
                    return var16_20;
                }
                finally {
                    connection.disconnect();
                }
            }
            if (responseCode == 404) {
                LanguageConfigServiceImpl.log.warn("File does not exist (404): {}", (Object)fileName);
                return "Error: File not found (404)";
            }
            LanguageConfigServiceImpl.log.error("Failed to retrieve file. Response code: " + responseCode);
            return String.valueOf(responseCode);
        }
        catch (Exception e) {
            LanguageConfigServiceImpl.log.error("Error deleting language pack: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to delete language pack", e);
        }
    }

    public String updateSingleLanguagePack(String language, Map<String, String> languagePack) throws IOException {
        log.info("[LanguageConfigServiceImpl :: updateSingleLanguagePack] :: language pack for: {}", (Object)language);
        String fileName = language + ".json";
        String fileUrl = this.languageRepositoryUrl + fileName + "?ref=main";
        log.info("[LanguageConfigServiceImpl :: updateSingleLanguagePack] :: fileUrl: {}", (Object)fileUrl);
        URL url = new URL(fileUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        String auth = this.giteaUserConfig.getGitUsername() + ":" + this.giteaUserConfig.getGitPassword();
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try {
                String contents;
                BufferedReader in;
                block20: {
                    Object object;
                    in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    try {
                        String inputLine;
                        StringBuilder response = new StringBuilder();
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                        }
                        ObjectMapper mapper = new ObjectMapper();
                        log.debug("API Response: {}", (Object)response.toString());
                        JsonNode fileNode = mapper.readTree(response.toString());
                        boolean fileExists = false;
                        String fileSha = null;
                        if (fileNode.has("name")) {
                            String name = fileNode.get("name").asText();
                            log.debug("File name from response: {}", (Object)name);
                            if (fileName.equals(name)) {
                                fileExists = true;
                                if (fileNode.has("sha")) {
                                    fileSha = fileNode.get("sha").asText();
                                    log.debug("File SHA: {}", (Object)fileSha);
                                } else {
                                    log.warn("SHA not found in response for file: {}", (Object)fileName);
                                }
                            }
                        } else {
                            log.warn("Response does not contain 'name' field: {}", (Object)fileNode.toString());
                        }
                        Map stringObjectMap = LanguagePackFileReader.unflattenLanguagePack(languagePack);
                        ObjectMapper objectMapper = new ObjectMapper();
                        contents = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)stringObjectMap);
                        if (!fileExists) break block20;
                        log.info("File exists. Updating " + fileName);
                        int resultOfUpdate = this.updateFileInRepository(this.languageRepositoryUrl, fileName, fileSha, this.giteaUserConfig.getGitBranch(), contents);
                        object = resultOfUpdate == 200 ? fileName : String.valueOf(resultOfUpdate);
                    }
                    catch (Throwable response) {
                        try {
                            try {
                                in.close();
                            }
                            catch (Throwable inputLine) {
                                response.addSuppressed(inputLine);
                            }
                            throw response;
                        }
                        catch (Exception e) {
                            log.error("Error updating language pack: {}", (Object)e.getMessage(), (Object)e);
                            throw new RuntimeException("Failed to update language pack", e);
                        }
                    }
                    in.close();
                    return object;
                }
                log.info("File does not exist. Creating " + fileName);
                int resultOfCreation = this.createNewFileInRepository(this.languageRepositoryUrl, fileName, this.giteaUserConfig.getGitBranch(), contents);
                Object object = resultOfCreation == 201 ? fileName : String.valueOf(resultOfCreation);
                in.close();
                return object;
            }
            finally {
                this.languagePacks.remove(language);
                connection.disconnect();
            }
        }
        if (responseCode == 404) {
            log.info("File does not exist (404). Creating new file: " + fileName);
            Map stringObjectMap = LanguagePackFileReader.unflattenLanguagePack(languagePack);
            ObjectMapper objectMapper = new ObjectMapper();
            String contents = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)stringObjectMap);
            int resultOfCreation = this.createNewFileInRepository(this.languageRepositoryUrl, fileName, this.giteaUserConfig.getGitBranch(), contents);
            return resultOfCreation == 201 ? fileName : String.valueOf(resultOfCreation);
        }
        log.error("Failed to retrieve directory. Response code: " + responseCode);
        return String.valueOf(responseCode);
    }

    private int updateFileInRepository(String apiUrl, String fileName, String fileSha, String branch, String contents) throws IOException {
        URL url = new URL(apiUrl + fileName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        String auth = this.giteaUserConfig.getGitUsername() + ":" + this.giteaUserConfig.getGitPassword();
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        connection.setRequestProperty("Content-Type", "application/json");
        String content = Base64.getEncoder().encodeToString(contents.getBytes(StandardCharsets.UTF_8));
        String requestBody = String.format("{\"content\":\"%s\",\"message\":\"Update %s\",\"sha\":\"%s\",\"branch\":\"%s\"}", content, fileName, fileSha, branch);
        try (OutputStream os = connection.getOutputStream();){
            os.write(requestBody.getBytes());
            os.flush();
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            log.info("File " + fileName + " updated successfully.");
            return 200;
        }
        log.error("Failed to update file. Response code: " + responseCode);
        return responseCode;
    }

    private int createNewFileInRepository(String apiUrl, String fileName, String branch, String contents) throws IOException {
        URL url = new URL(apiUrl + fileName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        String auth = this.giteaUserConfig.getGitUsername() + ":" + this.giteaUserConfig.getGitPassword();
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        connection.setRequestProperty("Content-Type", "application/json");
        String content = Base64.getEncoder().encodeToString(contents.getBytes(StandardCharsets.UTF_8));
        String requestBody = String.format("{\"content\":\"%s\",\"message\":\"Create %s\",\"branch\":\"%s\"}", content, fileName, branch);
        try (OutputStream os = connection.getOutputStream();){
            os.write(requestBody.getBytes());
            os.flush();
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 201) {
            log.info("File " + fileName + " created successfully.");
            return 201;
        }
        log.error("Failed to create file. Response code: " + responseCode);
        return responseCode;
    }

    private int deleteFileInRepository(String apiUrl, String fileName, String fileSha, String branch) throws IOException {
        URL url = new URL(apiUrl + fileName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.setDoOutput(true);
        String auth = this.giteaUserConfig.getGitUsername() + ":" + this.giteaUserConfig.getGitPassword();
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        connection.setRequestProperty("Content-Type", "application/json");
        String requestBody = String.format("{\"message\":\"Delete %s\",\"sha\":\"%s\",\"branch\":\"%s\"}", fileName, fileSha, branch);
        try (OutputStream os = connection.getOutputStream();){
            os.write(requestBody.getBytes());
            os.flush();
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            log.info("File " + fileName + " deleted successfully.");
            return 200;
        }
        log.error("Failed to delete file. Response code: " + responseCode);
        return responseCode;
    }

    private SingleLanguagePackVO getSingleLanguagePack_new(String language, RepoType repoType) {
        log.info("[LanguageConfigServiceImpl :: getSingleLanguagePack] :: language pack for: {}", (Object)language);
        Map languagePack = (Map)this.languagePacks.get(language);
        FileContent fileContent = this.gitFileService.getFileContent(repoType, this.repoName, "/");
        SingleLanguagePackVO singleLanguagePackVO = (SingleLanguagePackVO)this.gitFileService.parseFileContent(fileContent, "/", SingleLanguagePackVO.class);
        return SingleLanguagePackVO.builder().build();
    }

    public List<SingleLanguagePackVO> getAllLanguagePackContents() {
        log.info("[LanguageConfigServiceImpl :: getAllLanguagePackContents] :: language packs: {}", (Object)this.languagePacks);
        ArrayList<SingleLanguagePackVO> languagePackVOList = new ArrayList<SingleLanguagePackVO>();
        try {
            this.ensureLanguagePacksAvailable();
            for (String language : this.availableLanguages) {
                try {
                    SingleLanguagePackVO languagePackVO = this.getSingleLanguagePack(language);
                    languagePackVOList.add(languagePackVO);
                }
                catch (Exception e) {
                    log.error("Error getting language pack for {}: {}", (Object)language, (Object)e.getMessage());
                }
            }
            return languagePackVOList;
        }
        catch (Exception e) {
            log.error("Error getting all language pack contents: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to get all language pack contents", e);
        }
    }

    public List<SingleLanguagePackVO> refreshAllLanguagePackContents() {
        this.availableLanguages.clear();
        return this.getAllLanguagePackContents();
    }

    public List<String> checkLanguageKeyExists(String language, List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            log.error("The provided keys are null or empty. Please provide keys to check existence of keys.");
            throw new RuntimeException("The provided keys are null or empty. Please provide keys to check existence of keys.");
        }
        Set<Object> keySet = new HashSet();
        this.ensureLanguagePacksAvailable();
        if (!this.availableLanguages.contains(language)) {
            SingleLanguagePackVO singleLanguagePack = this.getSingleLanguagePack(language);
            keySet = singleLanguagePack.getLanguagePack().keySet();
        } else {
            Map unFlatLanguagePack = (Map)this.languagePacks.get(language);
            keySet = LanguagePackFileReader.flattenLanguagePack((Map)unFlatLanguagePack).keySet();
        }
        if (keySet.isEmpty()) {
            log.error("The provided language pack does not contain any keys.");
            throw new RuntimeException("The provided language pack does not contain any keys.");
        }
        return keys.parallelStream().filter(keySet::contains).collect(Collectors.toList());
    }

    public Map<String, Map<String, Object>> fetchLanguagePacks() {
        log.info("Fetching all language packs from Gitea");
        try {
            List languagePackFileUrls = GiteaFileUtil.getJsonFileUrlsInDirectory((String)this.languageRepositoryUrl, (String)this.giteaUserConfig.getGitBranch(), (String)this.giteaUserConfig.getGitUsername(), (String)this.giteaUserConfig.getGitPassword());
            this.availableLanguages = languagePackFileUrls.stream().map(fileUrl -> GiteaFileUtil.extractFileNameWithoutExtension((String)fileUrl).replace(".json", "")).collect(Collectors.toList());
            this.languagePacks.clear();
            for (String fileUrl2 : languagePackFileUrls) {
                String fileName = GiteaFileUtil.extractFileNameWithoutExtension((String)fileUrl2);
                String languageCode = fileName.replace(".json?ref=main", "");
                Map languagePack = LanguagePackFileReader.readLanguagePackFile((String)fileUrl2, (String)this.giteaUserConfig.getGitUsername(), (String)this.giteaUserConfig.getGitPassword());
                this.languagePacks.put(languageCode, languagePack);
            }
            this.lastRefreshTime = LocalDateTime.now();
            log.info("Successfully loaded {} language packs: {}", (Object)this.availableLanguages.size(), (Object)this.availableLanguages);
            return this.languagePacks;
        }
        catch (Exception e) {
            log.error("Error fetching language packs: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to fetch language packs", e);
        }
    }

    private void ensureLanguagePacksAvailable() {
        if (this.availableLanguages.isEmpty()) {
            log.info("Available languages is empty, attempting to refresh language packs");
            this.fetchLanguagePacks();
            if (this.availableLanguages.isEmpty()) {
                log.warn("No language packs found after refresh");
                throw new RuntimeException("No language packs found after refresh");
            }
        }
    }

    public LanguageConfigServiceImpl(GiteaUserConfig giteaUserConfig, GitFileService gitFileService) {
        this.giteaUserConfig = giteaUserConfig;
        this.gitFileService = gitFileService;
    }
}

