/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.external_communicate;

import com.arms.api.schedule.model.vo.ScheduleHistoryVO;
import com.arms.api.util.external_communicate.dto.SearchDTO;
import com.arms.api.util.external_communicate.vo.ServerInfoVO;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name="engine-fire", url="${arms.engine-fire.url}")
public interface EngineCommunicator {
    @PostMapping(value={"/engine/serverInfo/backup/scheduler"})
    public Iterable<ServerInfoVO> serverInfoBackup();

    @GetMapping(value={"/engine/connection/keep-alive"})
    public void keepAlive();

    @PostMapping(value={"/engine/index/alm-issue/merge-with-reindex"})
    public void almIssueMergeWithReindex();

    @PostMapping(value={"/engine/index/fluentd/merge-with-reindex"})
    public void fluentdMergeWithReindex();

    @PostMapping(value={"/engine/index/alm-issue/merge-with-reindex/day/{day}"})
    public void almIssueMergeWithReindex(@PathVariable(value="day") int var1);

    @PostMapping(value={"/engine/index/fluentd/merge-with-reindex/day/{day}"})
    public void fluentdMergeWithReindex(@PathVariable(value="day") int var1);

    @PutMapping(value={"/engine/jira/arms-state-category"})
    public void updateArmsStateCategory();

    @PostMapping(value={"/engine/search/schedule-history-log"})
    public ResponseEntity<List<ScheduleHistoryVO>> getScheduleHistory(@RequestBody SearchDTO var1);

    @GetMapping(value={"/engine/jira/issue/test/api-request"})
    public void cloudJiraTestApiRequest();
}

