/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.service;

import com.arms.api.analysis.time.dto.TimeAggrDTO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.requirement.model.dto.FilteredResults;
import com.arms.api.requirement.model.dto.RequirementAggrDTO;
import com.arms.api.requirement.model.dto.RequirementDTO;
import com.arms.api.requirement.model.dto.SubtaskAndLinkedIssuesRequestDTO;
import com.arms.api.requirement.model.vo.HierarchicalAlmIssue;
import com.arms.api.requirement.model.vo.ReqProgressVO;
import com.arms.api.requirement.model.vo.RequirementVO;
import com.arms.api.requirement.service.RequirementService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="\uc694\uad6c\uc0ac\ud56d_\uc11c\ube44\uc2a4")
public class RequirementServiceImpl
implements RequirementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequirementServiceImpl.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    @Override
    public List<AlmIssueEntity> \ud568\uaed8_\uc0dd\uc131\ub41c_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288\ubaa9\ub85d(Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, List<Long> \ubc84\uc804_\uc544\uc774\ub514\ub4e4, Long \uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514) {
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust("pdServiceId", \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514).andTermQueryMust("isReq", true).andTermQueryMust("cReqLink", \uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514).andTermsQueryFilter("pdServiceVersions", \ubc84\uc804_\uc544\uc774\ub514\ub4e4)).toDocs();
    }

    @Override
    public List<RequirementVO> \uc81c\ud488_\uc694\uad6c\uc0ac\ud56d\ubcc4_\ub2f4\ub2f9\uc790_\ubaa9\ub85d(RequirementAggrDTO requirementAggrDTO) {
        boolean \uc694\uad6c\uc0ac\ud56d\uc5ec\ubd80 = requirementAggrDTO.getIsReq();
        String rootField = \uc694\uad6c\uc0ac\ud56d\uc5ec\ubd80 ? "key" : "parentReqKey";
        String rootFieldAlias = \uc694\uad6c\uc0ac\ud56d\uc5ec\ubd80 ? "requirement" : "parentRequirement";
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField(rootField).mainFieldAlias(rootFieldAlias).addGroup(SubGroupFieldDTO.builder().subFieldAlias("assignees").subField("assignee.assignee_accountId.keyword").size(10000).isAscending(false).build(), SubGroupFieldDTO.builder().subFieldAlias("displayNames").subField("assignee.assignee_displayName.keyword").size(10000).build(), SubGroupFieldDTO.builder().subFieldAlias("cReqLink").subField("cReqLink").size(10000).build()).build()));
        List<DocumentBucket> documentBuckets = documentAggregations.deepestList();
        ArrayList<RequirementVO> requirementVOList = new ArrayList<RequirementVO>();
        for (DocumentBucket documentBucket : documentBuckets) {
            String reqKey = documentBucket.valueByName(rootFieldAlias);
            String assigneeKey = documentBucket.valueByName("assignees");
            String displayNameKey = documentBucket.valueByName("displayNames");
            String reqLinkKey = documentBucket.valueByName("cReqLink");
            RequirementVO requirementVO = RequirementVO.builder().reqKey(reqKey).reqLinkKey(reqLinkKey).assigneeKey(assigneeKey).displayNameKey(displayNameKey).isReq(\uc694\uad6c\uc0ac\ud56d\uc5ec\ubd80).build();
            requirementVOList.add(requirementVO);
        }
        return requirementVOList;
    }

    @Override
    public List<AlmIssueEntity> deletedIssueList(Long pdServiceLink, List<Long> pdServiceVersionLinks) {
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust("pdServiceId", pdServiceLink).andTermsQueryFilter("pdServiceVersions", pdServiceVersionLinks).andTermQueryFilter("deleted.deleted_isDeleted", "true")).toDocs();
    }

    @Override
    public int \uc774\uc288_\uc0ad\uc81c\ucca0\ud68c(List<AlmIssueEntity> \uc0ad\uc81c_\ucca0\ud68c\ub300\uc0c1_\ubaa9\ub85d) throws Exception {
        try {
            List \ucca0\ud68c\uc5c5\ub370\uc774\ud2b8 = Optional.ofNullable(\uc0ad\uc81c_\ucca0\ud68c\ub300\uc0c1_\ubaa9\ub85d).orElse(Collections.emptyList()).stream().map(\uc9c0\ub77c\uc774\uc288_\uc5d4\ud2f0\ud2f0 -> {
                \uc9c0\ub77c\uc774\uc288_\uc5d4\ud2f0\ud2f0.getDeleted().setIsDeleted(false);
                return \uc9c0\ub77c\uc774\uc288_\uc5d4\ud2f0\ud2f0;
            }).collect(Collectors.toList());
            List \uc9c0\ub77c\uc774\uc288s = \ucca0\ud68c\uc5c5\ub370\uc774\ud2b8.stream().map(\uc774\uc288 -> this.esCommonRepositoryWrapper.save((AlmIssueEntity)\uc774\uc288)).collect(Collectors.toList());
            int count = \uc9c0\ub77c\uc774\uc288s.size();
            if (count == 0) {
                log.info("\uc774\uc288 \uc0ad\uc81c \ucca0\ud68c \uc791\uc5c5\uc5d0\uc11c \uc5c5\ub370\uc774\ud2b8\ub41c \uc5d4\ud2f0\ud2f0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            } else {
                log.info("\uc774\uc288 \uc0ad\uc81c \ucca0\ud68c \uc791\uc5c5\uc5d0\uc11c {}\uac1c\uc758 \uc5d4\ud2f0\ud2f0\uac00 \uc5c5\ub370\uc774\ud2b8\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", (Object)count);
            }
            return count;
        }
        catch (Exception e) {
            log.error("\uc774\uc288 \uc0ad\uc81c \ucca0\ud68c \uc791\uc5c5 \uc911 \uc624\ub958 \ubc1c\uc0dd", (Throwable)e);
            throw new Exception("\uc774\uc288 \uc0ad\uc81c \ucca0\ud68c \uc791\uc5c5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    @Override
    public List<ReqProgressVO> \uc77c\ubc18_\ubc84\uc804\ud544\ud130_\ud574\uacb0\ucc45\uc720\ubb34_\uac80\uc0c9(RequirementDTO requirementDTO, String resolution) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = requirementDTO.getPdServiceAndIsReq();
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("cReqLink").mainFieldAlias("cReqLink").build()).andTermQueryMust("pdServiceId", pdServiceAndIsReq.getPdServiceId()).andTermQueryMust("isReq", pdServiceAndIsReq.getIsReq()).andTermsQueryFilter("pdServiceVersions", pdServiceAndIsReq.getPdServiceVersions()).andExistsQueryFilter(resolution));
        List<DocumentBucket> documentBuckets = documentAggregations.deepestList();
        return this.buildReqProgressList(documentBuckets);
    }

    private List<ReqProgressVO> buildReqProgressList(List<DocumentBucket> documentBuckets) {
        ArrayList<ReqProgressVO> reqProgressList = new ArrayList<ReqProgressVO>();
        if (documentBuckets.isEmpty()) {
            return Collections.emptyList();
        }
        for (DocumentBucket documentBucket : documentBuckets) {
            reqProgressList.add(ReqProgressVO.builder().cReqLink(Long.valueOf(documentBucket.valueByName("cReqLink"))).docCount(documentBucket.countByName("cReqLink")).build());
        }
        return reqProgressList;
    }

    @Override
    public List<AlmIssueEntity> issueListByUpdatedDate(RequirementDTO requirementDTO) {
        List<AlmIssueEntity> allList = this.getAllListByRequirementDTO(requirementDTO);
        if (allList.isEmpty()) {
            return Collections.emptyList();
        }
        List<AlmIssueEntity> filteredList = allList.stream().filter(entity -> entity.getUpdated() != null).collect(Collectors.toList());
        filteredList.sort(Comparator.comparing(AlmIssueEntity::stringValueOfUpdatedDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed());
        return filteredList;
    }

    @Override
    public List<AlmIssueEntity> issueListByUpdated2ndTab(RequirementDTO requirementDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = requirementDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List<Long> pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termsQueryFilter("linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", pdServiceVersions).andExistsQueryFilter("updated").orderBy(SortDTO.builder().field("updated").sortType("desc").build()));
    }

    @Override
    public List<AlmIssueEntity> issueListByOverallUpdatedDate(RequirementDTO requirementDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = requirementDTO.getPdServiceAndIsReq();
        return this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termQueryMust("pdServiceId", pdServiceAndIsReq.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", pdServiceAndIsReq.getPdServiceVersions()).andExistsQueryFilter("overallUpdatedDate").orderBy(SortDTO.builder().field("overallUpdatedDate").sortType("desc").build()));
    }

    @Override
    public List<HierarchicalAlmIssue> issueListByAdvancedDiscovery(RequirementDTO requirementDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = requirementDTO.getPdServiceAndIsReq();
        List<AlmIssueEntity> depth1IssueList = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termQueryMust("pdServiceId", pdServiceAndIsReq.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", pdServiceAndIsReq.getPdServiceVersions()).orderBy(SortDTO.builder().field("updated").sortType("desc").build()));
        HashSet<String> reqIdSet = new HashSet<String>();
        HashSet<String> notReqIdSet = new HashSet<String>();
        HashSet<String> linkedIssueSetByIssuesHavePdServiceAndVersions = new HashSet<String>();
        for (AlmIssueEntity issue : depth1IssueList) {
            if (Boolean.TRUE.equals(issue.getIsReq())) {
                reqIdSet.add(issue.getRecentId());
            } else {
                notReqIdSet.add(issue.getRecentId());
            }
            if (issue.getLinkedIssues() == null) continue;
            linkedIssueSetByIssuesHavePdServiceAndVersions.addAll(issue.getLinkedIssues());
        }
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("upperKey").mainFieldAlias("upperKey").build()).andExistsQueryFilter("upperKey").andTermQueryMust("pdServiceId", pdServiceAndIsReq.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", pdServiceAndIsReq.getPdServiceVersions()));
        List<DocumentBucket> subtaskDocBuckets = documentAggregations.deepestList();
        HashMap<String, Long> subtaskKeyCountMap = new HashMap<String, Long>();
        for (DocumentBucket doc : subtaskDocBuckets) {
            String issueKey = doc.valueByName("upperKey");
            Long issueCount = doc.countByName("upperKey");
            subtaskKeyCountMap.put(issueKey, issueCount);
        }
        List<HierarchicalAlmIssue> hierarchicalAlmIssues = this.hierarchicalAlmIssuesFromAlmIssueList(depth1IssueList, subtaskKeyCountMap);
        Map<String, HierarchicalAlmIssue> recentIdHIssuesMap = hierarchicalAlmIssues.stream().collect(Collectors.toMap(hierarchicalAlmIssue -> hierarchicalAlmIssue.getAlmIssue().getRecentId(), hierarchicalAlmIssue -> hierarchicalAlmIssue));
        List linkedIssueIdList = linkedIssueSetByIssuesHavePdServiceAndVersions.stream().toList();
        for (String linkedIssue : linkedIssueIdList) {
            if (reqIdSet.contains(linkedIssue)) {
                linkedIssueSetByIssuesHavePdServiceAndVersions.remove(linkedIssue);
                continue;
            }
            if (!notReqIdSet.contains(linkedIssue)) continue;
            linkedIssueSetByIssuesHavePdServiceAndVersions.remove(linkedIssue);
        }
        List linkedIssueIdListNeededSearch = linkedIssueSetByIssuesHavePdServiceAndVersions.stream().toList();
        List<AlmIssueEntity> linkedIssueSearchResult = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termsQueryFilter("recent_id", linkedIssueIdListNeededSearch).orderBy(SortDTO.builder().field("updated").sortType("desc").build()));
        List<String> linkedIssueKeyList = linkedIssueSearchResult.stream().map(AlmIssueEntity::getKey).toList();
        DocumentAggregations documentAggregations1 = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("upperKey").mainFieldAlias("upperKey").build()).andTermsQueryFilter("upperKey", linkedIssueKeyList));
        List<DocumentBucket> linkedSubtaskDocBuckets = documentAggregations1.deepestList();
        HashMap<String, Long> linkedSubtaskKeyCountMap = new HashMap<String, Long>();
        for (DocumentBucket doc : linkedSubtaskDocBuckets) {
            String issueKey = doc.valueByName("upperKey");
            Long issueCount = doc.countByName("upperKey");
            linkedSubtaskKeyCountMap.put(issueKey, issueCount);
        }
        List<HierarchicalAlmIssue> linkedHierarchicalAlmIssues = this.hierarchicalAlmIssuesFromAlmIssueList(linkedIssueSearchResult, linkedSubtaskKeyCountMap);
        Map<String, HierarchicalAlmIssue> recentIdLinkedHIssuesMap = linkedHierarchicalAlmIssues.stream().collect(Collectors.toMap(hierarchicalAlmIssue -> hierarchicalAlmIssue.getAlmIssue().getRecentId(), hierarchicalAlmIssue -> hierarchicalAlmIssue));
        Map<String, HierarchicalAlmIssue> combinedMap = Stream.concat(recentIdHIssuesMap.entrySet().stream(), recentIdLinkedHIssuesMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        ArrayList<HierarchicalAlmIssue> reqHIssueList = new ArrayList<HierarchicalAlmIssue>();
        HashMap<String, List> upperKeyHIssueListMap = new HashMap<String, List>();
        for (HierarchicalAlmIssue hierarchicalAlmIssue2 : hierarchicalAlmIssues) {
            if (hierarchicalAlmIssue2.getAlmIssue().getIsReq().booleanValue()) {
                reqHIssueList.add(hierarchicalAlmIssue2);
                continue;
            }
            upperKeyHIssueListMap.computeIfAbsent(hierarchicalAlmIssue2.getAlmIssue().getUpperKey(), k -> new ArrayList()).add(hierarchicalAlmIssue2);
        }
        ArrayList<HierarchicalAlmIssue> returnList = new ArrayList<HierarchicalAlmIssue>();
        for (HierarchicalAlmIssue hierarchicalAlmIssue3 : reqHIssueList) {
            returnList.add(hierarchicalAlmIssue3);
            if (upperKeyHIssueListMap.containsKey(hierarchicalAlmIssue3.getAlmIssue().getKey())) {
                returnList.addAll((Collection)upperKeyHIssueListMap.get(hierarchicalAlmIssue3.getAlmIssue().getKey()));
            }
            if (hierarchicalAlmIssue3.getLinkedIssueCount() <= 0L) continue;
            List<String> recentIdsOfLinkedIssues = hierarchicalAlmIssue3.getAlmIssue().getLinkedIssues();
            for (String recentId : recentIdsOfLinkedIssues) {
                HierarchicalAlmIssue almIssue = combinedMap.get(recentId);
                if (almIssue != null) {
                    HierarchicalAlmIssue hierarchicalAlmIssue1 = HierarchicalAlmIssue.copyObject(almIssue);
                    hierarchicalAlmIssue1.setIsReqName(hierarchicalAlmIssue3.getAlmIssue().getKey() + "_link");
                    returnList.add(hierarchicalAlmIssue1);
                    continue;
                }
                log.warn("[RequirementServiceImpl :: issueListByAdvancedDiscovery] :: linked issue not found. recentId: {}", (Object)recentId);
            }
        }
        return returnList;
    }

    @Override
    public List<HierarchicalAlmIssue> subtasksAndLinkedIssues(SubtaskAndLinkedIssuesRequestDTO subtaskAndLinkedIssuesRequestDTO) {
        Long issueCount;
        String issueKey;
        String key = subtaskAndLinkedIssuesRequestDTO.getKey();
        String upperKey = subtaskAndLinkedIssuesRequestDTO.getUpperKey();
        String parentReqKey = subtaskAndLinkedIssuesRequestDTO.getParentReqKey();
        List<String> linkedissues = subtaskAndLinkedIssuesRequestDTO.getLinkedIssues();
        RequirementDTO searchDTO = new RequirementDTO();
        ArrayList<HierarchicalAlmIssue> returnList = new ArrayList<HierarchicalAlmIssue>();
        if (subtaskAndLinkedIssuesRequestDTO.getSubtaskCount() > 0L) {
            List<AlmIssueEntity> fetchedSubtasks = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termQueryMust("upperKey", key).orderBy(SortDTO.builder().field("updated").sortType("desc").build()));
            DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("upperKey").mainFieldAlias("upperKey").build()).andTermsQueryFilter("upperKey", fetchedSubtasks.stream().map(AlmIssueEntity::getKey).toList()));
            List<DocumentBucket> subtaskDocBuckets = documentAggregations.deepestList();
            HashMap<String, Long> subtaskKeyCountMap = new HashMap<String, Long>();
            for (DocumentBucket doc : subtaskDocBuckets) {
                issueKey = doc.valueByName("upperKey");
                issueCount = doc.countByName("upperKey");
                subtaskKeyCountMap.put(issueKey, issueCount);
            }
            returnList.addAll(this.hierarchicalAlmIssuesFromAlmIssueList(fetchedSubtasks, subtaskKeyCountMap));
        }
        if (subtaskAndLinkedIssuesRequestDTO.getLinkedIssueCount() > 0L) {
            List<AlmIssueEntity> fetchedLinkedIssues = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termsQueryFilter("recent_id", linkedissues).orderBy(SortDTO.builder().field("updated").sortType("desc").build()));
            DocumentAggregations documentAggregations1 = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("upperKey").mainFieldAlias("upperKey").build()).andTermsQueryFilter("upperKey", fetchedLinkedIssues.stream().map(AlmIssueEntity::getKey).toList()));
            List<DocumentBucket> linkedSubtaskDocBuckets = documentAggregations1.deepestList();
            HashMap<String, Long> linkedSubtaskKeyCountMap = new HashMap<String, Long>();
            for (DocumentBucket doc : linkedSubtaskDocBuckets) {
                issueKey = doc.valueByName("upperKey");
                issueCount = doc.countByName("upperKey");
                linkedSubtaskKeyCountMap.put(issueKey, issueCount);
            }
            List<HierarchicalAlmIssue> linkedHierarchicalAlmIssues = this.hierarchicalAlmIssuesFromAlmIssueList(fetchedLinkedIssues, linkedSubtaskKeyCountMap);
            for (HierarchicalAlmIssue hierarchicalAlmIssue : linkedHierarchicalAlmIssues) {
                hierarchicalAlmIssue.addIsReqName(key + "_link");
            }
            returnList.addAll(linkedHierarchicalAlmIssues);
        }
        return returnList;
    }

    private List<HierarchicalAlmIssue> hierarchicalAlmIssuesFromAlmIssueList(List<AlmIssueEntity> almIssueEntities, Map<String, Long> subtaskKeyCountMap) {
        ArrayList<HierarchicalAlmIssue> result = new ArrayList<HierarchicalAlmIssue>();
        for (AlmIssueEntity issue : almIssueEntities) {
            HierarchicalAlmIssue.HierarchicalAlmIssueBuilder hBuilder = HierarchicalAlmIssue.builder();
            if (issue.getIsReq().booleanValue()) {
                hBuilder.isReqName("\uc694\uad6c\uc0ac\ud56d");
            } else if (!ObjectUtils.isEmpty((Object)issue.getUpperKey())) {
                hBuilder.isReqName(issue.getUpperKey());
            } else {
                hBuilder.isReqName("");
            }
            hBuilder.subtaskCount(subtaskKeyCountMap.getOrDefault(issue.getKey(), 0L));
            if (!ObjectUtils.isEmpty(issue.getLinkedIssues())) {
                hBuilder.linkedIssueCount(Long.valueOf(issue.getLinkedIssues().size()));
            } else {
                hBuilder.linkedIssueCount(0L);
            }
            hBuilder.almIssue(issue);
            result.add(hBuilder.build());
        }
        return result;
    }

    @Override
    public List<AlmIssueEntity> getIssuesByRequirementDTO(SimpleQuery<SearchDocDTO> simpleQuery) {
        ArrayList<AlmIssueEntity> returnList = new ArrayList<AlmIssueEntity>();
        HashSet<String> totalRecentIdSet = new HashSet<String>();
        HashSet<String> linkedIssuesRecentIdSet = new HashSet<String>();
        HashSet<String> keySet = new HashSet<String>();
        List<AlmIssueEntity> depth1IssueList = this.esCommonRepositoryWrapper.findRecentHits(simpleQuery).toDocs();
        if (ObjectUtils.isEmpty(depth1IssueList)) {
            return Collections.emptyList();
        }
        for (AlmIssueEntity issue : depth1IssueList) {
            totalRecentIdSet.add(issue.getRecentId());
            keySet.add(issue.getKey());
            if (!ObjectUtils.isEmpty(issue.getLinkedIssues())) {
                linkedIssuesRecentIdSet.addAll(issue.getLinkedIssues());
            }
            returnList.add(issue);
        }
        linkedIssuesRecentIdSet.removeIf(totalRecentIdSet::contains);
        this.processLinkedIssues(totalRecentIdSet, linkedIssuesRecentIdSet, returnList);
        this.processSubtasks(totalRecentIdSet, keySet.stream().toList(), returnList);
        return returnList;
    }

    @Override
    public List<AlmIssueEntity> getIssuesByRequirementDTO(SimpleQuery<SearchDocDTO> simpleQuery, String field, String startDate, String endDate) {
        ArrayList<AlmIssueEntity> returnList = new ArrayList<AlmIssueEntity>();
        HashSet<String> totalRecentIdSet = new HashSet<String>();
        HashSet<String> linkedIssuesRecentIdSet = new HashSet<String>();
        HashSet<String> keySet = new HashSet<String>();
        List<AlmIssueEntity> depth1IssueList = this.esCommonRepositoryWrapper.findRecentHits(simpleQuery).toDocs();
        if (ObjectUtils.isEmpty(depth1IssueList)) {
            return Collections.emptyList();
        }
        for (AlmIssueEntity issue : depth1IssueList) {
            totalRecentIdSet.add(issue.getRecentId());
            keySet.add(issue.getKey());
            if (!ObjectUtils.isEmpty(issue.getLinkedIssues())) {
                linkedIssuesRecentIdSet.addAll(issue.getLinkedIssues());
            }
            returnList.add(issue);
        }
        linkedIssuesRecentIdSet.removeIf(totalRecentIdSet::contains);
        this.processLinkedIssues(totalRecentIdSet, linkedIssuesRecentIdSet, returnList, field, startDate, endDate);
        this.processSubtasks(totalRecentIdSet, keySet.stream().toList(), returnList, field, startDate, endDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return returnList.stream().filter(e -> {
            if (Boolean.TRUE.equals(e.getIsReq())) {
                if (StringUtils.equals((CharSequence)field, (CharSequence)"created")) {
                    Date created = e.getCreated();
                    try {
                        return created != null && !created.before(sdf.parse(startDate + "T00:00:00.000+0900")) && !created.after(sdf.parse(endDate + "T23:59:59.999+0900"));
                    }
                    catch (ParseException ex) {
                        log.warn(ex.getMessage());
                        return false;
                    }
                }
                Date updated = e.getUpdated();
                try {
                    return updated != null && !updated.before(sdf.parse(startDate + "T00:00:00.000+0900")) && !updated.after(sdf.parse(endDate + "T23:59:59.999+0900"));
                }
                catch (ParseException ex) {
                    log.warn(ex.getMessage());
                    return false;
                }
            }
            return true;
        }).toList();
    }

    @Override
    public List<AlmIssueEntity> getRelationIssuesByRequirementDTO(TimeAggrDTO timeAggrDTO) {
        ArrayList<AlmIssueEntity> returnList = new ArrayList<AlmIssueEntity>();
        HashSet<String> totalRecentIdSet = new HashSet<String>();
        HashSet<String> linkedIssuesRecentIdSet = new HashSet<String>();
        HashSet<String> keySet = new HashSet<String>();
        List<AlmIssueEntity> depth1IssueList = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust("pdServiceId", timeAggrDTO.getPdServiceLink()).andTermsQueryFilter("pdServiceVersions", timeAggrDTO.getPdServiceVersionLinks()).andTermQueryMust("isReq", true)).toDocs();
        if (ObjectUtils.isEmpty(depth1IssueList)) {
            return Collections.emptyList();
        }
        for (AlmIssueEntity issue : depth1IssueList) {
            totalRecentIdSet.add(issue.getRecentId());
            keySet.add(issue.getKey());
            if (ObjectUtils.isEmpty(issue.getLinkedIssues())) continue;
            linkedIssuesRecentIdSet.addAll(issue.getLinkedIssues());
        }
        linkedIssuesRecentIdSet.removeIf(totalRecentIdSet::contains);
        String field = "updated";
        String startDate = timeAggrDTO.getStartDate();
        String endDate = timeAggrDTO.getEndDate();
        this.processLinkedIssues(totalRecentIdSet, linkedIssuesRecentIdSet, returnList, field, startDate, endDate);
        this.processSubtasks(totalRecentIdSet, keySet.stream().toList(), returnList, field, startDate, endDate);
        return returnList.stream().filter(e -> !Boolean.TRUE.equals(e.getIsReq())).toList();
    }

    @Override
    public List<AlmIssueEntity> getAllListByRequirementDTO(RequirementDTO requirementDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = requirementDTO.getPdServiceAndIsReq();
        ArrayList<AlmIssueEntity> returnList = new ArrayList<AlmIssueEntity>();
        HashSet<String> totalRecentIdSet = new HashSet<String>();
        HashSet<String> linkedIssuesRecentIdSet = new HashSet<String>();
        HashSet<String> keySet = new HashSet<String>();
        List<AlmIssueEntity> depth1IssueList = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust("pdServiceId", pdServiceAndIsReq.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", pdServiceAndIsReq.getPdServiceVersions()).orderBy(SortDTO.builder().field("updated").sortType("desc").build())).toDocs();
        for (AlmIssueEntity issue : depth1IssueList) {
            totalRecentIdSet.add(issue.getRecentId());
            keySet.add(issue.getKey());
            if (!ObjectUtils.isEmpty(issue.getLinkedIssues())) {
                linkedIssuesRecentIdSet.addAll(issue.getLinkedIssues());
            }
            returnList.add(issue);
        }
        linkedIssuesRecentIdSet.removeIf(totalRecentIdSet::contains);
        this.processLinkedIssues(totalRecentIdSet, linkedIssuesRecentIdSet, returnList);
        this.processSubtasks(totalRecentIdSet, keySet.stream().toList(), returnList);
        return returnList;
    }

    private List<AlmIssueEntity> getAlmIssuesByRecentIds(List<String> recentIds) {
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter("recent_id", recentIds)).toDocs();
    }

    private List<AlmIssueEntity> getAlmIssuesByRecentIds(List<String> recentIds, String field, String startDate, String endDate) {
        return this.esCommonRepositoryWrapper.findHits(SimpleQuery.termsQueryFilter("recent_id", recentIds).andRangeQueryFilter(RangeQueryFilter.of(field).betweenDate(startDate, endDate))).toDocs();
    }

    private List<AlmIssueEntity> getSubtasksByUpperKeys(List<String> upperKeys) {
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter("upperKey", upperKeys)).toDocs();
    }

    private List<AlmIssueEntity> getSubtasksByUpperKeys(List<String> upperKeys, String field, String startDate, String endDate) {
        return this.esCommonRepositoryWrapper.findHits(SimpleQuery.termsQueryFilter("upperKey", upperKeys).andRangeQueryFilter(RangeQueryFilter.of(field).betweenDate(startDate, endDate))).toDocs();
    }

    private void processIssues(Set<String> totalRecentIdSet, Set<String> linkedIssueRecentIdSet, List<AlmIssueEntity> fetchedIssues, List<AlmIssueEntity> returnList) {
        if (ObjectUtils.isEmpty(fetchedIssues)) {
            return;
        }
        List<String> issueKeyList = fetchedIssues.stream().map(AlmIssueEntity::getKey).collect(Collectors.toSet()).stream().toList();
        List<String> newlyFoundLinkedIssueIds = fetchedIssues.stream().flatMap(issue -> Optional.ofNullable(issue.getLinkedIssues()).stream()).flatMap(Collection::stream).filter(linkedId -> !totalRecentIdSet.contains(linkedId)).toList();
        if (!ObjectUtils.isEmpty(newlyFoundLinkedIssueIds)) {
            linkedIssueRecentIdSet.addAll(newlyFoundLinkedIssueIds);
        }
        this.processLinkedIssues(totalRecentIdSet, linkedIssueRecentIdSet, returnList);
        this.processSubtasks(totalRecentIdSet, issueKeyList, returnList);
    }

    private void processIssues(Set<String> totalRecentIdSet, Set<String> linkedIssueRecentIdSet, List<AlmIssueEntity> fetchedIssues, List<AlmIssueEntity> returnList, String field, String startDate, String endDate) {
        if (ObjectUtils.isEmpty(fetchedIssues)) {
            return;
        }
        List<String> issueKeyList = fetchedIssues.stream().map(AlmIssueEntity::getKey).collect(Collectors.toSet()).stream().toList();
        List<String> newlyFoundLinkedIssueIds = fetchedIssues.stream().flatMap(issue -> Optional.ofNullable(issue.getLinkedIssues()).stream()).flatMap(Collection::stream).filter(linkedId -> !totalRecentIdSet.contains(linkedId)).toList();
        if (!ObjectUtils.isEmpty(newlyFoundLinkedIssueIds)) {
            linkedIssueRecentIdSet.addAll(newlyFoundLinkedIssueIds);
        }
        this.processLinkedIssues(totalRecentIdSet, linkedIssueRecentIdSet, returnList, field, startDate, endDate);
        this.processSubtasks(totalRecentIdSet, issueKeyList, returnList, field, startDate, endDate);
    }

    private void processLinkedIssues(Set<String> totalRecentIdSet, Set<String> linkedIssueRecentIdSet, List<AlmIssueEntity> returnList) {
        if (ObjectUtils.isEmpty(linkedIssueRecentIdSet)) {
            return;
        }
        List<AlmIssueEntity> fetchedLinkedIssues = this.getAlmIssuesByRecentIds(linkedIssueRecentIdSet.stream().toList());
        FilteredResults filteredResults = this.processAndFilterIssuesAndTrackNew(totalRecentIdSet, fetchedLinkedIssues, returnList);
        this.processIssues(totalRecentIdSet, filteredResults.getLinkedIds(), filteredResults.getUniqueIssues(), returnList);
    }

    private void processLinkedIssues(Set<String> totalRecentIdSet, Set<String> linkedIssueRecentIdSet, List<AlmIssueEntity> returnList, String field, String startDate, String endDate) {
        if (ObjectUtils.isEmpty(linkedIssueRecentIdSet)) {
            return;
        }
        List<AlmIssueEntity> fetchedLinkedIssues = this.getAlmIssuesByRecentIds(linkedIssueRecentIdSet.stream().toList(), field, startDate, endDate);
        FilteredResults filteredResults = this.processAndFilterIssuesAndTrackNew(totalRecentIdSet, fetchedLinkedIssues, returnList);
        this.processIssues(totalRecentIdSet, filteredResults.getLinkedIds(), filteredResults.getUniqueIssues(), returnList, field, startDate, endDate);
    }

    private void processSubtasks(Set<String> totalRecentIdSet, List<String> upperKeyIds, List<AlmIssueEntity> returnList) {
        if (ObjectUtils.isEmpty(upperKeyIds)) {
            return;
        }
        List<AlmIssueEntity> subtasksByUpperKeys = this.getSubtasksByUpperKeys(upperKeyIds);
        FilteredResults filteredResults = this.processAndFilterIssuesAndTrackNew(totalRecentIdSet, subtasksByUpperKeys, returnList);
        this.processIssues(totalRecentIdSet, filteredResults.getLinkedIds(), filteredResults.getUniqueIssues(), returnList);
    }

    private void processSubtasks(Set<String> totalRecentIdSet, List<String> upperKeyIds, List<AlmIssueEntity> returnList, String field, String startDate, String endDate) {
        if (ObjectUtils.isEmpty(upperKeyIds)) {
            return;
        }
        List<AlmIssueEntity> subtasksByUpperKeys = this.getSubtasksByUpperKeys(upperKeyIds, field, startDate, endDate);
        FilteredResults filteredResults = this.processAndFilterIssuesAndTrackNew(totalRecentIdSet, subtasksByUpperKeys, returnList);
        this.processIssues(totalRecentIdSet, filteredResults.getLinkedIds(), filteredResults.getUniqueIssues(), returnList, field, startDate, endDate);
    }

    private FilteredResults processAndFilterIssuesAndTrackNew(Set<String> totalRecentIdSet, List<AlmIssueEntity> issues, List<AlmIssueEntity> returnList) {
        HashSet<String> linkedIdSet = new HashSet<String>();
        ArrayList<AlmIssueEntity> uniqueIssues = new ArrayList<AlmIssueEntity>();
        for (AlmIssueEntity issue : issues) {
            if (!totalRecentIdSet.contains(issue.getRecentId())) {
                totalRecentIdSet.add(issue.getRecentId());
                returnList.add(issue);
                uniqueIssues.add(issue);
            }
            if (ObjectUtils.isEmpty(issue.getLinkedIssues())) continue;
            linkedIdSet.addAll(issue.getLinkedIssues());
        }
        linkedIdSet.removeIf(totalRecentIdSet::contains);
        return new FilteredResults(linkedIdSet, uniqueIssues);
    }

    @Generated
    public RequirementServiceImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

