/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.newsletter.controller;

import com.arms.api.newsletter.model.NewsletterDTO;
import com.arms.api.newsletter.model.NewsletterVO;
import com.arms.api.newsletter.service.NewsletterService;
import com.arms.api.util.response.CommonResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/newsletter"})
public class NewsletterController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsletterController.class);
    private final NewsletterService newsletterService;

    @PostMapping(value={"/addNewsletter"})
    public ResponseEntity<CommonResponse.ApiResult<NewsletterVO>> addNewsletter(@RequestBody NewsletterDTO newsletterDTO) {
        log.info("NewsletterController :: addNewsletter");
        return ResponseEntity.ok(CommonResponse.success(this.newsletterService.addNewsletter(newsletterDTO)));
    }

    @GetMapping(value={"/{newsletterId}"})
    public ResponseEntity<CommonResponse.ApiResult<NewsletterVO>> getNewsletter(@PathVariable(value="newsletterId") String newsletterId) {
        log.info("NewsletterController :: getNewsletter");
        return ResponseEntity.ok(CommonResponse.success(this.newsletterService.getNewsletter(newsletterId)));
    }

    @PutMapping(value={"/updateNewsletter"})
    public ResponseEntity<CommonResponse.ApiResult<NewsletterVO>> updateNewsletter(@RequestBody NewsletterDTO newsletterDTO) {
        log.info("NewsletterController :: updateNewsletter");
        return ResponseEntity.ok(CommonResponse.success(this.newsletterService.updateNewsletter(newsletterDTO)));
    }

    @DeleteMapping(value={"/{newsletterId}"})
    public ResponseEntity<CommonResponse.ApiResult<NewsletterVO>> deleteNewsletter(@PathVariable(value="newsletterId") String newsletterId) {
        log.info("NewsletterController :: deleteNewsletter");
        return ResponseEntity.ok(CommonResponse.success(this.newsletterService.deleteNewsletter(newsletterId)));
    }

    @Generated
    public NewsletterController(NewsletterService newsletterService) {
        this.newsletterService = newsletterService;
    }
}

