/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.bbs.service;

import com.arms.api.bbs.model.dto.BbsDTO;
import com.arms.api.bbs.model.entity.BbsEntity;
import com.arms.api.bbs.model.vo.BbsVO;
import com.arms.api.bbs.service.BbsService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.List;
import lombok.Generated;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class BbsServiceImpl
implements BbsService {
    private final EsCommonRepositoryWrapper<BbsEntity> esCommonRepositoryWrapper;

    @Override
    public String postMessage(BbsDTO bbsDTO) {
        BbsEntity save = this.esCommonRepositoryWrapper.save(bbsDTO.toBbsEntityWithCreate());
        save.viewCountInit();
        return save.getId();
    }

    @Override
    public String replyMessage(BbsDTO bbsDTO) {
        DocumentResultWrapper<BbsEntity> hits = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter("group_id", bbsDTO.getPath().split("/")[0]));
        if (hits.toDocs().isEmpty()) {
            throw new IllegalArgumentException("\uc0ad\uc81c\ub41c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.");
        }
        BbsEntity save = this.esCommonRepositoryWrapper.save(bbsDTO.toBbsEntityWithCreate());
        save.viewCountInit();
        return save.getId();
    }

    @Override
    public String checkPassword(BbsDTO bbsDTO) {
        BbsEntity findBbsEntity = this.esCommonRepositoryWrapper.findDocById(bbsDTO.getId());
        if (findBbsEntity == null) {
            throw new IllegalArgumentException("\uc0ad\uc81c\ub41c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.");
        }
        if (findBbsEntity.getPassword() != null && !findBbsEntity.getPassword().equals(bbsDTO.getPassword())) {
            throw new IllegalArgumentException("\ube44\ubc00\ubc88\ud638\uac00 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        return findBbsEntity.getId();
    }

    @Override
    public String updateBbsAndNewGroupId(BbsDTO bbsDTO) {
        String bbsId = this.updateBbsAndGetId(bbsDTO);
        BbsEntity bbsEntity = this.esCommonRepositoryWrapper.findDocById(bbsId);
        bbsEntity.getPostType().checkPostType();
        BbsDTO sourceBbsDTO = bbsDTO.toBbsDtoWithBoardTypeAndGroupId(bbsEntity);
        BbsVO bbsVO = this.bbsList(sourceBbsDTO);
        bbsEntity.generateGroupId();
        bbsVO.getBbsEntities().forEach(a -> {
            a.updateGroupIdAndPath(bbsEntity.getGroupId());
            this.esCommonRepositoryWrapper.save((BbsEntity)a);
        });
        return bbsDTO.getId();
    }

    @Override
    public String updateBbsAndGetId(BbsDTO bbsDTO) {
        BbsEntity findBbsEntity = this.esCommonRepositoryWrapper.findDocById(bbsDTO.getId());
        if (findBbsEntity == null) {
            throw new IllegalArgumentException("\uc0ad\uc81c\ub41c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.");
        }
        findBbsEntity.updateBbsEntity(bbsDTO.toBbsEntityWithUpdate());
        BbsEntity save = this.esCommonRepositoryWrapper.save(findBbsEntity);
        return save.getId();
    }

    @Override
    public String deleteBbsAndGetId(String deleteId) {
        BbsEntity bbsEntity = this.esCommonRepositoryWrapper.findDocById(deleteId);
        if (bbsEntity == null) {
            throw new IllegalArgumentException("\uac8c\uc2dc\uae00\uc774 \uc0ad\uc81c \ub418\uc5b4\uc11c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4..");
        }
        List<BbsEntity> docs = this.esCommonRepositoryWrapper.findHits(SimpleQuery.wildQueryQueryFilter("path", bbsEntity.getPath() + "*")).toDocs();
        for (BbsEntity doc : docs) {
            this.esCommonRepositoryWrapper.deleteById(doc.getId());
        }
        return deleteId;
    }

    @Override
    public BbsVO bbsList(BbsDTO bbsDTO) {
        DocumentResultWrapper<BbsEntity> docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(SimpleQuery.search(bbsDTO).andTermQueryFilter("board_type", bbsDTO.getBoardType()).andTermQueryFilter("post_type", bbsDTO.getPostType()).andTermQueryFilter("group_id", bbsDTO.getGroupId()).andTermQueryFilter("subject_name", bbsDTO.getSubjectName()).orderBy(SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field("path").sortType("asc").build()));
        List<BbsEntity> docs = docsBySearchAfter.toDocs();
        return BbsVO.builder().bbsEntities(docs).totalHits(docsBySearchAfter.getTotalHits()).searchAfter(docsBySearchAfter.getLastSortValue()).build();
    }

    private BbsVO getList(SimpleQuery<SearchDocDTO> simpleQuery) {
        DocumentResultWrapper<BbsEntity> docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(simpleQuery);
        List<BbsEntity> docs = docsBySearchAfter.toDocs();
        return BbsVO.builder().bbsEntities(docs).totalHits(docsBySearchAfter.getTotalHits()).searchAfter(docsBySearchAfter.getLastSortValue()).build();
    }

    @Override
    public BbsVO searchBbs(BbsDTO bbsDTO) {
        return this.getList(SimpleQuery.search(bbsDTO).andMatchQueryFilter("subject_name", bbsDTO.getSubjectName()).orderBy(SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field("path").sortType("asc").build()));
    }

    @Override
    public BbsVO sortBbs(BbsDTO bbsDTO, String field, String sortType) {
        return this.getList(SimpleQuery.termQueryFilter("board_type", bbsDTO.getBoardType()).andTermQueryFilter("post_type", bbsDTO.getPostType()).andTermQueryFilter("group_id", bbsDTO.getGroupId()).orderBy(SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field(field).sortType(sortType).build()));
    }

    @Override
    public List<BbsEntity> findPathById(String id) {
        BbsEntity bbsEntity = this.esCommonRepositoryWrapper.findDocById(id);
        if (bbsEntity == null) {
            throw new IllegalArgumentException("\uac8c\uc2dc\uae00\uc774 \uc0ad\uc81c \ub418\uc5b4\uc11c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4..");
        }
        List<BbsEntity> docs = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter("board_type", bbsEntity.getBoardType()).andTermQueryFilter("group_id", bbsEntity.getGroupId()).orderBy(SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field("path").sortType("asc").build())).toDocs();
        if (docs.isEmpty()) {
            throw new IllegalArgumentException("\uac8c\uc2dc\uae00\uc774 \uc0ad\uc81c \ub418\uc5b4\uc11c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4..");
        }
        return docs;
    }

    @Override
    @Async
    public void asyncViewCountUp(String id) {
        BbsEntity bbsEntity = this.esCommonRepositoryWrapper.findDocById(id);
        bbsEntity.viewCountUp();
        this.esCommonRepositoryWrapper.save(bbsEntity);
    }

    @Generated
    public BbsServiceImpl(EsCommonRepositoryWrapper<BbsEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

