////////////////////////////////////////////////////////////////////////////////////////
// Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		["../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js"],
		["../cover/css/blog/blog-detail.css"]
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			$(".widget").widgster();
			$("#sidebar").hide();
			$(".wrap").css("margin-left", 0);
			$("#footer").load("/cover/html/template/landing-footer.html");

			initializePage();
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}

var globalArticleId = new URLSearchParams(window.location.search).get("id");

function initializePage() {
	if (!globalArticleId) {
		showFullScreenError("not-found");
		return;
	}
	loadArticleDetail();
	defineEvents();
}

function loadArticleDetail() {
	$.ajax({
		url: "/auth-anon/api/arms/blog/getBlog.do",
		data: { c_id: globalArticleId },
		method: "GET",
		dataType: "json",
		success: function (article) {
			if (!article) {
				showFullScreenError("not-found");
				return;
			}

			renderArticleDetail(article);
			validateCrudButton();
		},
		error: function (xhr, status, error) {
			showFullScreenError("default");
		}
	});
}

function renderArticleDetail(article) {
	$("#article-title").text(article.c_blog_title);
	$("#article-desc").html(article.c_blog_desc);
	$("#article-author").text(article.c_blog_author_id || "익명");
	$("#article-date").text(new Date(article.c_blog_created).toLocaleString());
	$("#article-views").text("조회수 " + (article.c_blog_view_count || 0));
	$("#article-content").html(article.c_blog_contents);

	// 대표 이미지
	$("#featured-image")
		.attr("src", article.c_blog_thumbnail_url || "/cover/img/img-onerror.png")
		.attr("alt", article.title);

	// 댓글 수 업데이트 (여러 위치 동시 업데이트)
	$("#comment-btn-count").text(article.comments);
	$("#comment-count-display").text(article.comments);
}

////////////////////////////////////////////////////////////////////////////////////////
// 해시태그 렌더링 (JSON 데이터 사용)
////////////////////////////////////////////////////////////////////////////////////////
function renderHashtags(tags) {
	let tagsHtml = "";

	tags.forEach((tag) => {
		tagsHtml += `<span class="label label-default">${tag}</span> `;
	});

	$("#article-tags").html(tagsHtml).show();
}

////////////////////////////////////////////////////////////////////////////////////////
// Elancer 스타일 이벤트 리스너 - 간단한 댓글과 공유만
////////////////////////////////////////////////////////////////////////////////////////
function defineEvents() {
	const articleId = globalArticleId;

	$("#edit-article-btn").on("click", function () {
		window.location.href = `template.html?page=blogEditor&mode=edit&id=${articleId}`;
	});

	$("#delete-article-btn").on("click", function () {
		$("#confirmModal").modal("show");
	});

	$(document).on("click", "#delete-confirm-yes", function () {
		$("#confirmModal").modal("hide");

		$.ajax({
			url: "/auth-anon/api/arms/blog/removeBlog.do",
			type: "delete",
			data: { c_id: articleId },
			success: function () {
				jSuccess("블로그가 성공적으로 삭제되었습니다.");
				setTimeout(function () {
					window.location.href = "/cover/template.html?page=blog";
				}, 1500);
			}
		});
	});
}

function validateCrudButton() {
	function hideCrudButtons() {
		$("#edit-article-btn").hide();
		$("#delete-article-btn").hide();
	}

	$.ajax({
		url: "/auth-user/me",
		type: "GET",
		timeout: 7313,
		global: false,
		statusCode: {
			200: function (json) {
				const hasEditPermission = json.realm_access.roles.includes("ROLE_ADMIN");
				if (!hasEditPermission) {
					hideCrudButtons();
				}
			},
			401: function () {
				// 익명, 비로그인 사용자
				hideCrudButtons();
			}
		},
		error: function () {
			hideCrudButtons();
		}
	});
}

/**
 * 유틸 함수
 */
function showFullScreenError(errorCase, targetArgs = $(".blog-detail-container")) {
	const target = $(targetArgs);

	const getErrorHtml = (errorCode, title, message, iconClass) => `
    <div class="text-center" style="padding: 60px;">
        <i class="fa ${iconClass} fa-3x" style="color: #dc3545;"></i>
        <h3 style="margin-top: 20px;">${title}</h3>
        <p>${message}</p>
        <a href="template.html?page=blog" class="btn" style="margin-top: 20px; color: #313131; background: white; border: 1px solid #ddd;">블로그 홈으로</a>
    </div>
  `;

	let errorHtml;

	switch (errorCase) {
		case "not-found":
			errorHtml = getErrorHtml(
				"not-found",
				"아티클을 찾을 수 없습니다",
				"요청하신 아티클이 존재하지 않거나 삭제되었습니다.",
				"fa-exclamation-triangle"
			);
			break;
		case "not-authorized":
			errorHtml = getErrorHtml("not-authorized", "권한이 없습니다", "이 작업을 수행할 권한이 없습니다.", "fa-lock");
			break;
		default:
			errorHtml = getErrorHtml(
				"default",
				"알 수 없는 오류가 발생했습니다",
				"잠시 후 다시 시도해주세요.",
				"fa-exclamation-triangle"
			);
			break;
	}
	$(target).html(errorHtml);
}

// 날짜 형식 변환 (18일 전 → 2025. 01. 23)
function convertDate(dateStr) {
	if (dateStr.includes("일 전")) {
		const daysAgo = parseInt(dateStr.replace("일 전", ""));
		const date = new Date();
		date.setDate(date.getDate() - daysAgo);
		return `${date.getFullYear()}. ${String(date.getMonth() + 1).padStart(2, "0")}. ${String(date.getDate()).padStart(
			2,
			"0"
		)}`;
	}
	return "2025. 01. 23"; // 기본값
}
