/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.Yaml;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class GiteaFileUtil {
    private static final Logger log = LoggerFactory.getLogger(GiteaFileUtil.class);
    @Value(value="${gitea.replace-url}")
    private String replaceUrlValue;
    private static String replaceUrl;

    @PostConstruct
    public void init() {
        replaceUrl = this.replaceUrlValue;
    }

    public static List<String> getJsonFileDownloadUrlsInDirectory(String directoryUrl, String branch, String username, String password) throws Exception {
        ArrayList<String> jsonFileUrls = new ArrayList<String>();
        log.info("[ GiteaUtils :: getJsonFileDownloadUrlsInDirectory ] :: directoryUrl => {}, branch => {}", (Object)directoryUrl, (Object)branch);
        HttpURLConnection connection = (HttpURLConnection)new URL(directoryUrl + "?ref=" + branch).openConnection();
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        connection.setRequestProperty("Accept", "application/json");
        if (connection.getResponseCode() != 200) {
            throw new RuntimeException("Failed to fetch directory: " + connection.getResponseMessage());
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            ObjectMapper mapper = new ObjectMapper();
            List files = (List)mapper.readValue((Reader)reader, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (Map file : files) {
                String type = (String)file.get("type");
                String downloadUrl = (String)file.get("download_url");
                String parsedUrl = GiteaFileUtil.rewriteGiteaUrl((String)downloadUrl);
                if (!"file".equals(type) || !parsedUrl.endsWith(".json")) continue;
                jsonFileUrls.add(parsedUrl);
            }
            ArrayList<String> arrayList = jsonFileUrls;
            return arrayList;
        }
    }

    public static List<String> getJsonFileUrlsInDirectory(String directoryUrl, String branch, String username, String password) throws Exception {
        ArrayList<String> jsonFileUrls = new ArrayList<String>();
        log.info("[ GiteaUtils :: getJsonFileUrlsInDirectory ] :: directoryUrl => {}, branch => {}", (Object)directoryUrl, (Object)branch);
        HttpURLConnection connection = (HttpURLConnection)new URL(directoryUrl + "?ref=" + branch).openConnection();
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        connection.setRequestProperty("Accept", "application/json");
        if (connection.getResponseCode() != 200) {
            throw new RuntimeException("Failed to fetch directory: " + connection.getResponseMessage());
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            ObjectMapper mapper = new ObjectMapper();
            List files = (List)mapper.readValue((Reader)reader, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (Map file : files) {
                String type = (String)file.get("type");
                String fileUrl = (String)file.get("url");
                String parsedUrl = GiteaFileUtil.rewriteGiteaUrl((String)fileUrl);
                if (!"file".equals(type) || !parsedUrl.endsWith(".json?ref=" + branch)) continue;
                jsonFileUrls.add(parsedUrl);
            }
            ArrayList<String> arrayList = jsonFileUrls;
            return arrayList;
        }
    }

    public static List<String> getYamlFilesFromDirectory(String directoryUrl, String branch, String username, String password) throws Exception {
        ArrayList<String> yamlFiles = new ArrayList<String>();
        log.info("[ GiteaFileUtil :: getYamlFilesFromDirectory ] :: directoryUrl => {}, branch => {}", (Object)directoryUrl, (Object)branch);
        HttpURLConnection connection = (HttpURLConnection)new URL(directoryUrl + "?ref=" + branch).openConnection();
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        if (connection.getResponseCode() != 200) {
            throw new RuntimeException("Failed to fetch directory: " + connection.getResponseMessage());
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            Yaml yaml = new Yaml();
            List files = (List)yaml.load((Reader)reader);
            for (Map fileInfo : files) {
                String type = (String)fileInfo.get("type");
                String downloadUrl = (String)fileInfo.get("download_url");
                String parsedDownloadUrl = GiteaFileUtil.rewriteGiteaUrl((String)downloadUrl);
                log.info("[ GiteaFileUtil :: getYamlFilesFromDirectory ] :: type => {}, parsedDownloadUrl => {}", (Object)type, (Object)parsedDownloadUrl);
                if (!"file".equals(type) || !parsedDownloadUrl.endsWith(".yml") && !parsedDownloadUrl.endsWith(".yaml")) continue;
                yamlFiles.add(parsedDownloadUrl);
            }
        }
        return yamlFiles;
    }

    public static String extractFileNameWithoutExtension(String fileUrl) {
        String fullFileName = fileUrl.substring(fileUrl.lastIndexOf(47) + 1);
        return fullFileName.substring(0, fullFileName.lastIndexOf(46));
    }

    public static String rewriteGiteaUrl(String url) {
        String regex = "(https?://)([^/]+)(/gitea)";
        return url.replaceAll(regex, replaceUrl);
    }
}

