/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.languageconfig.controller;

import com.arms.api.languageconfig.model.vo.LanguagePackFileVO;
import com.arms.api.languageconfig.model.vo.SingleLanguagePackVO;
import com.arms.api.languageconfig.service.LanguageConfigService;
import com.arms.egovframework.javaservice.gcframework.model.RepoType;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth-sche/language-config"})
public class LanguageConfigController {
    private static final Logger log = LoggerFactory.getLogger(LanguageConfigController.class);
    private final LanguageConfigService languageConfigService;

    @GetMapping(value={"/packs/files"})
    public ResponseEntity<List<LanguagePackFileVO>> getLanguagePackFilesNew(@RequestParam(defaultValue="GITEA") RepoType repoType) {
        log.info("[ LanguageConfigController :: getLanguagePackFilesNew ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.getLanguagePackFiles(repoType));
    }

    @GetMapping(value={"/packs/language/{language}"})
    public ResponseEntity<SingleLanguagePackVO> getSingleLanguagePack(@PathVariable String language) {
        log.info("[ LanguageConfigController :: getSingleLanguagePack ] language: {}, \ub3d9\uc791 : {}", (Object)language, (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.getSingleLanguagePack(language));
    }

    @PutMapping(value={"/packs/language/{language}"})
    public ResponseEntity<String> updateSingleLanguagePack(@PathVariable String language, @RequestBody List<Map<String, String>> data) throws IOException {
        log.info("[ LanguageConfigController :: updateSingleLanguagePack ] language: {}, \ub3d9\uc791 : {}", (Object)language, (Object)Calendar.getInstance().getTime());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map<String, String> item : data) {
            resultMap.putAll(item);
        }
        return ResponseEntity.ok((Object)this.languageConfigService.updateSingleLanguagePack(language, resultMap));
    }

    @GetMapping(value={"/packs/language/{language}/refresh"})
    public ResponseEntity<SingleLanguagePackVO> refreshSingleLanguagePack(@PathVariable String language) {
        log.info("[ LanguageConfigController :: refreshSingleLanguagePack] :: refresh single language => {}", (Object)language);
        return ResponseEntity.ok((Object)this.languageConfigService.refreshSingleLanguagePack(language));
    }

    @DeleteMapping(value={"/packs/language/{language}"})
    public ResponseEntity<String> deleteSingleLanguagePack(@PathVariable String language) {
        log.info("[ LanguageConfigController :: deleteSingleLanguagePack ] language: {}, \ub3d9\uc791 : {}", (Object)language, (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.deleteSingleLanguagePack(language));
    }

    @GetMapping(value={"/packs/all-contents"})
    public ResponseEntity<List<SingleLanguagePackVO>> getAllLanguagePackContents() {
        log.info("[ LanguageConfigController :: getAllLanguagePackContents ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.getAllLanguagePackContents());
    }

    @GetMapping(value={"/packs/all-contents/refresh"})
    public ResponseEntity<List<SingleLanguagePackVO>> refreshAllLanguagePackContents() {
        log.info("[ LanguageConfigController :: refreshAllLanguagePackContents ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.languageConfigService.refreshAllLanguagePackContents());
    }

    @GetMapping(value={"/packs/language/{language}/keys/exists"})
    public ResponseEntity<List<String>> checkLanguageKeyExists(@PathVariable String language, @RequestParam(value="keys") List<String> keys) {
        log.info("[ LanguageConfigController :: checkLanguageKeyExists ] \ub3d9\uc791 : {}, NO. of keys : {}", (Object)Calendar.getInstance().getTime(), (Object)keys.size());
        return ResponseEntity.ok((Object)this.languageConfigService.checkLanguageKeyExists(language, keys));
    }

    public LanguageConfigController(LanguageConfigService languageConfigService) {
        this.languageConfigService = languageConfigService;
    }
}

