package com.arms.api.util;

import org.springframework.util.ObjectUtils;

import java.util.regex.Pattern;

public class ParseUtil {

    public static String extractUsernameFromEmail(String emailAddress) {
        // Email Regular Expression
        String EMAIL_REGEX = "^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$";

        // EmailAddress Validation
        if (emailAddress == null || !Pattern.matches(EMAIL_REGEX, emailAddress)) {
            return null; // invalid then return null
        }

        int atIndex = emailAddress.indexOf('@');
        if (atIndex > 0) {
            return emailAddress.substring(0, atIndex);
        }

        return null;
    }

    /**
     * 주어진 문자열에서 마지막 구분자('_') 뒤의 문자열을 추출합니다.
     * @param ids 구분자로 연결된 문자열 (예: "aaaa_bbb_ccc")
     * @return 마지막 요소 (예: "ccc"), 구분자가 없거나 문자열이 비어 있으면 전체 문자열 또는 null
     */
    public static String getLastSegment(String ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return null; // 또는 ""
        }

        // '_'를 기준으로 문자열을 분할하여 배열로 만듭니다.
        String[] parts = ids.split("_");

        // 배열의 마지막 인덱스는 parts.length - 1 입니다.
        // 배열이 비어있지 않다면, 마지막 요소를 반환합니다.
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }

        // 분할 결과가 비어있다면, 원본 문자열을 반환하거나 null을 반환할 수 있습니다.
        // 여기서는 원본 문자열을 반환하도록 처리합니다.
        return ids;
    }

    /**
     * 주어진 문자열에서 마지막 구분자('_')와 그 뒤의 문자열을 제외한 앞부분을 추출합니다.
     * 구분자는 포함됩니다. (예: "aaaa_bbb_ccc" -> "aaaa_bbb_")
     * * @param ids 구분자로 연결된 문자열 (예: "aaaa_bbb_ccc")
     * @return 마지막 구분자를 포함한 앞부분 (예: "aaaa_bbb_"), 구분자가 없으면 전체 문자열 또는 null
     */
    public static String getPrefixIncludingLastDelimiter(String ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return ids; // null 또는 빈 문자열 반환
        }

        // 1. 마지막 '_'의 위치를 찾습니다.
        int lastIndex = ids.lastIndexOf('_');

        // 2. '_'가 없는 경우, 전체 문자열을 반환합니다.
        if (lastIndex == -1) {
            return ids;
        }

        // 3. 마지막 '_'의 위치(lastIndex)까지 자릅니다.
        // substring(0, lastIndex + 1)를 사용하여 인덱스 0부터 마지막 '_'의 위치까지 포함하여 반환합니다.
        return ids.substring(0, lastIndex + 1);
    }

    public static String timeFormat(int 분) {

        // 1주 = 5일, 1일 = 8시간, 1시간 = 60분
        int 주 = 분 / (5 * 8 * 60);
        int 일 = (분 % (5 * 8 * 60)) / (8 * 60);
        int 시간 = (분 % (8 * 60)) / 60;
        int 남은시간 = 분 % 60;

        StringBuilder 포맷팅 = new StringBuilder();
        if (주 > 0) {
            포맷팅.append(주).append("w ");
        }
        if (일 > 0) {
            포맷팅.append(일).append("d ");
        }
        if (시간 > 0) {
            포맷팅.append(시간).append("h ");
        }
        if (남은시간 > 0 || (주 == 0 && 일 == 0 && 시간 == 0)) {
            포맷팅.append(남은시간).append("m ");
        }

        return 포맷팅.toString().trim();
    }
}
