package com.arms.api.issue.priority.controller;

import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.priority.service.IssuePriorityService;
import com.arms.api.util.errors.ErrorCode;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/{connectId}/jira/issuepriority")
@AllArgsConstructor
public class IssuePriorityController {

    private final IssuePriorityService issuePriorityService;

    @ResponseBody
    @RequestMapping(
            value = {"/list"},
            method = {RequestMethod.GET}
    )
    public List<IssuePriorityDTO> getIssuePriorityList(@PathVariable("connectId") String connectId) {

        if (connectId == null) {
            String errorMessage = String.format("getIssuePriorityList Error: connectId %s",
                    ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
            log.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }

        return issuePriorityService.getIssuePriorityList(connectId);
    }

}
