package com.arms.api.analysis.cost.model.vo;

import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

import java.util.*;

@Getter
@Builder
@AllArgsConstructor
public class AssigneeTimeDiffDataVO {

    private String accountId;
    private String assigneeName;
    private String emailAddress;

    private String salary;
    private String estimatedCostForDaysPeriod;
    private String estimatedCostForMillisPeriod;

    private List<String> reqLinkList;
    // reqInfo
//    private Long reqCount;
    private Long reqDaysDiff;
    private Long reqMillisDiff;
    // notReqInfo
//    private Long notReqCount;
    private Long notReqDaysDiff;
    private Long notReqMillisDiff;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setReqLinkList(List<String> reqLinkList) {
        this.reqLinkList = reqLinkList;
    }

    public void setReqMillisDiff(Long reqMillisDiff) {
        this.reqMillisDiff = reqMillisDiff;
    }

    public void setNotReqDaysDiff(Long notReqDaysDiff) {
        this.notReqDaysDiff = notReqDaysDiff;
    }

    public void setNotReqMillisDiff(Long notReqMillisDiff) {
        this.notReqMillisDiff = notReqMillisDiff;
    }

    public void setReqDaysDiff(Long reqDaysDiff) {
        this.reqDaysDiff = reqDaysDiff;
    }

    public void setAssigneeInfo(UniqueAssigneeVO assigneeInfo) {
        this.assigneeName = assigneeInfo.getName();
        this.emailAddress = assigneeInfo.getEmailAddress();
    }

}
