function execDocReady() {
	var pluginGroups = [
		[
			"../reference/lightblue4/docs/lib/widgster/widgster.js",
			"../reference/lightblue4/docs/lib/slimScroll/jquery.slimscroll.min.js",
			"../reference/jquery-plugins/jstree-v.pre1.0/_lib/jquery.cookie.js",
			"../reference/jquery-plugins/jstree-v.pre1.0/_lib/jquery.hotkeys.js",
			"../reference/jquery-plugins/jstree-v.pre1.0/jquery.jstree.js"
		],
		[
			"../reference/jquery-plugins/stompjs-develop/bundles/stomp.umd.min.js",
			"../reference/jquery-plugins/sockjs-client-main/dist/sockjs.min.js"
		],
		[
			"../reference/jquery-plugins/select2-4.0.2/dist/css/select2_lightblue4.css",
			"../reference/jquery-plugins/select2-4.0.2/dist/js/select2.min.js",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/css/multiselect-lightblue4.css",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.quicksearch.js",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.multi-select.js",
			"../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select-bluelight.css",
			"../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select.min.js"
		],
		[
			"./js/adms/session-manager.js",
			"./js/adms/wiki-list.js",
			"./js/adms/editor-operation.js",
			"../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.min.css",
			"../reference/light-blue/lib/bootstrap-datepicker.js",
			"../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.full.min.js"
		]
	];

	loadPluginGroupsParallelAndSequential(pluginGroups).then(function () {
		console.log("모든 플러그인 로드 완료");

		$(".widget").widgster();
		setSideMenu("sidebar_large_menu_ai", "sidebar_medium_menu_ai_adms", "sidebar_small_menu_ai_adms");

		//Select2
		makePdServiceSelectBox();
		//버전 멀티 셀렉트 박스 이니시에이터
		makeVersionMultiSelectBox();

		var waitCKEDITOR = setInterval(function () {
			try {
				if (window.CKEDITOR) {
					if (window.CKEDITOR.status === "loaded") {
						CKEDITOR.replace("add_tabmodal_editor");

						clearInterval(waitCKEDITOR);
					}
				}
			} catch (err) {
				console.log("CKEDITOR 로드가 완료되지 않아서 초기화 재시도 중...");
			}
		}, 313 /*milli*/);

		$("#editor").trigger("init.editor");

		CKEDITOR.instances["editor"].on("contentDom", function (event) {
			var editor = event.editor;
			var editable = editor.editable();

			editable.attachListener(editor.document, "keyup", function (keyupEvent) {
				// sessoinManager.remoteUserUpdate(editor.getSelection(), keyupEvent.data.$);
				sessoinManager.remoteUserUpdate(editor.getData());
			});
		});

		var userInfo = {
			userId: userID,
			userName: userName,
			userColor: generateRandomHexColor()
		};
		var sessoinManager = $.sessionManager(StompJs.Client, SockJS, userInfo);
		sessoinManager.onContentsChange = function (contents) {
			// console.log(CKEDITOR.instances["editor"]);
			// console.log(CKEDITOR.instances["editor"].getSelection().root.$);

			// console.log(contents);

			// console.log(contents.cursorPosition.lineNumber);

			// CKEDITOR.instances["editor"].getSelection().root.$.querySelectorAll("p")[
			// 	contents.cursorPosition.lineNumber
			// ].textContent = contents.selection.message;

			CKEDITOR.instances["editor"].setData(contents.selection.message);
		};

		$("#btn_edit_contents").on("click", function () {
			var $btn = $(this);

			if ($btn.hasClass("btn-success")) {
				$btn.removeClass("btn-success").addClass("btn-primary");
				$btn.empty();
				$btn.append("<i class='fa fa-file' />").append(" 저장");
				CKEDITOR.instances["editor"].setReadOnly(false);

				sessoinManager.setRoom(getWikiId()).done(function () {
					sessoinManager.openWebsocket();
				});
			} else {
				$.ajax({
					type: "PUT",
					url: "/auth-user/api/arms/wiki/updateWiki.do",
					contentType: "application/json;charset=UTF-8",
					dataType: "json",
					data: JSON.stringify({
						wikiId: getWikiId(),
						author: userID,
						contents: CKEDITOR.instances["editor"].getData()
					}),
					success: function () {
						$btn.addClass("btn-success").removeClass("btn-primary");
						$btn.empty();
						$btn.append("<i class='fa fa-edit' />").append(" 수정");
						CKEDITOR.instances["editor"].setReadOnly(true);
						sessoinManager.closeRoom();
					}
				});
			}
		});

		$(".js-data-example-ajax").select2({
			maximumSelectionLength: 5,
			width: "resolve",
			ajax: {
				url: function (params) {
					return "/auth-user/search-user/" + params.term;
				},
				dataType: "json",
				delay: 250,
				processResults: function (data, params) {
					params.page = params.page || 1;

					return {
						results: data,
						pagination: {
							more: params.page * 30 < data.total_count
						}
					};
				},
				cache: true
			},
			placeholder: "리뷰어 설정을 위한 계정명을 입력해 주세요",
			minimumInputLength: 1,
			templateResult: formatUser,
			templateSelection: formatUserSelection
		});

		$("#save_req").click(function () {
			var table_name = "T_ARMS_REQADD_" + $("#selected_pdService").val();
			var c_type_value;
			if (isEmpty($("input[name=reqType]:checked").val())) {
				c_type_value = "default";
			} else {
				c_type_value = $("input[name=reqType]:checked").val();
			}

			var req_title = $("#addview_req_title").val().trim();
			if (!req_title) {
				jError("요구사항 제목이 없습니다.");
				return false;
			}

			var versionset_link = $("#add_multi_version").val();
			if (versionset_link.length < 1) {
				jError("선택된 버전이 없습니다.");
				return false;
			}

			var reviewers01 = getReviewer(0, "addview_req_reviewers");
			var reviewers02 = getReviewer(1, "addview_req_reviewers");
			var reviewers03 = getReviewer(2, "addview_req_reviewers");
			var reviewers04 = getReviewer(3, "addview_req_reviewers");
			var reviewers05 = getReviewer(4, "addview_req_reviewers");

			var select_req_priority_link =
				$("#addview_req_priority .btn.active input").val() === undefined
					? "5"
					: $("#addview_req_priority .btn.active input").val();
			var select_req_difficulty_link =
				$("#addview_req_difficulty .btn.active input").val() === undefined
					? "5"
					: $("#addview_req_difficulty .btn.active input").val();
			var select_req_state_link = $("#addview_req_state input[name='addview_req_state_options']:checked").val();
			if (select_req_state_link === undefined) {
				jError("요구사항 상태가 선택되지 않았습니다.");
				return false;
			}

			var start_date_value = $("#addview_req_start_date").val();
			var c_req_start_date;
			if (start_date_value) {
				c_req_start_date = new Date(start_date_value);
			}

			var end_date_value = $("#addview_req_end_date").val();
			var c_req_end_date;
			if (end_date_value) {
				c_req_end_date = new Date(end_date_value);
			}

			var data_object_param = {
				ref: 2,
				c_title: req_title,
				c_type: c_type_value,
				c_req_pdservice_link: $("#selected_pdService").val(),
				c_req_pdservice_versionset_link: JSON.stringify(versionset_link),
				c_req_start_date: c_req_start_date,
				c_req_end_date: c_req_end_date,
				c_req_writer: "[" + userName + "]" + " - " + userID,
				c_req_contents: CKEDITOR.instances["add_tabmodal_editor"].getData()
			};

			if (c_type_value === "default") {
				Object.assign(data_object_param, {
					c_req_priority_link: select_req_priority_link,
					c_req_difficulty_link: select_req_difficulty_link,
					c_req_state_link: select_req_state_link,
					c_req_reviewer01: reviewers01,
					c_req_reviewer02: reviewers02,
					c_req_reviewer03: reviewers03,
					c_req_reviewer04: reviewers04,
					c_req_reviewer05: reviewers05,
					c_req_reviewer01_status: "Draft",
					c_req_reviewer02_status: "Draft",
					c_req_reviewer03_status: "Draft",
					c_req_reviewer04_status: "Draft",
					c_req_reviewer05_status: "Draft"
				});
			}

			console.log("save_req :: save data ->");
			console.log(data_object_param);

			var success_message =
				c_type_value === "default"
					? "신규 요구사항 ( " + req_title + " )이 추가되었습니다."
					: " 요구사항 폴더 ( " + req_title + " )가 등록되었습니다.";

			$.ajax({
				url: "/auth-user/api/arms/reqAdd/" + table_name + "/addNode.do",
				type: "POST",
				data: data_object_param,
				success: function () {
					var reqLink = new CKEDITOR.dom.element("a", CKEDITOR.instances["editor"].document);
					reqLink.setAttribute("href", "/arms/detail.html");
					reqLink.setAttribute("target", "_blank");
					reqLink.$.textContent = CKEDITOR.instances["editor"].getSelection().getSelectedText();

					CKEDITOR.instances["editor"].insertElement(reqLink);

					jSuccess(success_message);
				}
			});
		});

		var $wikiTree = $("#wiki_tree");
		$("#btn_create_file").on("click", function () {
			var selectedWiki = $wikiTree.jstree("get_selected");

			if (selectedWiki.length === 0) {
				selectedWiki = $("#node_2");
			}

			$wikiTree.jstree("create", selectedWiki, "last", {
				attr: {
					rel: "default"
				}
			});
		});
		$("#btn_create_folder").on("click", function (obj) {
			var selectedWiki = $wikiTree.jstree("get_selected");

			if (selectedWiki.length === 0) {
				selectedWiki = $("#node_2");
			}

			$wikiTree.jstree("create", selectedWiki, "last", {
				attr: {
					rel: "folder"
				}
			});
		});
		$("#btn_collapse_all").on("click", function () {
			$wikiTree.jstree("close_all");
		});

		$("#mmenu .form-search").submit(function (event) {
			event.preventDefault();

			$wikiTree.jstree("search", document.getElementById("text").value);
		});
	});
}

function formatUser(jsonData) {
	var $container = $(
		"<div class='select2-result-jsonData clearfix'>" +
			"<div class='select2-result-jsonData__meta'>" +
			"<div class='select2-result-jsonData__username'><i class='fa fa-flash'></i></div>" +
			"<div class='select2-result-jsonData__id'><i class='fa fa-star'></i></div>" +
			"</div>" +
			"</div>"
	);

	$container.find(".select2-result-jsonData__username").text(jsonData.username);
	$container.find(".select2-result-jsonData__id").text(jsonData.id);

	return $container;
}

// --- select2 (사용자 자동완성 검색 ) templateSelection 설정 --- //
function formatUserSelection(jsonData) {
	if (jsonData.id == "") {
		jsonData.text = "placeholder";
	} else {
		if (jsonData.username == undefined) {
			jsonData.text = jsonData.id;
		} else {
			jsonData.text = "[" + jsonData.username + "] - " + jsonData.id;
		}
	}
	return jsonData.text;
}

function getReviewer(index, req_reviewers_id) {
	var reviewer = "none";
	if ($("#" + req_reviewers_id).select2("data")[index] != undefined) {
		reviewer = $("#" + req_reviewers_id).select2("data")[0].text;
	}
	return reviewer;
}

function getWikiId() {
	var selectedJsTreeId = $("#wiki_tree").jstree("get_selected").attr("id").replace("node_", "").replace("copy_", "");

	return "WIKI_" + $("#selected_pdService").val() + "_" + selectedJsTreeId;
}

function generateRandomHexColor() {
	var randomColor = Math.floor(Math.random() * 16777216);
	var hexColor = randomColor.toString(16);

	while (hexColor.length < 6) {
		hexColor = "0" + hexColor;
	}

	return "#" + hexColor;
}

function tableSelectOption(obj) {
	var $li = $("<li />").append(`<a href="#reqTable" data-toggle="tab" aria-expanded="false">${obj.c_title}</a>`);
	var $title = $("#tableTitle");

	$li.on("click", function () {
		tableSelect(obj.c_id);
		$title.text(obj.c_title);
	});

	return $li;
}

function filterList() {
	var searchText = $("#searchInput").val().toLowerCase();
	var hasResults = false;

	$("#reqAddTableSelect li:not(:first)").each(function () {
		var itemText = $(this).text().toLowerCase();
		if (itemText.includes(searchText)) {
			$(this).show();
			hasResults = true;
		} else {
			$(this).hide();
		}
	});

	if (!hasResults) {
		if ($("#noResultsMessage").length === 0) {
			$("#reqAddTableSelect").append(
				'<li id="noResultsMessage" class="text-center text-muted" >검색 결과가 없습니다.</li>'
			);
		}
	} else {
		$("#noResultsMessage").remove();
	}
}

function build_ReqData_By_PdService() {
	var $btn = $("#btn_edit_contents");
	$btn.addClass("hidden btn-success").removeClass("btn-primary");
	$btn.empty();
	$btn.append("<i class='fa fa-edit' />").append(" 수정");

	CKEDITOR.instances["editor"].setData("");
	CKEDITOR.instances["editor"].setReadOnly(true);
}

function bind_VersionData_By_PdService() {
	$(".multiple-select option").remove();
	$.ajax({
		url: "/auth-user/api/arms/pdService/getVersionList?c_id=" + $("#selected_pdService").val(),
		type: "GET",
		dataType: "json",
		progress: true,
		statusCode: {
			200: function (data) {
				//////////////////////////////////////////////////////////
				for (var k in data.response) {
					var obj = data.response[k];
					var $opt = $("<option />", {
						value: obj.c_id,
						text: obj.c_title
					});
					$(".multiple-select").append($opt);
				}

				if (data.length > 0) {
					console.log("[ reqAdd :: bind_VersionData_By_PdService ] :: result = display 재설정.");
				}
				$(".multiple-select").multipleSelect("refresh");
				//////////////////////////////////////////////////////////
				jSuccess("버전 조회가 완료 되었습니다.");
			}
		},
		error: function (e) {
			jError("버전 조회 중 에러가 발생했습니다.");
		}
	});
}

function makePdServiceSelectBox() {
	//제품 서비스 셀렉트 박스 이니시에이터
	$(".chzn-select").each(function () {
		$(this).select2($(this).data());
	});

	//제품 서비스 셀렉트 박스 데이터 바인딩
	$.ajax({
		url: "/auth-user/api/arms/pdServicePure/getPdServiceMonitor.do",
		type: "GET",
		success: function (data) {
			//////////////////////////////////////////////////////////
			$("#reqAddTableSelect").append(
				'<li><input type="search" id="searchInput" class="form-control searchDarkBack" placeholder="Search Product"></li>'
			);

			for (var k in data.response) {
				var obj = data.response[k];
				$("#reqAddTableSelect").append(tableSelectOption(obj));

				var newOption = new Option(obj.c_title, obj.c_id, false, false);
				$("#selected_pdService").append(newOption).trigger("change");
			}
			$("#searchInput").on("keyup", filterList);
			$("#searchInput").on("keydown", function (e) {
				if (e.key === " ") {
					e.preventDefault();
					$(this).val($(this).val() + " ");
				}
			});

			var urlParams = new URL(location.href).searchParams;
			var pdServiceId = urlParams.get("pdServiceId");

			if (pdServiceId !== null) {
				console.log(pdServiceId);

				$("#selected_pdService").val(parseInt(pdServiceId)).trigger("change");
				$("#selected_pdService").val(parseInt(pdServiceId)).trigger("select2:select");
			}
			//////////////////////////////////////////////////////////
			jSuccess("제품(서비스) 조회가 완료 되었습니다.");
		},
		error: function (e) {
			jError("제품(서비스) 조회 중 에러가 발생했습니다.");
		}
	});

	$("#selected_pdService").on("select2:open", function () {
		makeSlimScroll(".select2-results__options");
	});

	// --- select2 ( 제품(서비스) 검색 및 선택 ) 이벤트 --- //
	$("#selected_pdService").on("select2:select", function (e) {
		// 제품( 서비스 ) 선택했으니까 자동으로 버전을 선택할 수 있게 유도
		// 디폴트는 base version 을 선택하게 하고 ( select all )

		// 선택된 제품(서비스) 데이터 바인딩
		var selectedService = $("#selected_pdService").select2("data")[0].text;

		$("#select_PdService").text(selectedService);

		var selectedHtml =
			`<div class="chat-message">
				<div class="chat-message-body" style="margin-left: 0px !important;">
					<span class="arrow" style="top: 35% !important;"></span>
					<span class="sender" style="padding-bottom: 5px; padding-top: 3px;"> 선택된 서버 :  </span>
					<span class="text" style="color: #a4c6ff;">
					` +
			selectedService +
			`
					</span>
				</div>
			</div>
			`;
		$("#reqSender").html(selectedHtml); // 선택된 제품(서비스)

		//~> 이벤트 연계 함수 :: 요구사항 표시 jsTree 빌드
		//서비스(어플리케이션) 트리 로드
		build_ReqData_By_PdService();
		$("#wiki_tree").trigger("create.wikiList");

		//~> 이벤트 연계 함수 :: Version 표시 jsTree 빌드
		bind_VersionData_By_PdService();

		$("#tree_util_btn_wrapper").removeClass("hidden");
	});
} // end makePdServiceSelectBox()

function makeVersionMultiSelectBox() {
	//버전 선택 셀렉트 박스 이니시에이터
	$(".multiple-select").multipleSelect();
}
