/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config.security;

import com.arms.config.handler.AuthSuccessHandler;
import com.arms.config.handler.KeycloakLogoutHandler;
import com.arms.config.handler.component.AuthSuccessAfterDuplicateUserRemove;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.DelegatingServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.WebSessionServerLogoutHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Configuration
@EnableWebFluxSecurity
@EnableGlobalMethodSecurity(jsr250Enabled=true)
@RefreshScope
public class SecurityConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Value(value="${spring.security.auth.success.redirect-url}")
    private String redirectUrl;
    private final AuthSuccessAfterDuplicateUserRemove authSuccessAfterDuplicateUserRemove;
    private final KeycloakLogoutHandler keycloakLogoutHandler;

    public SecurityConfiguration(KeycloakLogoutHandler keycloakLogoutHandler, AuthSuccessAfterDuplicateUserRemove authSuccessAfterDuplicateUserRemove) {
        this.keycloakLogoutHandler = keycloakLogoutHandler;
        this.authSuccessAfterDuplicateUserRemove = authSuccessAfterDuplicateUserRemove;
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        DelegatingServerLogoutHandler logoutHandler = new DelegatingServerLogoutHandler(new ServerLogoutHandler[]{new WebSessionServerLogoutHandler(), this.keycloakLogoutHandler});
        return http.cors(ServerHttpSecurity.CorsSpec::disable).csrf(ServerHttpSecurity.CsrfSpec::disable).authorizeExchange(authorize -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorize.pathMatchers(new String[]{"/login"})).permitAll().pathMatchers(new String[]{"/middle-proxy-api"})).permitAll().pathMatchers(new String[]{"/middle-proxy-api/**"})).permitAll().pathMatchers(new String[]{"/backend-core-api"})).permitAll().pathMatchers(new String[]{"/backend-core-api/**"})).permitAll().pathMatchers(new String[]{"/engine-fire-api"})).permitAll().pathMatchers(new String[]{"/engine-fire-api/**"})).permitAll().pathMatchers(new String[]{"/bbs/**"})).permitAll().pathMatchers(new String[]{"/mapping/**"})).permitAll().pathMatchers(new String[]{"/dwr/**"})).permitAll().pathMatchers(new String[]{"/auth-anon/**", "/auth-sche/**"})).permitAll().pathMatchers(new String[]{"/engine-search-api/**"})).hasAnyRole(new String[]{"USER", "MANAGER", "ADMIN"}).pathMatchers(new String[]{"/auth-user/**", "/auth-check/**"})).hasAnyRole(new String[]{"USER", "MANAGER", "ADMIN"}).pathMatchers(new String[]{"/auth-manager/**"})).hasAnyRole(new String[]{"MANAGER", "ADMIN"}).pathMatchers(new String[]{"/auth-admin/**"})).hasRole("ADMIN").anyExchange().authenticated()).exceptionHandling().authenticationEntryPoint((exchange, denied) -> exchange.getSession().map(session -> {
            String referer = exchange.getRequest().getHeaders().getFirst("referer");
            session.getAttributes().put("rd-page", referer);
            return Mono.empty();
        }).then(Mono.error((Throwable)new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Session is null")))).and().oauth2Login().authenticationSuccessHandler((ServerAuthenticationSuccessHandler)new AuthSuccessHandler(this.authSuccessAfterDuplicateUserRemove, this.redirectUrl)).and().logout(logout -> logout.logoutUrl("/logout").logoutHandler((ServerLogoutHandler)logoutHandler).logoutSuccessHandler((webFilterExchange, authentication) -> {
            ServerWebExchange exchange = webFilterExchange.getExchange();
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode(HttpStatus.OK);
            return response.setComplete();
        })).build();
    }

    @Bean
    public ReactiveOAuth2UserService<OidcUserRequest, OidcUser> oidcUserService() {
        OidcReactiveOAuth2UserService delegate = new OidcReactiveOAuth2UserService();
        return userRequest -> delegate.loadUser(userRequest).doOnError(err -> log.info("Err: ", err.getCause())).doOnSuccess(user -> log.info("Auths " + String.valueOf(user.getAuthorities()))).map(user -> {
            HashSet mappedAuthorities = new HashSet();
            user.getAuthorities().forEach(authority -> {
                if (authority instanceof OidcUserAuthority) {
                    OidcUserAuthority oidcUserAuthority = (OidcUserAuthority)authority;
                    mappedAuthorities.addAll(this.extractAuthorityFromClaims(oidcUserAuthority.getUserInfo().getClaims()));
                }
            });
            return new DefaultOidcUser(mappedAuthorities, user.getIdToken(), user.getUserInfo());
        });
    }

    private List<GrantedAuthority> extractAuthorityFromClaims(Map<String, Object> claims) {
        return this.mapRolesToGrantedAuthorities(this.getRolesFromClaims(claims));
    }

    private Collection<String> getRolesFromClaims(Map<String, Object> claims) {
        LinkedHashMap realm_access = (LinkedHashMap)claims.get("realm_access");
        if (realm_access == null) {
            return List.of("ROLE_USER");
        }
        if (realm_access.get("roles") == null) {
            return List.of("ROLE_USER");
        }
        return (Collection)realm_access.get("roles");
    }

    private List<GrantedAuthority> mapRolesToGrantedAuthorities(Collection<String> roles) {
        return roles.stream().filter(role -> role.startsWith("ROLE_")).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }
}

