package com.arms.egovframework.javaservice.esframework.model.vo;

import java.util.List;
import java.util.stream.Collectors;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation.Bucket; // Changed import

import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;


@Slf4j
public class DocumentBucket {

    private String groupKey;

    private String docFieldName;

    private String docCount;

    private List<DocumentBucket> subDocuments;

    @Setter
    private DocumentBucket parentDocumentBucket;

    private DocumentBucket() {
    }

    <T extends Number> T getDocCount(Class<T> t){
        if(t.equals(Float.class)) {
            return t.cast(Float.parseFloat(docCount));
        }
        return t.cast(Long.parseLong(docCount));
    }

    Long getDocCount() {
        return Long.parseLong(docCount);
    }
    
    List<DocumentBucket> getDeepestDocument() {

        if (subDocuments == null || subDocuments.isEmpty()) {
            return List.of(this);
        }

        subDocuments
            .forEach(bucket -> bucket.setParentDocumentBucket(this));

        return subDocuments.stream()
                .flatMap(bucket -> {
                    List<DocumentBucket> deepestList = bucket.getDeepestDocument();
                    return deepestList.stream();
                })
                .collect(Collectors.toList());
    }

    public String valueByName(String docAliasName) {

        if (parentDocumentBucket == null&&docAliasName.equals(groupKey)) {
            return docFieldName;
        }

        if (parentDocumentBucket == null) {
            return "";
        }

        if(docAliasName.equals(groupKey)) {
            return docFieldName;
        }

        return parentDocumentBucket.valueByName(docAliasName);
    }

    public <T extends Number> T countByName(String docAliasName, Class<T> t) {

        if (parentDocumentBucket == null&&docAliasName.equals(groupKey)) {
            return getDocCount(t);
        }

        if (parentDocumentBucket == null) {
            return t.cast(0);
        }

        if(docAliasName.equals(groupKey)) {
            return getDocCount(t);
        }

        return parentDocumentBucket.countByName(docAliasName,t);
    }

    public Float floatCountByName(String docAliasName) {
        return countByName(docAliasName,Float.class);
    }

    public Long countByName(String docAliasName) {

        if (parentDocumentBucket == null&&docAliasName.equals(groupKey)) {
            return getDocCount();
        }

        if (parentDocumentBucket == null) {
            return 0L;
        }

        if(docAliasName.equals(groupKey)) {
            return getDocCount();
        }

        return parentDocumentBucket.countByName(docAliasName);
    }

    DocumentBucket(String groupKey,Bucket bucket) {

        this.groupKey = groupKey;

        this.docFieldName = bucket.getKeyAsString();

        this.docCount = String.valueOf(bucket.getDocCount());

        this.subDocuments = new DocumentAggregations(bucket.getAggregations().asMap()).docBuckets();

    }

    DocumentBucket(String groupKey, NumericMetricsAggregation.SingleValue bucketValue) {

        this.groupKey = groupKey;

        this.docFieldName = groupKey;

        this.docCount = bucketValue.getValueAsString();
    }

}