/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.service;

import com.arms.api.issue.almapi.model.dto.AlmIssueDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.dto.CReqProperty;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.model.vo.AlmIssueVO;
import com.arms.api.issue.almapi.strategy.IssueStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class IssueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueService.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private final ServerInfoService serverInfoService;
    private final Map<String, IssueStrategy> strategies;

    public AlmIssueVO createIssue(AlmIssueDTO almIssueDTO) {
        IssueStrategy issueStrategy = this.getALmIssueType(almIssueDTO.getServerId());
        return issueStrategy.createIssue(almIssueDTO);
    }

    public Map<String, Object> updateIssue(AlmIssueDTO almIssueDTO) {
        if (almIssueDTO == null) {
            log.error("\uc774\uc288 \uc218\uc815\ud558\uae30 Error \uc9c0\ub77c\uc774\uc288\uc0dd\uc131_\ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            throw new IllegalArgumentException("\uc774\uc288 \uc218\uc815\ud558\uae30 Error \uc9c0\ub77c\uc774\uc288\uc0dd\uc131_\ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if (almIssueDTO.getServerId() == null) {
            log.error("\uc774\uc288 \uc218\uc815\ud558\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \uc218\uc815\ud558\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        if (almIssueDTO.getIssueKeyOrId() == null || almIssueDTO.getIssueKeyOrId().isEmpty()) {
            log.error("\uc774\uc288 \uc218\uc815\ud558\uae30 Error \uc774\uc288 \ud0a4 \ub610\ub294 \uc544\uc774\ub514\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            throw new IllegalArgumentException(ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]) + " :: \uc774\uc288 \uc218\uc815\ud558\uae30 Error \uc774\uc288 \ud0a4 \ub610\ub294 \uc544\uc774\ub514\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        IssueStrategy issueStrategy = this.getALmIssueType(almIssueDTO.getServerId());
        return issueStrategy.updateIssue(almIssueDTO);
    }

    public Map<String, Object> updateIssueStatus(AlmIssueDTO almIssueDTO) {
        if (almIssueDTO.getServerId() == null) {
            log.error("\uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd\ud558\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd\ud558\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        if (almIssueDTO.getIssueKeyOrId() == null || almIssueDTO.getIssueKeyOrId().isEmpty()) {
            log.error("\uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd\ud558\uae30 Error \uc774\uc288 \ud0a4 \ub610\ub294 \uc544\uc774\ub514\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            throw new IllegalArgumentException(ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]) + " :: \uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd\ud558\uae30 Error \uc774\uc288 \ud0a4 \ub610\ub294 \uc544\uc774\ub514\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if (almIssueDTO.getStatusId() == null || almIssueDTO.getStatusId().isEmpty()) {
            log.error("\uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd\ud558\uae30 Error \uc0c1\ud0dc \uc544\uc774\ub514\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            throw new IllegalArgumentException("\uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd\ud558\uae30 Error \uc0c1\ud0dc \uc544\uc774\ub514\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        IssueStrategy issueStrategy = this.getALmIssueType(almIssueDTO.getServerId());
        return issueStrategy.updateIssueStatus(almIssueDTO);
    }

    public Map<String, Object> deleteIssue(AlmIssueDTO almIssueDTO) {
        if (almIssueDTO.getServerId() == null) {
            log.error("\uc774\uc288 \uc0ad\uc81c \ub77c\ubca8 \ucc98\ub9ac\ud558\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \uc0ad\uc81c \ub77c\ubca8 \ucc98\ub9ac\ud558\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        if (almIssueDTO.getIssueKeyOrId() == null || almIssueDTO.getIssueKeyOrId().isEmpty()) {
            log.error("\uc774\uc288 \uc0ad\uc81c \ub77c\ubca8 \ucc98\ub9ac\ud558\uae30 Error \uc774\uc288 \ud0a4 \ub610\ub294 \uc544\uc774\ub514 {}", (Object)ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \uc0ad\uc81c \ub77c\ubca8 \ucc98\ub9ac\ud558\uae30 Error \uc774\uc288 \ud0a4 \ub610\ub294 \uc544\uc774\ub514 " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
        }
        IssueStrategy issueStrategy = this.getALmIssueType(almIssueDTO.getServerId());
        return issueStrategy.deleteIssue(almIssueDTO);
    }

    public AlmIssueVO getIssue(AlmIssueDTO almIssueDTO) {
        if (almIssueDTO.getServerId() == null) {
            log.error("\uc774\uc288 \uc0c1\uc138\uc815\ubcf4 \uac00\uc838\uc624\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \uc0c1\uc138\uc815\ubcf4 \uac00\uc838\uc624\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        if (almIssueDTO.getIssueKeyOrId() == null || almIssueDTO.getIssueKeyOrId().isEmpty()) {
            log.error("\uc774\uc288 \uc0c1\uc138\uc815\ubcf4 \uac00\uc838\uc624\uae30 Error \uc774\uc288 \ud0a4 \ub610\ub294 \uc544\uc774\ub514 {}", (Object)ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \uc0c1\uc138\uc815\ubcf4 \uac00\uc838\uc624\uae30 Error \uc774\uc288 \ud0a4 \ub610\ub294 \uc544\uc774\ub514 " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
        }
        IssueStrategy issueStrategy = this.getALmIssueType(almIssueDTO.getServerId());
        return issueStrategy.getIssueVO(almIssueDTO);
    }

    public void cloudJiraTestApiRequest() {
        this.strategies.get(String.valueOf((Object)ServerType.CLOUD)).cloudJiraTestApiRequest();
    }

    public List<AlmIssueEntity> discoveryIncrementALmIssueAndGetReqAlmIssueEntities(@Valid AlmIssueIncrementDTO almIssueIncrementDTO) {
        return this.getALmIssueType(almIssueIncrementDTO.getServerId()).discoveryIssueAndGetReqEntities(almIssueIncrementDTO);
    }

    public void deleteIfDoesNotExistDoc() {
        DocumentAggregations documentAggregations = this.aggregateByRecentIdBefore30Days();
        List<DocumentBucket> documentBuckets = documentAggregations.deepestList();
        List<String> deleteList = documentBuckets.stream().map(documentBucket -> {
            String recentId = documentBucket.valueByName("recent_id");
            String connectId = recentId.split("_")[0];
            String key = recentId.split("_")[2];
            IssueStrategy issueStrategy = this.getALmIssueType(connectId);
            AlmIssueDTO almIssueDTO = new AlmIssueDTO();
            almIssueDTO.setServerId(connectId);
            almIssueDTO.setIssueKeyOrId(key);
            try {
                boolean existIssue = issueStrategy.isExistIssue(almIssueDTO);
                if (!existIssue) {
                    return recentId;
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).toList();
        this.deleteEntities(deleteList);
    }

    private void deleteEntities(List<String> recentIds) {
        recentIds.forEach(recentId -> {
            AlmIssueEntity almIssueEntity = this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)recentId));
            this.esCommonRepositoryWrapper.deleteRecentDocById(almIssueEntity.getId());
        });
    }

    private DocumentAggregations aggregateByRecentIdBefore30Days() {
        return this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainFieldAlias("recent_id").mainField("recent_id").build()).andRangeQueryFilter(RangeQueryFilter.of("updated").gte("now-2M/M").lt("now-1M/M")));
    }

    public void preSaveReqStatus(AlmIssueWithRequirementDTO almIssueWithRequirementDTO) {
        Object title;
        AlmIssueEntity almIssueEntity = this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)almIssueWithRequirementDTO.recentId()));
        CReqProperty cReqProperty = almIssueWithRequirementDTO.getCReqProperty();
        if (almIssueEntity.getRecentId() == null) {
            title = ObjectUtils.isEmpty((Object)almIssueEntity.getRawData()) ? "[\ubbf8\ud655\uc778 \uc774\uc288]" + almIssueWithRequirementDTO.getCTitle() : almIssueWithRequirementDTO.getCTitle();
            this.addEntitiesByReqStatus(List.of(AlmIssueEntity.builder().summary((String)title).cReqStatusId(almIssueWithRequirementDTO.getCReqStatusId()).recentId(almIssueWithRequirementDTO.recentId()).key(almIssueWithRequirementDTO.getIssueKey()).jira_server_id(almIssueWithRequirementDTO.getJiraServerId()).pdServiceId(almIssueWithRequirementDTO.getServiceId()).cReqLink(almIssueWithRequirementDTO.getCReqLink()).pdServiceVersions(almIssueWithRequirementDTO.getVersions()).project(AlmIssueEntity.Project.builder().key(almIssueWithRequirementDTO.getProjectKeyOrId()).build()).cReqProperty(AlmIssueEntity.CReqProperty.builder().cReqPriorityLink(cReqProperty.getCReqPriorityLink()).cReqPriorityName(cReqProperty.getCReqPriorityName()).cReqDifficultyLink(cReqProperty.getCReqDifficultyLink()).cReqDifficultyName(cReqProperty.getCReqDifficultyName()).cReqStateLink(cReqProperty.getCReqStateLink()).cReqStateName(cReqProperty.getCReqStateName()).build()).isReq(true).build()));
        }
        if (almIssueEntity.getRecentId() != null && almIssueEntity.izReqTrue()) {
            title = ObjectUtils.isEmpty((Object)almIssueEntity.getRawData()) ? "[\ubbf8\ud655\uc778 \uc774\uc288]" + almIssueWithRequirementDTO.getCTitle() : almIssueWithRequirementDTO.getCTitle();
            almIssueEntity.setSummary((String)title);
            almIssueEntity.setCReqStatusId(almIssueWithRequirementDTO.getCReqStatusId());
            almIssueEntity.setKey(almIssueWithRequirementDTO.getIssueKey());
            almIssueEntity.setJira_server_id(almIssueWithRequirementDTO.getJiraServerId());
            almIssueEntity.setPdServiceId(almIssueWithRequirementDTO.getServiceId());
            almIssueEntity.setCReqLink(almIssueWithRequirementDTO.getCReqLink());
            almIssueEntity.setPdServiceVersions(almIssueWithRequirementDTO.getVersions());
            almIssueEntity.setProject(AlmIssueEntity.Project.builder().key(almIssueWithRequirementDTO.getProjectKeyOrId()).build());
            almIssueEntity.setCReqProperty(AlmIssueEntity.CReqProperty.builder().cReqPriorityLink(cReqProperty.getCReqPriorityLink()).cReqPriorityName(cReqProperty.getCReqPriorityName()).cReqDifficultyLink(cReqProperty.getCReqDifficultyLink()).cReqDifficultyName(cReqProperty.getCReqDifficultyName()).cReqStateLink(cReqProperty.getCReqStateLink()).cReqStateName(cReqProperty.getCReqStateName()).build());
            this.addEntitiesByReqStatus(List.of(almIssueEntity));
        }
    }

    private void addEntitiesByReqStatus(List<AlmIssueEntity> almIssueList) {
        almIssueList.forEach(this.esCommonRepositoryWrapper::save);
    }

    public AlmIssueEntity findIssueByRecentId(String recentId) {
        return this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)recentId));
    }

    private IssueStrategy getALmIssueType(String serverId) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(serverId);
        if (serverInfo == null || ObjectUtils.isEmpty((Object)serverInfo.getType())) {
            log.error("\uc9c0\ub77c\uc774\uc288 \uc804\ub7b5 \ub4f1\ub85d Error: serverInfo_\uc720\ud615 {}", (Object)ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \uc804\ub7b5 \ub4f1\ub85d Error: serverInfo_\uc720\ud615 " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        String key = ServerType.typeValueOf(serverInfo.getType()).name();
        IssueStrategy strategy = this.strategies.get(key);
        if (strategy == null) {
            throw new IllegalArgumentException("\uc774\uc288 \uc804\ub7b5 \ud655\uc778 Error: \ud5c8\uc6a9\ud558\uc9c0 \uc54a\ub294 serverInfo_\uc720\ud615\uc785\ub2c8\ub2e4. :: " + String.valueOf(serverInfo) + " :: " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        return strategy;
    }

    @Generated
    public IssueService(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, ServerInfoService serverInfoService, Map<String, IssueStrategy> strategies) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.serverInfoService = serverInfoService;
        this.strategies = strategies;
    }
}

