/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.sample.rereading;

import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisor;

public class ReReadingAdvisor
implements BaseAdvisor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReReadingAdvisor.class);
    private static final String DEFAULT_RE2_ADVISE_TEMPLATE = "{re2_input_query}\nRead the question again: {re2_input_query}\n";
    private final String re2AdviseTemplate;
    private int order = 0;

    public ReReadingAdvisor() {
        this(DEFAULT_RE2_ADVISE_TEMPLATE);
    }

    public ReReadingAdvisor(String re2AdviseTemplate) {
        this.re2AdviseTemplate = re2AdviseTemplate;
    }

    public AdvisedRequest before(AdvisedRequest advisedRequest) {
        log.info("ReReadingAdvisor::before - advisedRequest: {}", (Object)advisedRequest);
        String inputQuery = advisedRequest.userText();
        log.info("ReReadingAdvisor::before - inputQuery: {}", (Object)inputQuery);
        HashMap<String, String> params = new HashMap<String, String>(advisedRequest.userParams());
        params.put("re2_input_query", inputQuery);
        log.info("ReReadingAdvisor::before - params: {}", params);
        AdvisedRequest advisedRequestBuild = AdvisedRequest.from((AdvisedRequest)advisedRequest).userText(DEFAULT_RE2_ADVISE_TEMPLATE).userParams(params).build();
        log.info("ReReadingAdvisor::before - advisedRequestBuild: {}", (Object)advisedRequestBuild);
        return advisedRequestBuild;
    }

    public AdvisedResponse after(AdvisedResponse advisedResponse) {
        return advisedResponse;
    }

    public int getOrder() {
        return this.order;
    }

    public ReReadingAdvisor withOrder(int order) {
        this.order = order;
        return this;
    }
}

