import Dexie from "dexie";
import { templateSeeds } from "./seeds";

export const db = new Dexie("drawDB");

db.version(5).stores({
  diagrams: "++id, lastModified",
  templates: "++id, custom",
  armsDiagrams: "id, lastModified",
});

db.on("populate", (transaction) => {
  transaction.templates.bulkAdd(templateSeeds).catch((e) => console.log(e));
});
