/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.configserver.model;

import com.arms.api.configserver.model.ArmsApplicationProperties;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="clients")
public class ArmsApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(ArmsApplicationProperties.class);
    private Map<String, ConfigClientUrl> urls = new HashMap();

    @PostConstruct
    public void logLoadedProperties() {
        if (this.urls.isEmpty()) {
            log.warn("\u2757 ArmsApplicationProperties.urls is EMPTY");
        } else {
            log.info("\u2705 Loaded arms.urls properties:");
            this.urls.forEach((key, value) -> log.info(" - {} => {}", key, (Object)value.getUrl()));
        }
    }

    public Map<String, ConfigClientUrl> getUrls() {
        return this.urls;
    }

    public void setUrls(Map<String, ConfigClientUrl> urls) {
        this.urls = urls;
    }
}

