package com.arms.api.requirement.controller;


import com.arms.api.requirement.model.dto.RequirementAggrDTO;
import com.arms.api.requirement.model.dto.RequirementDTO;
import com.arms.api.requirement.model.dto.SubtaskAndLinkedIssuesRequestDTO;
import com.arms.api.requirement.model.vo.HierarchicalAlmIssue;
import com.arms.api.requirement.service.RequirementService;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.requirement.model.vo.ReqProgressVO;
import com.arms.api.requirement.model.vo.RequirementVO;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/engine")
public class RequirementController {
    // ReqAdd 와 ReqStatus 에서 사용하는 API

    @Autowired
    private RequirementService requirementService;

    // AlmIssueWithRequirementDTO - ReqAdd (table 표시)
    @PostMapping("/jira/dashboard/req-assignees")
    public ResponseEntity<List<RequirementVO>> 제품_요구사항별_담당자_목록(
            @RequestBody RequirementAggrDTO requirementAggrDTO
    ) {
        return ResponseEntity.ok(requirementService.제품_요구사항별_담당자_목록(requirementAggrDTO));
    }

    // AlmIssueWithRequirementDTO - ReqStatus
    @GetMapping("/reqStatus/reqIssues-created-together")
    public ResponseEntity<List<AlmIssueEntity>> 요구사항_묶음_조회(
            @RequestParam("pdServiceId") Long pdServiceLink,
            @RequestParam("pdServiceVersions") List<Long> pdServiceVersionLinks,
            @RequestParam("cReqLink") Long 요구사항_아이디) {

        return ResponseEntity.ok(requirementService.함께_생성된_요구사항_이슈목록(pdServiceLink, pdServiceVersionLinks, 요구사항_아이디));

    }

    @GetMapping("/reqStatus/deletedIssueList")
    public ResponseEntity<List<AlmIssueEntity>> deletedIssueList(
            @RequestParam("pdServiceLink") Long pdServiceLink,
            @RequestParam("pdServiceVersionLinks") List<Long> pdServiceVersionLinks) {
        return ResponseEntity.ok(requirementService.deletedIssueList(pdServiceLink,pdServiceVersionLinks));
    }

    @PutMapping("/reqStatus/deleteWithdrawal")
    public ResponseEntity<?> 이슈_삭제철회(@RequestBody List<AlmIssueEntity>  삭제_철회대상_목록) throws Exception {
        return ResponseEntity.ok(requirementService.이슈_삭제철회(삭제_철회대상_목록));
    }

    // Gantt - reqProgress
    @PostMapping("/req-gantt/resolution")
    public ResponseEntity<List<ReqProgressVO>> 일반_버전필터_해결책유무_검색(
                                                    @RequestBody RequirementDTO requirementDTO,
                                                    @RequestParam(required = false) String resolution) {

        log.info("[RequirementController :: 일반_버전필터_해결책유무_검색]");

        return ResponseEntity.ok(requirementService.일반_버전필터_해결책유무_검색(requirementDTO, resolution));
    }

    // reqStatus - 2nd Tab (삭제 예정)
    @PostMapping("/reqStatus/issueListByUpdatedDate")
    public ResponseEntity<List<AlmIssueEntity>> issueListByUpdatedDate(@RequestBody RequirementDTO requirementDTO) {
        log.info("[RequirementController :: issueListByUpdatedDate] :: pdServiceId => {}, pdServiceVersions => {}",
                requirementDTO.getPdServiceAndIsReq().getIsReq(), requirementDTO.getPdServiceAndIsReq().getPdServiceVersions().toString());

        return ResponseEntity.ok(requirementService.issueListByUpdatedDate(requirementDTO));
    }

    // reqStatus - 2nd Tab (re)
    @PostMapping("/reqStatus/issue-list-by-updated-2nd")
    public ResponseEntity<List<AlmIssueEntity>> issueListByUpdated2ndTab(@RequestBody RequirementDTO requirementDTO) {
        log.info("[RequirementController :: issueListByUpdated2ndTab] :: pdServiceId => {}, pdServiceVersions => {}",
                requirementDTO.getPdServiceAndIsReq().getIsReq(), requirementDTO.getPdServiceAndIsReq().getPdServiceVersions().toString());

        return ResponseEntity.ok(requirementService.issueListByUpdated2ndTab(requirementDTO));
    }

    // refactored
    @PostMapping("/reqStatus/issue-list-by-updated")
    public ResponseEntity<List<HierarchicalAlmIssue>> issueListByUpdated(@RequestBody RequirementDTO requirementDTO) {
        log.info("[RequirementController :: issueListByUpdated] :: pdServiceId => {}, pdServiceVersions => {}",
                requirementDTO.getPdServiceAndIsReq().getIsReq(), requirementDTO.getPdServiceAndIsReq().getPdServiceVersions().toString());

        return ResponseEntity.ok(requirementService.issueListByAdvancedDiscovery(requirementDTO));
    }

    @PostMapping("/reqStatus/subtasks-and-linked-issues")
    public ResponseEntity<List<HierarchicalAlmIssue>> issueListBySubtasksAndLinkedIssues(
            @RequestBody SubtaskAndLinkedIssuesRequestDTO requestDTO) {
        log.info("[RequirementController :: issueListBySubtasksAndLinkedIssues] :: subtaskCount : {}, LinkedIssueCount : {}",requestDTO.getSubtaskCount(), requestDTO.getLinkedIssueCount());
        return ResponseEntity.ok(requirementService.subtasksAndLinkedIssues(requestDTO));
    }

    @PostMapping("/reqStatus/issueListByOverallUpdatedDate")
    public ResponseEntity<List<AlmIssueEntity>> issueListByOverallUpdatedDate(@RequestBody RequirementDTO requirementDTO) {
        log.info("[RequirementController :: issueListByOverallUpdatedDate] :: pdServiceId => {}, pdServiceVersions => {}",
                requirementDTO.getPdServiceAndIsReq().getIsReq(), requirementDTO.getPdServiceAndIsReq().getPdServiceVersions().toString());

        return ResponseEntity.ok(requirementService.issueListByOverallUpdatedDate(requirementDTO));
    }

    @PostMapping("/reqStatus/issue-list-by-pd")
    public ResponseEntity<List<AlmIssueEntity>> issueListByPd(@RequestBody RequirementDTO requirementDTO) {
        List<AlmIssueEntity> allListByRequirementDTO = requirementService.getAllListByRequirementDTO(requirementDTO);
        log.info("allListByRequirementDTO returnList size => {}", allListByRequirementDTO.size());
        return ResponseEntity.ok(allListByRequirementDTO);
    }
}

