package com.arms.api.analysis.cost.model.vo;

import lombok.Getter;
import lombok.Setter;

import java.time.ZonedDateTime;

@Setter
@Getter
public class ZonedDateRange {

    private final ZonedDateTime start;
    private final ZonedDateTime end;

    public ZonedDateRange(ZonedDateTime start, ZonedDateTime end) {
        if (start.isAfter(end)) {
            throw new IllegalArgumentException("Start date must be before or equal to end date.");
        }
        this.start = start;
        this.end = end;
    }
}
