package com.arms.api.admin.indexstatus.controller;

import com.arms.api.admin.indexstatus.model.vo.IndexStatusesWithJobIdVO;
import com.arms.api.admin.indexstatus.service.IndexStatusService;
import com.arms.api.util.response.CommonResponse;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import static com.arms.api.util.response.CommonResponse.success;


@RequestMapping("/engine/index/index-status")
@AllArgsConstructor
@RestController
public class IndexStatusController {

    private final IndexStatusService indexStatusService;

    @GetMapping("/histories")
    public ResponseEntity<CommonResponse.ApiResult<List<IndexStatusesWithJobIdVO>>> indexJobHistories()  {
        List<IndexStatusesWithJobIdVO> indexStatusesWithJobIdVOS = indexStatusService.indexJobHistories();
        return ResponseEntity.ok(success(indexStatusesWithJobIdVOS));
    }

}
