package com.arms.api.analysis.resource.controller;

import com.arms.api.analysis.resource.model.dto.ResourceRequestDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisAndSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.ReqAndNotReqHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.pie.ReqAndNotReqPieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.TotalIssueAndPieChartVO;
import com.arms.api.analysis.resource.model.vo.sankey.SankeyChartBaseVO;
import com.arms.api.analysis.resource.model.vo.stackedHorizontalBar.StackedHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.wordcloud.WordCloudExcelVO;
import com.arms.api.analysis.resource.service.AnalysisResource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/engine/analysis-resource")
@Slf4j
@AllArgsConstructor
public class AnalysisResourceController {

    private final AnalysisResource analysisResource;

    // worker-status datatable
    @PostMapping("/issue-status-by-assignee")
    public ResponseEntity<List<UniqueAssigneeIssueStatusVO>> issueStatusDataByAssignee(@RequestBody ResourceRequestDTO resourceDTO) {
        return ResponseEntity.ok(analysisResource.issueStatusDataByAssignee(resourceDTO));
    }

    // word-cloud
    @PostMapping("/word-cloud-data")
    public ResponseEntity<List<WordCloudExcelVO>> wordCloudEData(@RequestBody ResourceRequestDTO resourceDTO) {

        log.info("AnalysisResourceController :: wordCloudEData");

        return ResponseEntity.ok(analysisResource.wordCloudData(resourceDTO));
    }

    // Stacked Horizontal Bar
    @PostMapping("/issue-status-stacked-bar")
    public ResponseEntity<StackedHorizontalBarChartVO> issueStatusStackedBarChartData(@RequestBody ResourceRequestDTO resourceDTO) {

        log.info("AnalysisResourceController :: issueStatusStackedBarChartData");

        return ResponseEntity.ok(analysisResource.issueStatusStackedBarChartData(resourceDTO));
    }

    // pie chart (r and nr at once)
    @PostMapping("/top-contributors/pie")
    public ResponseEntity<ReqAndNotReqPieChartVO> findPieChartData(@RequestBody ResourceRequestDTO resourceDTO) {

        log.info("AnalysisResourceController :: findPieChartData");

        return ResponseEntity.ok(analysisResource.findPieChartData(resourceDTO));
    }

    // pie chart (r or nr only by isReq)
    @PostMapping("/top-contributors/pie-expand")
    public ResponseEntity<TotalIssueAndPieChartVO> findPieChartDataExpand(@RequestBody ResourceRequestDTO resourceDTO) {

        log.info("AnalysisResourceController :: findPieChartDataExpand");

        return ResponseEntity.ok(analysisResource.findPieChartDataExpand(resourceDTO));
    }

    // Horizontal Bar - 작업자 이슈 상세 집계 :: isReq로 각각
    @PostMapping("/top-contributors/horizontal-bar")
    public ResponseEntity<List<HorizontalBarChartYAxisAndSeriesVO>> findHorizontalBarChartData(
            @RequestBody ResourceRequestDTO resourceDTO) {
        log.info("[ AnalysisResourceController :: findHorizontalBarChartData ] :: isReq => {}", resourceDTO.getPdServiceAndIsReq().getIsReq());

        return ResponseEntity.ok(analysisResource.findHorizontalBarChartData(resourceDTO));
    }

    // Horizontal Bar - 작업자 이슈 상세 집계 - v2 :: 같은 accounts 로 req, notReq 모두 가져오기 :: 데이터테이블 선택.
    @PostMapping("/top-contributors/horizontal-bar-at-once")
    public ResponseEntity<ReqAndNotReqHorizontalBarChartVO> findHorizontalBarChartDataBySameAccounts(@RequestBody ResourceRequestDTO resourceDTO) {

        log.info("AnalysisResourceController :: findHorizontalBarChartDataBySameAccounts");

        return ResponseEntity.ok(analysisResource.findHorizontalBarChartDataBySameAccounts(resourceDTO));
    }

    // Sankey
    @PostMapping(value="/version-assignee-summary")
    public ResponseEntity<List<SankeyChartBaseVO>> findVersionAssigneeSummaryDataV3Refactored(@RequestBody ResourceRequestDTO resourceDTO) {

        log.info("AnalysisResourceController :: findVersionAssigneeSummaryDataV3Refactor");

        return ResponseEntity.ok(analysisResource.sankeyChartBaseDataV3((resourceDTO)));
    }

    // findTreeMapChartDataV2
    @PostMapping(value="/assignees-requirements-involvements-v2", name="resource-treemap-v2")
    public ResponseEntity<List<TreeMapWorkerVO>> findTreeMapChartDataV2(@RequestBody ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) {

        log.info("[AnalysisResourceController :: findTreeMapChartDataV2]");

        return ResponseEntity.ok(analysisResource.findTreeMapChartDataV2(resourceWithVersionIdNamesDTO));

    }

    // findTreeMapChartDataV3
    @PostMapping(value="/assignees-requirements-involvements-v3", name="resource-treemap-v3")
    public ResponseEntity<List<TreeMapWorkerVO>> findTreeMapChartDataV3(@RequestBody ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) {

        log.info("[AnalysisResourceController :: findTreeMapChartDataV3]");

        return ResponseEntity.ok(analysisResource.findTreeMapChartDataV3(resourceWithVersionIdNamesDTO));

    }

    // Expand(모달) - 작업자 필터 API
    @PostMapping("/assignees-info")
    public ResponseEntity<List<UniqueAssigneeVO>> findAssigneesInfo(@RequestBody ResourceRequestDTO resourceDTO) {
        log.info("AnalysisResourceController :: findAssigneesInfo");

        return ResponseEntity.ok(analysisResource.findAssigneesInfo(resourceDTO));
    }

}
