package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.*;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.SubTask;
import com.arms.api.issue.resolution.model.IssueResolutionData;
import com.arms.api.issue.status.dto.IssueStatusDTO;
import com.arms.api.issue.type.dto.IssueTypeDTO;
import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.project.dto.ProjectDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
@Slf4j
public class IssueFieldData {

    private ProjectDTO project;

    private IssueTypeDTO issuetype;

    private ParentDTO parent;

    private UserData creator;

    private UserData reporter;

    private UserData assignee;

    private List<String> labels;

    private IssuePriorityDTO priority;

    private IssueStatusDTO status;

    private IssueResolutionData resolution;

    private String resolutiondate;

    private String created;

    private String updated;

    private List<IssueWorkLogData> worklogs;

    private Integer timespent;

    private String summary;

    private List<IssueLink> issuelinks;

    private List<SubTask> subtasks;

    public String getAlmProjectKey() {
        String projectKey =  this.project != null
                ? this.project.getKey()
                : null;

        if (projectKey == null) {
            log.warn(" [ getAlmProjectKey ] :: 유효한 값이 없습니다 :: projectKey={}", projectKey);
            return null;
        }
        return projectKey;
    }

    public String getAlmIssueTypeId() {
        String issueTypeId =  this.issuetype != null
                ? this.issuetype.getId()
                : null;

        if (issueTypeId == null) {
            log.warn(" [ getAlmIssueTypeId ] :: 유효한 값이 없습니다 :: issueTypeId={}", issueTypeId);
            return null;
        }
        return issueTypeId;
    }

    public String getAlmStatusId() {
        String statusId =  this.status != null
                ? this.status.getId()
                : null;

        if (statusId == null) {
            log.warn(" [ getAlmStatusId ] :: 유효한 값이 없습니다 :: statusId={}", statusId);
            return null;
        }
        return statusId;
    }

}
