/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.type.strategy;

import com.arms.api.issue.type.strategy.IssueTypeStrategy;
import com.arms.api.issue.type.vo.IssueTypeVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OnpremiseJiraIssueTypeStrategy
implements IssueTypeStrategy {
    private final JiraUtil jiraUtil;
    private final ServerInfoService serverInfoService;

    public List<IssueTypeVO> getIssueTypeList(ServerInfo serverInfo) {
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            Iterable onpremiseJiraIssueTypeList = (Iterable)restClient.getMetadataClient().getIssueTypes().get();
            return StreamSupport.stream(onpremiseJiraIssueTypeList.spliterator(), false).map(arg_0 -> this.convertIssueTypeVO(arg_0)).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s] :: getIssueTypeList InterruptedException Error. Thread was interrupted", serverInfo.getType(), serverInfo.getUri()));
            Thread.currentThread().interrupt();
            throw new IllegalStateException(errorMessage);
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s] :: getIssueTypeList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public List<IssueTypeVO> getIssueTypeListByProject(ServerInfo serverInfo, String projectId) {
        return null;
    }

    private IssueTypeVO convertIssueTypeVO(IssueType issueType) {
        return IssueTypeVO.builder().self(issueType.getSelf().toString()).id(issueType.getId().toString()).description(issueType.getDescription()).name(issueType.getName()).subtask(Boolean.valueOf(issueType.isSubtask())).build();
    }

    @Generated
    public OnpremiseJiraIssueTypeStrategy(JiraUtil jiraUtil, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.serverInfoService = serverInfoService;
    }
}

