/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.schedule.service;

import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.service.CategoryMappingService;
import com.arms.api.issue.almapi.service.IssueService;
import com.arms.api.issue.schedule.service.IssueScheduleService;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.UUIDUtil;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.api.util.aspect.SlackSendAlarm;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service(value="issueScheduleService")
@Validated
public class IssueScheduleServiceImpl
implements IssueScheduleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueScheduleServiceImpl.class);
    private final IssueService issueService;
    private final CategoryMappingService categoryMappingService;
    private final ServerInfoService serverInfoService;
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    public List<AlmIssueEntity> discoveryIncrementALmIssue(AlmIssueIncrementDTO almIssueIncrementDTO) {
        return this.issueService.discoveryIncrementALmIssueAndGetReqAlmIssueEntities(almIssueIncrementDTO);
    }

    public void preSaveReqStatus(AlmIssueWithRequirementDTO almIssueWithRequirementDTO) {
        this.issueService.preSaveReqStatus(almIssueWithRequirementDTO);
    }

    public void deleteIfDoesNotExistDoc() {
        this.issueService.deleteIfDoesNotExistDoc();
    }

    public AlmIssueEntity findIssueByRecentId(String recentId) {
        return this.issueService.findIssueByRecentId(recentId);
    }

    @Async
    @DwrSendAlarm(messageOnStart="StatusMapping \uce74\ud14c\uace0\ub9ac \ub3d9\uae30\ud654 \uc2dc\uc791", messageOnEnd="StatusMapping \uce74\ud14c\uace0\ub9ac \ub3d9\uae30\ud654 \uc885\ub8cc")
    @SlackSendAlarm(messageOnStart="StatusMapping \uce74\ud14c\uace0\ub9ac \ub3d9\uae30\ud654 \uc2dc\uc791", messageOnEnd="StatusMapping \uce74\ud14c\uace0\ub9ac \ub3d9\uae30\ud654 \uc885\ub8cc")
    public void updateArmsStateCategory() {
        String logMessagePrefix = "[ IssueScheduleServiceImpl :: updateArmsStateCategory ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        log.info("[{}] :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, startTime.format(timeFormatter)});
        List almIssueEntities = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.matchAllQueryMust());
        List<AlmIssueEntity> updatedEntities = almIssueEntities.stream().map(almIssueEntity -> {
            try {
                return this.updateArmsStateCategoryIfNeeded(almIssueEntity);
            }
            catch (Exception e) {
                log.error("Error updating entity: {}", (Object)e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).toList();
        updatedEntities.forEach(arg_0 -> ((EsCommonRepositoryWrapper)this.esCommonRepositoryWrapper).save(arg_0));
        LocalDateTime endTime = LocalDateTime.now();
        Duration elapsed = Duration.between(startTime, endTime);
        log.info("[{}] :: {} :: finished at {} (completed in {} ms)", new Object[]{shortUUID, logMessagePrefix, endTime.format(timeFormatter), elapsed.toMillis()});
    }

    public void cloudJiraTestApiRequest() {
        this.issueService.cloudJiraTestApiRequest();
    }

    private AlmIssueEntity updateArmsStateCategoryIfNeeded(AlmIssueEntity entity) {
        String statusId;
        String newCategory;
        AlmIssueEntity.\uc0c1\ud0dc status;
        String serverId = entity.getJira_server_id();
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(serverId);
        ServerType serverType = ServerType.typeValueOf((String)serverInfo.getType());
        String projectKey = null;
        String issueTypeId = null;
        if (serverType == ServerType.CLOUD) {
            AlmIssueEntity.IssueType issuetype;
            AlmIssueEntity.Project project = entity.getProject();
            if (project != null) {
                projectKey = project.getKey();
            }
            if ((issuetype = entity.getIssuetype()) != null) {
                issueTypeId = issuetype.getId();
            }
        }
        if ((status = entity.getStatus()) != null && !(newCategory = this.categoryMappingService.getMappingCategory(serverInfo, projectKey, issueTypeId, statusId = status.getId())).equals(entity.getArmsStateCategory())) {
            entity.setArmsStateCategory(newCategory);
            entity.generateId();
            return entity;
        }
        return null;
    }

    @Generated
    public IssueScheduleServiceImpl(IssueService issueService, CategoryMappingService categoryMappingService, ServerInfoService serverInfoService, EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper) {
        this.issueService = issueService;
        this.categoryMappingService = categoryMappingService;
        this.serverInfoService = serverInfoService;
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

