/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.bbs.service;

import com.arms.api.bbs.model.dto.BbsDTO;
import com.arms.api.bbs.model.entity.BbsEntity;
import com.arms.api.bbs.model.vo.BbsVO;
import com.arms.api.bbs.service.BbsService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class BbsServiceImpl
implements BbsService {
    private final EsCommonRepositoryWrapper<BbsEntity> esCommonRepositoryWrapper;

    public String postMessage(BbsDTO bbsDTO) {
        BbsEntity save = (BbsEntity)this.esCommonRepositoryWrapper.save((BaseEntity)bbsDTO.toBbsEntityWithCreate());
        save.viewCountInit();
        return save.getId();
    }

    public String replyMessage(BbsDTO bbsDTO) {
        DocumentResultWrapper hits = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter((String)"group_id", (Object)bbsDTO.getPath().split("/")[0]));
        if (hits.toDocs().isEmpty()) {
            throw new IllegalArgumentException("\uc0ad\uc81c\ub41c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.");
        }
        BbsEntity save = (BbsEntity)this.esCommonRepositoryWrapper.save((BaseEntity)bbsDTO.toBbsEntityWithCreate());
        save.viewCountInit();
        return save.getId();
    }

    public String checkPassword(BbsDTO bbsDTO) {
        BbsEntity findBbsEntity = (BbsEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)bbsDTO.getId()));
        if (findBbsEntity == null) {
            throw new IllegalArgumentException("\uc0ad\uc81c\ub41c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.");
        }
        if (findBbsEntity.getPassword() != null && !findBbsEntity.getPassword().equals(bbsDTO.getPassword())) {
            throw new IllegalArgumentException("\ube44\ubc00\ubc88\ud638\uac00 \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        return findBbsEntity.getId();
    }

    public String updateBbsAndNewGroupId(BbsDTO bbsDTO) {
        String bbsId = this.updateBbsAndGetId(bbsDTO);
        BbsEntity bbsEntity = (BbsEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)bbsId));
        bbsEntity.getPostType().checkPostType();
        BbsDTO sourceBbsDTO = bbsDTO.toBbsDtoWithBoardTypeAndGroupId(bbsEntity);
        BbsVO bbsVO = this.bbsList(sourceBbsDTO);
        bbsEntity.generateGroupId();
        bbsVO.getBbsEntities().forEach(a -> {
            a.updateGroupIdAndPath(bbsEntity.getGroupId());
            this.esCommonRepositoryWrapper.save((BaseEntity)a);
        });
        return bbsDTO.getId();
    }

    public String updateBbsAndGetId(BbsDTO bbsDTO) {
        BbsEntity findBbsEntity = (BbsEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)bbsDTO.getId()));
        if (findBbsEntity == null) {
            throw new IllegalArgumentException("\uc0ad\uc81c\ub41c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.");
        }
        findBbsEntity.updateBbsEntity(bbsDTO.toBbsEntityWithUpdate());
        BbsEntity save = (BbsEntity)this.esCommonRepositoryWrapper.save((BaseEntity)findBbsEntity);
        return save.getId();
    }

    public String deleteBbsAndGetId(String deleteId) {
        BbsEntity bbsEntity = (BbsEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)deleteId));
        if (bbsEntity == null) {
            throw new IllegalArgumentException("\uac8c\uc2dc\uae00\uc774 \uc0ad\uc81c \ub418\uc5b4\uc11c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4..");
        }
        List docs = this.esCommonRepositoryWrapper.findHits(SimpleQuery.wildQueryQueryFilter((String)"path", (String)(bbsEntity.getPath() + "*"))).toDocs();
        for (BbsEntity doc : docs) {
            this.esCommonRepositoryWrapper.deleteById((Serializable)((Object)doc.getId()));
        }
        return deleteId;
    }

    public BbsVO bbsList(BbsDTO bbsDTO) {
        DocumentResultWrapper docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(SimpleQuery.search((SearchRequestDTO)bbsDTO).andTermQueryFilter("board_type", (Object)bbsDTO.getBoardType()).andTermQueryFilter("post_type", (Object)bbsDTO.getPostType()).andTermQueryFilter("group_id", (Object)bbsDTO.getGroupId()).andTermQueryFilter("subject_name", (Object)bbsDTO.getSubjectName()).orderBy(new SortDTO[]{SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field("path").sortType("asc").build()}));
        List docs = docsBySearchAfter.toDocs();
        return BbsVO.builder().bbsEntities(docs).totalHits(docsBySearchAfter.getTotalHits()).searchAfter(docsBySearchAfter.getLastSortValue()).build();
    }

    private BbsVO getList(SimpleQuery<SearchDocDTO> simpleQuery) {
        DocumentResultWrapper docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(simpleQuery);
        List docs = docsBySearchAfter.toDocs();
        return BbsVO.builder().bbsEntities(docs).totalHits(docsBySearchAfter.getTotalHits()).searchAfter(docsBySearchAfter.getLastSortValue()).build();
    }

    public BbsVO searchBbs(BbsDTO bbsDTO) {
        return this.getList(SimpleQuery.search((SearchRequestDTO)bbsDTO).andMatchQueryFilter("subject_name", (Object)bbsDTO.getSubjectName()).orderBy(new SortDTO[]{SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field("path").sortType("asc").build()}));
    }

    public BbsVO sortBbs(BbsDTO bbsDTO, String field, String sortType) {
        return this.getList(SimpleQuery.termQueryFilter((String)"board_type", (Object)bbsDTO.getBoardType()).andTermQueryFilter("post_type", (Object)bbsDTO.getPostType()).andTermQueryFilter("group_id", (Object)bbsDTO.getGroupId()).orderBy(new SortDTO[]{SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field(field).sortType(sortType).build()}));
    }

    public List<BbsEntity> findPathById(String id) {
        BbsEntity bbsEntity = (BbsEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)id));
        if (bbsEntity == null) {
            throw new IllegalArgumentException("\uac8c\uc2dc\uae00\uc774 \uc0ad\uc81c \ub418\uc5b4\uc11c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4..");
        }
        List docs = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter((String)"board_type", (Object)bbsEntity.getBoardType()).andTermQueryFilter("group_id", (Object)bbsEntity.getGroupId()).orderBy(new SortDTO[]{SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field("path").sortType("asc").build()})).toDocs();
        if (docs.isEmpty()) {
            throw new IllegalArgumentException("\uac8c\uc2dc\uae00\uc774 \uc0ad\uc81c \ub418\uc5b4\uc11c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4..");
        }
        return docs;
    }

    @Async
    public void asyncViewCountUp(String id) {
        BbsEntity bbsEntity = (BbsEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)id));
        bbsEntity.viewCountUp();
        this.esCommonRepositoryWrapper.save((BaseEntity)bbsEntity);
    }

    @Generated
    public BbsServiceImpl(EsCommonRepositoryWrapper<BbsEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

