/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.scope.controller;

import com.arms.api.analysis.scope.dto.ScopeDTO;
import com.arms.api.analysis.scope.service.AnalysisScope;
import com.arms.api.analysis.scope.vo.CircularPackingChartVO;
import com.arms.api.analysis.scope.vo.IssueVO;
import com.arms.api.analysis.scope.vo.NetworkChartExcelDataVO;
import com.arms.api.analysis.scope.vo.PdServiceVersionsAndReqVO;
import com.arms.api.analysis.scope.vo.ReqDataTableIssuesVO;
import com.arms.api.analysis.scope.vo.TreeBarIssueVO;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/analysis-scope"})
public class AnalysisScopeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalysisScopeController.class);
    private final AnalysisScope analysisScope;

    @PostMapping(value={"/circular-packing-data"})
    public ResponseEntity<List<CircularPackingChartVO>> getCircularPackingChartDataV2(@RequestBody ScopeDTO scopeDTO) {
        return ResponseEntity.ok((Object)this.analysisScope.getCircularPackingChartDataV2(scopeDTO));
    }

    @PostMapping(value={"/tree-bar-data"})
    public ResponseEntity<List<TreeBarIssueVO>> treeBarData(@RequestBody ScopeDTO scopeDTO) {
        log.info("[AnalysisScopeController :: treeBarData] :: topN = {}", (Object)Optional.ofNullable(scopeDTO.getTopN()).orElse(-1));
        return ResponseEntity.ok((Object)this.analysisScope.treeBarData(scopeDTO));
    }

    @PostMapping(value={"/tree-bar-data-v2"})
    public ResponseEntity<List<TreeBarIssueVO>> treeBarDataV2(@RequestBody ScopeDTO scopeDTO) {
        log.info("[AnalysisScopeController :: treeBarDataV2] :: topN = {}", (Object)Optional.ofNullable(scopeDTO.getTopN()).orElse(-1));
        return ResponseEntity.ok((Object)this.analysisScope.treeBarDataV2(scopeDTO));
    }

    @PostMapping(value={"/getPdServiceVersionsAndReq"})
    public List<PdServiceVersionsAndReqVO> getPdServiceVersionsAndReq(@RequestBody ScopeDTO scopeDto) throws IOException {
        log.info("AnalysisScopeController :: getPdServiceVersionsAndReq");
        List pdServiceVersionsAndReq = this.analysisScope.getPdServiceVersionsAndReq(scopeDto);
        return pdServiceVersionsAndReq;
    }

    @PostMapping(value={"/getVersionsAndIssueList"})
    public List<IssueVO> getVersionsAndIssuList(@RequestBody ScopeDTO scopeDto) {
        log.info("AnalysisScopeController :: getVersionsAndIssuList");
        List issues = this.analysisScope.getVersionsAndIssuList(scopeDto);
        return issues;
    }

    @PostMapping(value={"/getIssueList"})
    public List<IssueVO> getIssueList(@RequestBody ScopeDTO scopeDto) {
        log.info("AnalysisScopeController :: getIssues");
        List issues = this.analysisScope.getIssueList(scopeDto);
        return issues;
    }

    @PostMapping(value={"/getNetworkChartExcelData"})
    public List<NetworkChartExcelDataVO> getNetworkChartExcelData(@RequestBody ScopeDTO scopeDto) {
        log.info("AnalysisScopeController :: getNetworkChartExcelData");
        return this.analysisScope.getNetworkChartExcelData(scopeDto);
    }

    @PostMapping(value={"/getDataTableIssues"})
    public List<ReqDataTableIssuesVO> getDataTableIssues(@RequestBody ScopeDTO scopeDto) {
        log.info("AnalysisScopeController :: getDataTableIssues");
        return this.analysisScope.getDataTableIssues(scopeDto);
    }

    @Generated
    public AnalysisScopeController(AnalysisScope analysisScope) {
        this.analysisScope = analysisScope;
    }
}

