/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.resource.service;

import com.arms.api.analysis.resource.model.dto.PieChartDTO;
import com.arms.api.analysis.resource.model.dto.ResourceRequestDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.dto.VersionIdNameDTO;
import com.arms.api.analysis.resource.model.dto.wordcloud.WordCloudExcelDTO;
import com.arms.api.analysis.resource.model.vo.AssigneeIssuePropertiesVO;
import com.arms.api.analysis.resource.model.vo.IssuePropertyVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisAndSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.ReqAndNotReqHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.pie.PieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.ReqAndNotReqPieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.TotalIssueAndPieChartVO;
import com.arms.api.analysis.resource.model.vo.sankey.SankeyChartBaseVO;
import com.arms.api.analysis.resource.model.vo.sankey.VersionAssigneeSummary;
import com.arms.api.analysis.resource.model.vo.sankey.VersionAssigneeSummaryVO;
import com.arms.api.analysis.resource.model.vo.stackedHorizontalBar.StackedHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.stackedHorizontalBar.StackedHorizontalBarChartYAxisVO;
import com.arms.api.analysis.resource.model.vo.stackedHorizontalBar.StackedHorizontalBarSeriesVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapTaskListVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.model.vo.wordcloud.WordCloudExcelVO;
import com.arms.api.analysis.resource.service.AnalysisResource;
import com.arms.api.analysis.resource.service.AnalysisResourceImpl;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.util.DateRangeUtil;
import com.arms.api.util.ParseUtil;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.MainGroupDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="analysisResource")
public class AnalysisResourceImpl
implements AnalysisResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalysisResourceImpl.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private static final String UNKNOWN_STATUS = "Unknown Status";
    private static final String UNKNOWN_PRIORITY = "Unknown Priority";
    private static final String UNKNOWN_ISSUETYPE = "Unknown IssueType";

    public List<UniqueAssigneeIssueStatusVO> issueStatusDataByAssignee(ResourceRequestDTO resourceDTO) {
        List accounts = resourceDTO.getAccounts();
        if (!ObjectUtils.isEmpty((Object)accounts)) {
            accounts = this.decodeAccountId(accounts);
            resourceDTO.setAccounts(accounts);
        }
        Map assigneeMap = this.idAssigneeInfoMap(resourceDTO.getPdServiceAndIsReq());
        List retrieveIssues = this.retrieveRelevantIssues(resourceDTO);
        if (retrieveIssues.isEmpty()) {
            log.info("issueStatusDataByAssignee :: retrieveIssues.size => 0");
            return Collections.emptyList();
        }
        HashMap accountIdReqIssueStatusMap = new HashMap();
        HashMap accountIdNotReqIssueStatusMap = new HashMap();
        for (AlmIssueEntity issue : retrieveIssues) {
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            String accountId = issue.getAssignee().getAccountId();
            String statusName = this.resolveStatusName(issue);
            if (this.isRightReqIssue(issue, resourceDTO)) {
                this.incrementIssueProperty(accountIdReqIssueStatusMap, accountId, statusName);
                continue;
            }
            this.incrementIssueProperty(accountIdNotReqIssueStatusMap, accountId, statusName);
        }
        Map accountIdReqIssueStatusList = AnalysisResourceImpl.toListMapForEach(accountIdReqIssueStatusMap);
        Map accountIdNotReqIssueStatusList = AnalysisResourceImpl.toListMapForEach(accountIdNotReqIssueStatusMap);
        List issueStatusData = this.buildUniqueAssigneeIssueStatusList(assigneeMap, accountIdReqIssueStatusList, accountIdNotReqIssueStatusList);
        return this.sortByTotalReqNotReqCountsDesc(issueStatusData);
    }

    public static Map<String, List<IssuePropertyVO>> toListMapForEach(Map<String, Map<String, IssuePropertyVO>> accountIdReqIssueStatusMap) {
        if (accountIdReqIssueStatusMap == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<IssuePropertyVO>> result = new LinkedHashMap<String, List<IssuePropertyVO>>();
        for (Map.Entry<String, Map<String, IssuePropertyVO>> entry : accountIdReqIssueStatusMap.entrySet()) {
            Map<String, IssuePropertyVO> inner = entry.getValue();
            ArrayList list = inner == null ? new ArrayList() : new ArrayList<IssuePropertyVO>(inner.values());
            result.put(entry.getKey(), list);
        }
        return result;
    }

    private List<UniqueAssigneeIssueStatusVO> sortByTotalReqNotReqCountsDesc(List<UniqueAssigneeIssueStatusVO> issueStatusData) {
        issueStatusData.sort(Comparator.comparingLong(UniqueAssigneeIssueStatusVO::getTotalIssueCount).reversed().thenComparingLong(UniqueAssigneeIssueStatusVO::getReqIssueCount).reversed().thenComparingLong(UniqueAssigneeIssueStatusVO::getNotReqIssueCount).reversed());
        return issueStatusData;
    }

    private List<UniqueAssigneeIssueStatusVO> buildUniqueAssigneeIssueStatusList(Map<String, UniqueAssigneeVO> assigneeVOMap, Map<String, List<IssuePropertyVO>> reqIssueUniqueIdStatusData, Map<String, List<IssuePropertyVO>> nonReqIssueUniqueIdStatusData) {
        ArrayList<UniqueAssigneeIssueStatusVO> returnVO = new ArrayList<UniqueAssigneeIssueStatusVO>();
        for (Map.Entry<String, UniqueAssigneeVO> entry : assigneeVOMap.entrySet()) {
            String key = entry.getKey();
            UniqueAssigneeVO uniqueAssigneeVO = entry.getValue();
            List reqIssueProperties = reqIssueUniqueIdStatusData.getOrDefault(key, Collections.emptyList());
            List notReqIssueProperties = nonReqIssueUniqueIdStatusData.getOrDefault(key, Collections.emptyList());
            Long reqIssueCount = reqIssueProperties.stream().mapToLong(IssuePropertyVO::getValue).sum();
            Long notReqIssueCount = notReqIssueProperties.stream().mapToLong(IssuePropertyVO::getValue).sum();
            Long totalIssueCount = reqIssueCount + notReqIssueCount;
            UniqueAssigneeIssueStatusVO uniqueAssigneeIssueStatusVO = UniqueAssigneeIssueStatusVO.builder().uniqueAssigneeVO(uniqueAssigneeVO).totalIssueCount(totalIssueCount).reqIssueCount(reqIssueCount).notReqIssueCount(notReqIssueCount).reqIssueProperties(reqIssueProperties).notReqIssueProperties(notReqIssueProperties).build();
            returnVO.add(uniqueAssigneeIssueStatusVO);
        }
        return returnVO;
    }

    private Map<String, UniqueAssigneeVO> findAssigneeMap(SimpleQuery<MainGroupDTO> simpleQuery) {
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(simpleQuery);
        List deepestList = documentAggregations.deepestList();
        HashMap<String, UniqueAssigneeVO> accountIdAssigneeMap = new HashMap<String, UniqueAssigneeVO>();
        for (DocumentBucket documentBucket : deepestList) {
            String accountId = documentBucket.valueByName("accountId");
            String name = documentBucket.valueByName("assigneeName");
            String email = documentBucket.valueByName("assigneeEmail");
            accountIdAssigneeMap.computeIfAbsent(accountId, k -> UniqueAssigneeVO.builder().accountId(accountId).name(name).emailAddress(Optional.ofNullable(email).orElse("")).build());
        }
        return accountIdAssigneeMap;
    }

    private Map<String, UniqueAssigneeVO> idAssigneeInfoMap(ResourceRequestDTO dto) {
        ResourceRequestDTO resourceDTO = new ResourceRequestDTO();
        resourceDTO.setPdServiceAndIsReq(dto.getPdServiceAndIsReq());
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        Map assigneeMapByPdAndVersionFields = this.findAssigneeMap(SimpleQuery.aggregation((AggregationRequestDTO)AggregationRequestDTO.builder().mainField("assignee.assignee_accountId.keyword").mainFieldAlias("accountId").addGroup(new SubGroupFieldDTO[]{SubGroupFieldDTO.builder().subFieldAlias("assigneeName").subField("assignee.assignee_displayName.keyword").build(), SubGroupFieldDTO.builder().subFieldAlias("assigneeEmail").subField("assignee.assignee_emailAddress.keyword").build()}).build()).andTermQueryMust("pdServiceId", (Object)pdServiceId).andTermsQueryFilter("pdServiceVersions", pdServiceVersions).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(resourceDTO.getStartDate(), resourceDTO.getEndDate())).andExistsQueryFilter("assignee").andTermsQueryFilter("assignee.assignee_accountId.keyword", resourceDTO.getAccounts()));
        Map assigneeMapByLinkedFields = this.findAssigneeMap(SimpleQuery.aggregation((AggregationRequestDTO)AggregationRequestDTO.builder().mainField("assignee.assignee_accountId.keyword").mainFieldAlias("accountId").addGroup(new SubGroupFieldDTO[]{SubGroupFieldDTO.builder().subFieldAlias("assigneeName").subField("assignee.assignee_displayName.keyword").build(), SubGroupFieldDTO.builder().subFieldAlias("assigneeEmail").subField("assignee.assignee_emailAddress.keyword").build()}).build()).andTermsQueryFilter("linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", pdServiceVersions).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(resourceDTO.getStartDate(), resourceDTO.getEndDate())).andExistsQueryFilter("assignee").andTermsQueryFilter("assignee.assignee_accountId.keyword", resourceDTO.getAccounts()));
        return this.mergeAssigneeMaps(assigneeMapByLinkedFields, assigneeMapByPdAndVersionFields);
    }

    private Map<String, UniqueAssigneeVO> mergeAssigneeMaps(Map<String, UniqueAssigneeVO> map1, Map<String, UniqueAssigneeVO> map2) {
        HashMap<String, UniqueAssigneeVO> mergedMap = new HashMap<String, UniqueAssigneeVO>(map2);
        map1.forEach((accountId, assigneeVO1) -> {
            UniqueAssigneeVO assigneeVO2 = (UniqueAssigneeVO)mergedMap.get(accountId);
            if (assigneeVO2 != null) {
                String email1 = assigneeVO1.getEmailAddress();
                String email2 = assigneeVO2.getEmailAddress();
                if (ObjectUtils.isEmpty((Object)email2) && !ObjectUtils.isEmpty((Object)email1)) {
                    assigneeVO2.setEmailAddress(email1);
                }
            } else {
                mergedMap.put((String)accountId, (UniqueAssigneeVO)assigneeVO1);
            }
        });
        return mergedMap;
    }

    private Map<String, UniqueAssigneeVO> idAssigneeInfoMap(PdServiceAndIsReqDTO pdServiceAndIsReq) {
        ResourceRequestDTO resourceDTO = new ResourceRequestDTO();
        resourceDTO.setPdServiceAndIsReq(pdServiceAndIsReq);
        return this.idAssigneeInfoMap(resourceDTO);
    }

    public List<WordCloudExcelVO> wordCloudData(ResourceRequestDTO resourceDTO) {
        List accounts = resourceDTO.getAccounts();
        if (!ObjectUtils.isEmpty((Object)accounts)) {
            accounts = this.decodeAccountId(accounts);
            resourceDTO.setAccounts(accounts);
        }
        Map assigneeMap = this.idAssigneeInfoMap(resourceDTO.getPdServiceAndIsReq());
        List retrieveIssues = this.retrieveRelevantIssues(resourceDTO);
        if (retrieveIssues.isEmpty()) {
            log.info("wordCloudData :: retrieveIssues.size => 0");
            return Collections.emptyList();
        }
        HashMap<String, WordCloudExcelDTO> accountIdWordCloudDTOMap = new HashMap<String, WordCloudExcelDTO>();
        for (AlmIssueEntity issue : retrieveIssues) {
            WordCloudExcelDTO wordCloudExcelDTO;
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            String accountId = issue.getAssignee().getAccountId();
            if (accountIdWordCloudDTOMap.containsKey(accountId)) {
                wordCloudExcelDTO = (WordCloudExcelDTO)accountIdWordCloudDTOMap.get(accountId);
                if (this.isRightReqIssue(issue, resourceDTO)) {
                    wordCloudExcelDTO.setReqIssueTotal(Long.valueOf(wordCloudExcelDTO.getReqIssueTotal() + 1L));
                } else {
                    wordCloudExcelDTO.setNotReqIssueTotal(Long.valueOf(wordCloudExcelDTO.getNotReqIssueTotal() + 1L));
                }
                wordCloudExcelDTO.setIssueTotal(Long.valueOf(wordCloudExcelDTO.getIssueTotal() + 1L));
                continue;
            }
            wordCloudExcelDTO = new WordCloudExcelDTO();
            wordCloudExcelDTO.setAccountId(accountId);
            wordCloudExcelDTO.setName(((UniqueAssigneeVO)assigneeMap.get(accountId)).getName());
            wordCloudExcelDTO.setIssueTotal(Long.valueOf(1L));
            if (this.isRightReqIssue(issue, resourceDTO)) {
                wordCloudExcelDTO.setReqIssueTotal(Long.valueOf(1L));
                wordCloudExcelDTO.setNotReqIssueTotal(Long.valueOf(0L));
            } else {
                wordCloudExcelDTO.setReqIssueTotal(Long.valueOf(0L));
                wordCloudExcelDTO.setNotReqIssueTotal(Long.valueOf(1L));
            }
            accountIdWordCloudDTOMap.put(accountId, wordCloudExcelDTO);
        }
        return accountIdWordCloudDTOMap.values().stream().map(WordCloudExcelVO::fromDTO).collect(Collectors.toList());
    }

    public StackedHorizontalBarChartVO issueStatusStackedBarChartData(ResourceRequestDTO resourceDTO) {
        List accounts = resourceDTO.getAccounts();
        if (!ObjectUtils.isEmpty((Object)accounts)) {
            accounts = this.decodeAccountId(accounts);
            resourceDTO.setAccounts(accounts);
        }
        Map assigneeMap = this.idAssigneeInfoMap(resourceDTO);
        List retrieveIssues = this.retrieveRelevantIssues(resourceDTO);
        if (retrieveIssues.isEmpty()) {
            log.info("issueStatusStackedBarChartData :: retrieveIssues.size => 0");
            return StackedHorizontalBarChartVO.builder().yAxisVO(null).series(null).build();
        }
        HashMap<String, ArrayList<IssuePropertyVO>> accountIdIssueStatusListMap = new HashMap<String, ArrayList<IssuePropertyVO>>();
        HashSet<String> statusNameSet = new HashSet<String>();
        for (AlmIssueEntity issue : retrieveIssues) {
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            String accountId = issue.getAssignee().getAccountId();
            String statusName = issue.getStatus().getName();
            statusNameSet.add(statusName);
            if (accountIdIssueStatusListMap.containsKey(accountId)) {
                List issueStatusList = (List)accountIdIssueStatusListMap.get(accountId);
                boolean isStatusFound = false;
                for (IssuePropertyVO issueStatus : issueStatusList) {
                    if (!issueStatus.getName().equals(statusName)) continue;
                    issueStatus.setValue(Long.valueOf(issueStatus.getValue() + 1L));
                    isStatusFound = true;
                    break;
                }
                if (isStatusFound) continue;
                IssuePropertyVO issueStatus = IssuePropertyVO.builder().name(statusName).value(Long.valueOf(1L)).build();
                issueStatusList.add(issueStatus);
                continue;
            }
            IssuePropertyVO issueStatus = IssuePropertyVO.builder().name(statusName).value(Long.valueOf(1L)).build();
            accountIdIssueStatusListMap.put(accountId, new ArrayList<IssuePropertyVO>(List.of(issueStatus)));
        }
        ArrayList statusNames = new ArrayList(statusNameSet);
        List assigneeList = this.assigneesByAccountIdIssueProperties(assigneeMap, accountIdIssueStatusListMap);
        List assigneeNames = assigneeList.stream().map(UniqueAssigneeVO::getName).collect(Collectors.toList());
        StackedHorizontalBarChartYAxisVO chartYAxisVO = StackedHorizontalBarChartYAxisVO.builder().type("category").data(assigneeNames).build();
        List stackedHorizontalBarSeriesVOS = this.stackedHorizontalBarSeriesVO(statusNames, assigneeList, accountIdIssueStatusListMap);
        return StackedHorizontalBarChartVO.builder().yAxisVO(chartYAxisVO).series(stackedHorizontalBarSeriesVOS).build();
    }

    private List<UniqueAssigneeVO> assigneesByAccountIdIssueProperties(Map<String, UniqueAssigneeVO> allAssigneeMap, Map<String, List<IssuePropertyVO>> accountIdIssueProperties) {
        ArrayList<UniqueAssigneeVO> assignees = new ArrayList<UniqueAssigneeVO>();
        for (Map.Entry<String, List<IssuePropertyVO>> entry : accountIdIssueProperties.entrySet()) {
            UniqueAssigneeVO uniqueAssigneeVO = allAssigneeMap.get(entry.getKey());
            Object nameWithEmailId = uniqueAssigneeVO.getName();
            if (!uniqueAssigneeVO.getEmailAddress().isEmpty()) {
                String emailId = ParseUtil.extractUsernameFromEmail((String)uniqueAssigneeVO.getEmailAddress());
                nameWithEmailId = (String)nameWithEmailId + " (" + emailId + ")";
            }
            UniqueAssigneeVO vo = UniqueAssigneeVO.builder().accountId(uniqueAssigneeVO.getAccountId()).name((String)nameWithEmailId).serverId(uniqueAssigneeVO.getServerId()).emailAddress(uniqueAssigneeVO.getEmailAddress()).build();
            assignees.add(vo);
        }
        return assignees;
    }

    private List<StackedHorizontalBarSeriesVO> stackedHorizontalBarSeriesVO(List<String> statusNames, List<UniqueAssigneeVO> assignees, Map<String, List<IssuePropertyVO>> accountIdIssueProperties) {
        ArrayList<StackedHorizontalBarSeriesVO> series = new ArrayList<StackedHorizontalBarSeriesVO>();
        for (String statusName : statusNames) {
            ArrayList<Long> data = new ArrayList<Long>();
            for (UniqueAssigneeVO assignee : assignees) {
                List<IssuePropertyVO> issueProperties = accountIdIssueProperties.get(assignee.getAccountId());
                Optional<IssuePropertyVO> issueStatusProperty = issueProperties.stream().filter(proterty -> proterty.getName().equals(statusName)).findFirst();
                if (issueStatusProperty.isPresent()) {
                    data.add(issueStatusProperty.get().getValue());
                    continue;
                }
                data.add(0L);
            }
            series.add(StackedHorizontalBarSeriesVO.builder().type("bar").name(statusName).data(data).build());
        }
        return series;
    }

    public TotalIssueAndPieChartVO findPieChartDataExpand(ResourceRequestDTO resourceDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceDTO.getPdServiceAndIsReq();
        Map assigneeMap = this.idAssigneeInfoMap(resourceDTO.getPdServiceAndIsReq());
        List accounts = resourceDTO.getAccounts();
        if (!ObjectUtils.isEmpty((Object)accounts)) {
            accounts = this.decodeAccountId(accounts);
            resourceDTO.setAccounts(accounts);
        }
        if (!ObjectUtils.isEmpty((Object)pdServiceAndIsReq.getIsReq()) && Boolean.TRUE.equals(pdServiceAndIsReq.getIsReq())) {
            DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation((AggregationRequestDTO)AggregationRequestDTO.builder().mainField("assignee.assignee_accountId.keyword").mainFieldAlias("accountId").size(resourceDTO.getSize()).build()).andTermQueryMust("pdServiceId", (Object)pdServiceAndIsReq.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", pdServiceAndIsReq.getPdServiceVersions()).andTermQueryMust("isReq", (Object)pdServiceAndIsReq.getIsReq()).andTermsQueryFilter("assignee.assignee_accountId.keyword", resourceDTO.getAccounts()).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(resourceDTO.getStartDate(), resourceDTO.getEndDate())).andExistsQueryFilter("assignee"));
            return this.toTotalIssueAndPieChartVO(documentAggregations, assigneeMap);
        }
        List almIssueEntities = this.retrieveRelevantIssues(resourceDTO);
        List retrievedIssues = this.excludeRightReqIssue(almIssueEntities, resourceDTO);
        Long totalDocCounts = retrievedIssues.size();
        if (ObjectUtils.isEmpty((Object)retrievedIssues)) {
            return TotalIssueAndPieChartVO.builder().totalIssueCount(Long.valueOf(0L)).assigneeAndIssueCounts(Collections.emptyList()).build();
        }
        HashMap<String, Long> accountIdIssueCountMap = new HashMap<String, Long>();
        for (AlmIssueEntity issue : retrievedIssues) {
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            String accountId = issue.getAssignee().getAccountId();
            accountIdIssueCountMap.compute(accountId, (k, v) -> v == null ? 1L : v + 1L);
        }
        List assigneeAndIssueCounts = accountIdIssueCountMap.entrySet().stream().map(entry -> {
            String accountId = (String)entry.getKey();
            Long issueCount = (Long)entry.getValue();
            UniqueAssigneeVO assignee = (UniqueAssigneeVO)assigneeMap.get(accountId);
            return PieChartVO.builder().name(assignee.getName()).value(issueCount).serverId(assignee.getServerId()).accountId(accountId).emailAddress(assignee.getEmailAddress()).build();
        }).sorted(Comparator.comparing(PieChartVO::getValue).reversed()).collect(Collectors.toList());
        return TotalIssueAndPieChartVO.builder().totalIssueCount(totalDocCounts).assigneeAndIssueCounts(assigneeAndIssueCounts).build();
    }

    public List<HorizontalBarChartYAxisAndSeriesVO> findHorizontalBarChartData(ResourceRequestDTO resourceDTO) {
        List retrievedIssues;
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceDTO.getPdServiceAndIsReq();
        List accounts = resourceDTO.getAccounts();
        if (!ObjectUtils.isEmpty((Object)accounts)) {
            accounts = this.decodeAccountId(accounts);
            resourceDTO.setAccounts(accounts);
        }
        Map assigneeMap = this.idAssigneeInfoMap(resourceDTO);
        if (!ObjectUtils.isEmpty((Object)pdServiceAndIsReq.getIsReq()) && Boolean.TRUE.equals(pdServiceAndIsReq.getIsReq())) {
            retrievedIssues = this.retrieveReqIssues(resourceDTO);
        } else {
            List almIssueEntities = this.retrieveRelevantIssues(resourceDTO);
            retrievedIssues = this.excludeRightReqIssue(almIssueEntities, resourceDTO);
        }
        if (retrievedIssues.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getHorizontalBarChartYAxisAndSeriesVOS(resourceDTO, retrievedIssues, assigneeMap);
    }

    @NotNull
    private List<HorizontalBarChartYAxisAndSeriesVO> getHorizontalBarChartYAxisAndSeriesVOS(ResourceRequestDTO resourceDTO, List<AlmIssueEntity> retrievedIssues, Map<String, UniqueAssigneeVO> assigneeMap) {
        HashMap accountIdIssueStatusMap = new HashMap();
        HashMap accountIdIssuePriorityMap = new HashMap();
        HashMap accountIdIssueTypeMap = new HashMap();
        for (AlmIssueEntity issue : retrievedIssues) {
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            String accountId = issue.getAssignee().getAccountId();
            String statusName = this.resolveStatusName(issue);
            String priorityName = this.resolvePriorityName(issue);
            String issueTypeName = this.resolveIssueTypeName(issue);
            this.incrementIssueProperty(accountIdIssueStatusMap, accountId, statusName);
            this.incrementIssueProperty(accountIdIssuePriorityMap, accountId, priorityName);
            this.incrementIssueProperty(accountIdIssueTypeMap, accountId, issueTypeName);
        }
        List issueStatusList = this.buildAssigneeIssuePropertiesList(accountIdIssueStatusMap, assigneeMap);
        List issuePriorityList = this.buildAssigneeIssuePropertiesList(accountIdIssuePriorityMap, assigneeMap);
        List issueTypeList = this.buildAssigneeIssuePropertiesList(accountIdIssueTypeMap, assigneeMap);
        HorizontalBarChartYAxisVO issueStatusHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(issueStatusList);
        HorizontalBarChartYAxisVO issuePriorityHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(issuePriorityList);
        HorizontalBarChartYAxisVO issueTypeHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(issueTypeList);
        List issueStatusHorizontalBarChartSeries = this.toHorizontalBarChartSeries(issueStatusList, issueStatusHorizontalBarChartYAxisVO);
        List issuePriorityHorizontalBarChartSeries = this.toHorizontalBarChartSeries(issuePriorityList, issuePriorityHorizontalBarChartYAxisVO);
        List issueTypeHorizontalBarChartSeries = this.toHorizontalBarChartSeries(issueTypeList, issueTypeHorizontalBarChartYAxisVO);
        ArrayList<HorizontalBarChartYAxisAndSeriesVO> horizontalBarChartYAxisAndSeriesVOList = new ArrayList<HorizontalBarChartYAxisAndSeriesVO>();
        horizontalBarChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("status").yAxisVO(issueStatusHorizontalBarChartYAxisVO).series(issueStatusHorizontalBarChartSeries).build());
        horizontalBarChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("priority").yAxisVO(issuePriorityHorizontalBarChartYAxisVO).series(issuePriorityHorizontalBarChartSeries).build());
        horizontalBarChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("issuetype").yAxisVO(issueTypeHorizontalBarChartYAxisVO).series(issueTypeHorizontalBarChartSeries).build());
        return horizontalBarChartYAxisAndSeriesVOList;
    }

    public ReqAndNotReqHorizontalBarChartVO findHorizontalBarChartDataBySameAccounts(ResourceRequestDTO resourceDTO) {
        List accounts = resourceDTO.getAccounts();
        if (!ObjectUtils.isEmpty((Object)accounts)) {
            accounts = this.decodeAccountId(accounts);
            resourceDTO.setAccounts(accounts);
        }
        Map assigneeMap = this.idAssigneeInfoMap(resourceDTO);
        List retrieveIssues = this.retrieveRelevantIssues(resourceDTO);
        if (retrieveIssues.isEmpty()) {
            log.info("findHorizontalBarCartData :: retrieveIssues.size => 0");
            return ReqAndNotReqHorizontalBarChartVO.builder().build();
        }
        HashMap reqAccountIdIssueStatusMap = new HashMap();
        HashMap reqAccountIdIssuePriorityMap = new HashMap();
        HashMap reqAccountIdIssueTypeMap = new HashMap();
        HashMap notReqAccountIdIssueStatusMap = new HashMap();
        HashMap notReqAccountIdIssuePriorityMap = new HashMap();
        HashMap notReqAccountIdIssueTypeMap = new HashMap();
        for (AlmIssueEntity issue : retrieveIssues) {
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            String accountId = issue.getAssignee().getAccountId();
            String statusName = this.resolveStatusName(issue);
            String priorityName = this.resolvePriorityName(issue);
            String issueTypeName = this.resolveIssueTypeName(issue);
            if (this.isRightReqIssue(issue, resourceDTO)) {
                this.incrementIssueProperty(reqAccountIdIssueStatusMap, accountId, statusName);
                this.incrementIssueProperty(reqAccountIdIssuePriorityMap, accountId, priorityName);
                this.incrementIssueProperty(reqAccountIdIssueTypeMap, accountId, issueTypeName);
                continue;
            }
            this.incrementIssueProperty(notReqAccountIdIssueStatusMap, accountId, statusName);
            this.incrementIssueProperty(notReqAccountIdIssuePriorityMap, accountId, priorityName);
            this.incrementIssueProperty(notReqAccountIdIssueTypeMap, accountId, issueTypeName);
        }
        List reqIssueStatusList = this.buildAssigneeIssuePropertiesList(reqAccountIdIssueStatusMap, assigneeMap);
        List reqIssuePriorityList = this.buildAssigneeIssuePropertiesList(reqAccountIdIssuePriorityMap, assigneeMap);
        List reqIssueTypeList = this.buildAssigneeIssuePropertiesList(reqAccountIdIssueTypeMap, assigneeMap);
        List notReqIssueStatusList = this.buildAssigneeIssuePropertiesList(notReqAccountIdIssueStatusMap, assigneeMap);
        List notReqIssuePriorityList = this.buildAssigneeIssuePropertiesList(notReqAccountIdIssuePriorityMap, assigneeMap);
        List notReqIssueTypeList = this.buildAssigneeIssuePropertiesList(notReqAccountIdIssueTypeMap, assigneeMap);
        HorizontalBarChartYAxisVO reqIssueStatusHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(reqIssueStatusList);
        HorizontalBarChartYAxisVO reqIssuePriorityHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(reqIssuePriorityList);
        HorizontalBarChartYAxisVO reqIssueTypeHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(reqIssueTypeList);
        HorizontalBarChartYAxisVO notReqIssueStatusHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(notReqIssueStatusList);
        HorizontalBarChartYAxisVO notReqIssuePriorityHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(notReqIssuePriorityList);
        HorizontalBarChartYAxisVO notReqIssueTypeHorizontalBarChartYAxisVO = this.toHorizontalBarChartYAxisVO(notReqIssueTypeList);
        List reqIssueStatusHorizontalBarChartSeries = this.toHorizontalBarChartSeries(reqIssueStatusList, reqIssueStatusHorizontalBarChartYAxisVO);
        List reqIssuePriorityHorizontalBarChartSeries = this.toHorizontalBarChartSeries(reqIssuePriorityList, reqIssuePriorityHorizontalBarChartYAxisVO);
        List reqIssueTypeHorizontalBarChartSeries = this.toHorizontalBarChartSeries(reqIssueTypeList, reqIssueTypeHorizontalBarChartYAxisVO);
        List notReqIssueStatusHorizontalBarChartSeries = this.toHorizontalBarChartSeries(notReqIssueStatusList, notReqIssueStatusHorizontalBarChartYAxisVO);
        List notReqIssuePriorityHorizontalBarChartSeries = this.toHorizontalBarChartSeries(notReqIssuePriorityList, notReqIssuePriorityHorizontalBarChartYAxisVO);
        List notReqIssueTypeHorizontalBarChartSeries = this.toHorizontalBarChartSeries(notReqIssueTypeList, notReqIssueTypeHorizontalBarChartYAxisVO);
        ArrayList<HorizontalBarChartYAxisAndSeriesVO> reqChartYAxisAndSeriesVOList = new ArrayList<HorizontalBarChartYAxisAndSeriesVO>();
        ArrayList<HorizontalBarChartYAxisAndSeriesVO> notReqChartYAxisAndSeriesVOList = new ArrayList<HorizontalBarChartYAxisAndSeriesVO>();
        reqChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("status").yAxisVO(reqIssueStatusHorizontalBarChartYAxisVO).series(reqIssueStatusHorizontalBarChartSeries).build());
        reqChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("priority").yAxisVO(reqIssuePriorityHorizontalBarChartYAxisVO).series(reqIssuePriorityHorizontalBarChartSeries).build());
        reqChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("issuetype").yAxisVO(reqIssueTypeHorizontalBarChartYAxisVO).series(reqIssueTypeHorizontalBarChartSeries).build());
        notReqChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("status").yAxisVO(notReqIssueStatusHorizontalBarChartYAxisVO).series(notReqIssueStatusHorizontalBarChartSeries).build());
        notReqChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("priority").yAxisVO(notReqIssuePriorityHorizontalBarChartYAxisVO).series(notReqIssuePriorityHorizontalBarChartSeries).build());
        notReqChartYAxisAndSeriesVOList.add(HorizontalBarChartYAxisAndSeriesVO.builder().name("issuetype").yAxisVO(notReqIssueTypeHorizontalBarChartYAxisVO).series(notReqIssueTypeHorizontalBarChartSeries).build());
        return ReqAndNotReqHorizontalBarChartVO.builder().reqChartYAxisAndSeriesVOList(reqChartYAxisAndSeriesVOList).notReqChartYAxisAndSeriesVOList(notReqChartYAxisAndSeriesVOList).build();
    }

    private void incrementIssueProperty(Map<String, Map<String, IssuePropertyVO>> targetMap, String accountId, String propertyName) {
        String key = propertyName == null || propertyName.isBlank() ? "UNKNOWN" : propertyName;
        Map innerMap = targetMap.computeIfAbsent(accountId, k -> new HashMap());
        innerMap.compute(propertyName, (k, vo) -> {
            if (vo == null) {
                return IssuePropertyVO.builder().name(key).value(Long.valueOf(1L)).build();
            }
            vo.setValue(Long.valueOf(vo.getValue() + 1L));
            return vo;
        });
    }

    private List<AssigneeIssuePropertiesVO> buildAssigneeIssuePropertiesList(Map<String, Map<String, IssuePropertyVO>> accountIdToProperties, Map<String, UniqueAssigneeVO> assigneeMap) {
        ArrayList<AssigneeIssuePropertiesVO> result = new ArrayList<AssigneeIssuePropertiesVO>();
        for (Map.Entry<String, Map<String, IssuePropertyVO>> entry : accountIdToProperties.entrySet()) {
            String accountId = entry.getKey();
            Map<String, IssuePropertyVO> properties = entry.getValue();
            UniqueAssigneeVO assignee = assigneeMap.get(accountId);
            String name = assignee != null ? assignee.getName() : accountId;
            String serverId = assignee != null ? assignee.getServerId() : null;
            String emailAddress = assignee != null ? assignee.getEmailAddress() : null;
            AssigneeIssuePropertiesVO vo = AssigneeIssuePropertiesVO.builder().name(name).serverId(serverId).accountId(accountId).emailAddress(emailAddress).issueProperties(new ArrayList(properties != null ? properties.values() : List.of())).build();
            result.add(vo);
        }
        return result;
    }

    public ReqAndNotReqPieChartVO findPieChartData(ResourceRequestDTO resourceDTO) {
        List accounts = resourceDTO.getAccounts();
        if (!ObjectUtils.isEmpty((Object)accounts)) {
            accounts = this.decodeAccountId(accounts);
            resourceDTO.setAccounts(accounts);
        }
        Map assigneeMap = this.idAssigneeInfoMap(resourceDTO);
        List retrieveIssues = this.retrieveRelevantIssues(resourceDTO);
        if (retrieveIssues.isEmpty()) {
            log.info("findPieChartData :: retrieveIssues.size => 0");
            return ReqAndNotReqPieChartVO.builder().build();
        }
        HashMap<String, PieChartDTO> accountIdReqIssuePieChartDTOMap = new HashMap<String, PieChartDTO>();
        HashMap<String, PieChartDTO> accountIdNotReqIssuePieChartDTOMap = new HashMap<String, PieChartDTO>();
        for (AlmIssueEntity issue : retrieveIssues) {
            PieChartDTO pieChartDTO;
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            String accountId = issue.getAssignee().getAccountId();
            if (this.isRightReqIssue(issue, resourceDTO)) {
                if (accountIdReqIssuePieChartDTOMap.containsKey(accountId)) {
                    pieChartDTO = (PieChartDTO)accountIdReqIssuePieChartDTOMap.get(accountId);
                    pieChartDTO.setValue(Long.valueOf(pieChartDTO.getValue() + 1L));
                    continue;
                }
                accountIdReqIssuePieChartDTOMap.put(accountId, PieChartDTO.builder().name(((UniqueAssigneeVO)assigneeMap.get(accountId)).getName()).accountId(accountId).emailAddress(Optional.ofNullable(((UniqueAssigneeVO)assigneeMap.get(accountId)).getEmailAddress()).orElse("")).value(Long.valueOf(1L)).build());
                continue;
            }
            if (accountIdNotReqIssuePieChartDTOMap.containsKey(accountId)) {
                pieChartDTO = (PieChartDTO)accountIdNotReqIssuePieChartDTOMap.get(accountId);
                pieChartDTO.setValue(Long.valueOf(pieChartDTO.getValue() + 1L));
                continue;
            }
            accountIdNotReqIssuePieChartDTOMap.put(accountId, PieChartDTO.builder().name(((UniqueAssigneeVO)assigneeMap.get(accountId)).getName()).accountId(accountId).emailAddress(Optional.ofNullable(((UniqueAssigneeVO)assigneeMap.get(accountId)).getEmailAddress()).orElse("")).value(Long.valueOf(1L)).build());
        }
        List reqIssuePieChartVOList = accountIdReqIssuePieChartDTOMap.values().stream().map(PieChartVO::fromDTO).collect(Collectors.toList());
        List notReqIssuePieChartVOList = accountIdNotReqIssuePieChartDTOMap.values().stream().map(PieChartVO::fromDTO).collect(Collectors.toList());
        return ReqAndNotReqPieChartVO.builder().reqPieChartVO(this.totalIssueAndPieChartVOFromPieChartList(reqIssuePieChartVOList)).notReqPieChartVO(this.totalIssueAndPieChartVOFromPieChartList(notReqIssuePieChartVOList)).build();
    }

    private TotalIssueAndPieChartVO totalIssueAndPieChartVOFromPieChartList(List<PieChartVO> pieChartVOList) {
        if (ObjectUtils.isEmpty(pieChartVOList)) {
            return TotalIssueAndPieChartVO.builder().totalIssueCount(Long.valueOf(0L)).assigneeAndIssueCounts(Collections.emptyList()).build();
        }
        pieChartVOList.sort(Comparator.comparing(PieChartVO::getValue).reversed());
        Long totalIssueCount = pieChartVOList.stream().mapToLong(PieChartVO::getValue).sum();
        return TotalIssueAndPieChartVO.builder().totalIssueCount(totalIssueCount).assigneeAndIssueCounts(pieChartVOList).build();
    }

    private TotalIssueAndPieChartVO toTotalIssueAndPieChartVO(DocumentAggregations documentAggregations, Map<String, UniqueAssigneeVO> assigneeMap) {
        ArrayList<PieChartVO> assigneeAndIssueCounts = new ArrayList<PieChartVO>();
        List documentBuckets = documentAggregations.deepestList();
        for (DocumentBucket doc : documentBuckets) {
            PieChartVO.PieChartVOBuilder pieChartVOBuilder = PieChartVO.builder();
            String accountId = doc.valueByName("accountId");
            UniqueAssigneeVO assigneeInfo = assigneeMap.get(accountId);
            pieChartVOBuilder.accountId(assigneeInfo.getAccountId()).name(assigneeInfo.getName()).value(doc.countByName("accountId"));
            String assigneeEmail = assigneeInfo.getEmailAddress();
            if (assigneeEmail != null && !assigneeEmail.isEmpty()) {
                pieChartVOBuilder.emailAddress(assigneeEmail);
            }
            assigneeAndIssueCounts.add(pieChartVOBuilder.build());
        }
        TotalIssueAndPieChartVO.TotalIssueAndPieChartVOBuilder totalIssueAndPieChartVOBuilder = TotalIssueAndPieChartVO.builder();
        totalIssueAndPieChartVOBuilder.totalIssueCount(documentAggregations.getTotalHits());
        totalIssueAndPieChartVOBuilder.assigneeAndIssueCounts(assigneeAndIssueCounts);
        return totalIssueAndPieChartVOBuilder.build();
    }

    private List<HorizontalBarChartSeriesVO> toHorizontalBarChartSeries(List<AssigneeIssuePropertiesVO> assigneeIssuePropertyVOsList, HorizontalBarChartYAxisVO horizontalBarChartYAxisVO) {
        ArrayList<HorizontalBarChartSeriesVO> horizontalBarChartSeries = new ArrayList<HorizontalBarChartSeriesVO>();
        List propertyNames = horizontalBarChartYAxisVO.getData();
        for (AssigneeIssuePropertiesVO assigneeIssuePropertiesVO : assigneeIssuePropertyVOsList) {
            HorizontalBarChartSeriesVO.HorizontalBarChartSeriesVOBuilder horizontalBarChartSeriesVOBuilder = HorizontalBarChartSeriesVO.builder().name(assigneeIssuePropertiesVO.getName()).accountId(assigneeIssuePropertiesVO.getAccountId()).emailAddress(Optional.ofNullable(assigneeIssuePropertiesVO.getEmailAddress()).orElse("")).type("bar");
            List issueProperties = assigneeIssuePropertiesVO.getIssueProperties();
            Map issuePropertyMap = issueProperties.stream().collect(Collectors.toMap(IssuePropertyVO::getName, IssuePropertyVO::getValue, (a, b) -> b, LinkedHashMap::new));
            horizontalBarChartSeriesVOBuilder.data(propertyNames.stream().map(propertyName -> issuePropertyMap.getOrDefault(propertyName, 0L)).collect(Collectors.toList()));
            horizontalBarChartSeries.add(horizontalBarChartSeriesVOBuilder.build());
        }
        return horizontalBarChartSeries;
    }

    private HorizontalBarChartYAxisVO toHorizontalBarChartYAxisVO(List<AssigneeIssuePropertiesVO> assigneeIssuePropertyVOS) {
        Set propertyNameSet = assigneeIssuePropertyVOS.stream().flatMap(issueProperties -> issueProperties.getIssueProperties().stream()).map(IssuePropertyVO::getName).collect(Collectors.toSet());
        ArrayList propertyNames = new ArrayList(propertyNameSet);
        return HorizontalBarChartYAxisVO.builder().type("category").data(propertyNames).build();
    }

    public List<UniqueAssigneeVO> findAssigneesInfo(ResourceRequestDTO resourceDTO) {
        Map uniquedAssigneeMap = this.idAssigneeInfoMap(resourceDTO);
        return new ArrayList<UniqueAssigneeVO>(uniquedAssigneeMap.values());
    }

    private List<String> decodeAccountId(List<String> accountIdList) {
        ArrayList<String> decodedList = new ArrayList<String>();
        for (String accountId : accountIdList) {
            String decoded = new String(Base64.getDecoder().decode(accountId));
            decodedList.add(decoded);
        }
        return decodedList;
    }

    public List<TreeMapWorkerVO> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO dto) {
        IssueTypeV3 type;
        ResourceRequestDTO resourceDTO = new ResourceRequestDTO();
        resourceDTO.setSize(dto.getSize());
        resourceDTO.setPdServiceAndIsReq(dto.getPdServiceAndIsReq());
        resourceDTO.setAccounts(dto.getAccounts());
        List retrieveIssues = this.retrieveRelevantIssuesRegardsLessOfAssignee(resourceDTO);
        if (retrieveIssues.isEmpty()) {
            log.info("findTreeMapChartDataV3 :: retrieveIssues.size => 0");
            return Collections.emptyList();
        }
        TreeMapContextV3 context = TreeMapContextV3.builder().rightReqIssues(new HashMap()).rightSubtask(new HashMap()).notReqIssuesHasPd(new HashMap()).justLinkedKeyIssues(new HashMap()).issueTypeCache(new HashMap()).reqInfoCache(new HashMap()).contributionMap(new HashMap()).processedIssuesByAssignee(new HashMap()).pdServiceId(resourceDTO.getPdServiceAndIsReq().getPdServiceId()).versionIdNames(dto.getVersionIdNames()).workerTaskMap(new HashMap()).build();
        for (AlmIssueEntity issue : retrieveIssues) {
            type = this.categorizeIssueV3(issue, resourceDTO, context.getPdServiceId());
            context.getIssueTypeCache().put(issue.getRecentId(), type);
            this.storeIssueByTypeForTreeMapV3(issue, type, context);
        }
        this.cacheReqDisplayInfo(context);
        for (AlmIssueEntity issue : retrieveIssues) {
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            type = (IssueTypeV3)context.getIssueTypeCache().get(issue.getRecentId());
            this.processIssueByType(issue, type, context);
        }
        return this.buildSortedResultForTreeMap(context, dto.getSize());
    }

    private void storeIssueByTypeForTreeMapV3(AlmIssueEntity issue, IssueTypeV3 type, TreeMapContextV3 context) {
        String recentId = issue.getRecentId();
        switch (type.ordinal()) {
            case 0: {
                context.getRightReqIssues().put(recentId, issue);
                break;
            }
            case 1: {
                context.getRightSubtask().put(recentId, issue);
                break;
            }
            case 2: {
                context.getNotReqIssuesHasPd().put(recentId, issue);
                break;
            }
            case 3: 
            case 4: {
                context.getJustLinkedKeyIssues().put(recentId, issue);
            }
        }
    }

    private void cacheReqDisplayInfo(TreeMapContextV3 context) {
        for (AlmIssueEntity reqIssue : context.getRightReqIssues().values()) {
            String reqKey = reqIssue.getKey();
            if (context.getReqInfoCache().containsKey(reqKey)) continue;
            String versionNames = AnalysisResourceImpl.getVersionName((List)reqIssue.getPdServiceVersions(), (List)context.getVersionIdNames());
            String summary = reqIssue.getSummary() != null ? reqIssue.getSummary() : "Requirement-Issue not found.";
            ReqDisplayInfo info = ReqDisplayInfo.builder().reqKey(reqKey).versionNames(versionNames).summary(summary).displayName("[ " + versionNames + " ] - " + summary).build();
            context.getReqInfoCache().put(reqKey, info);
        }
    }

    private void processIssueByType(AlmIssueEntity issue, IssueTypeV3 type, TreeMapContextV3 context) {
        String accountId = issue.getAssignee().getAccountId();
        String displayName = issue.getAssignee().getDisplayName();
        switch (type.ordinal()) {
            case 0: {
                this.addContribution(accountId, displayName, issue.getKey(), issue.getRecentId(), context);
                this.processLinkedIssuesForTreeMapV3(issue, accountId, displayName, context);
                break;
            }
            case 1: {
                AlmIssueEntity parentReq = this.findParentReqIssue(issue, context);
                if (parentReq != null) {
                    this.addContribution(accountId, displayName, parentReq.getKey(), issue.getRecentId(), context);
                }
                this.processLinkedIssuesForTreeMapV3(issue, accountId, displayName, context);
                break;
            }
            case 2: 
            case 3: {
                this.processLinkedIssuesForTreeMapV3(issue, accountId, displayName, context);
                break;
            }
            case 4: {
                this.processLinkedIssuesForTreeMapV3(issue, accountId, displayName, context);
                this.processParentLinkedIssues(issue, accountId, displayName, context);
            }
        }
    }

    private AlmIssueEntity findParentReqIssue(AlmIssueEntity subtask, TreeMapContextV3 context) {
        String parentReqRecentId = this.getRecentIdFromSubLinkIssue(subtask);
        return (AlmIssueEntity)context.getRightReqIssues().get(parentReqRecentId);
    }

    private AlmIssueEntity findReqFromLinkedIssue(String linkedRecentId, TreeMapContextV3 context) {
        AlmIssueEntity reqIssue = (AlmIssueEntity)context.getRightReqIssues().get(linkedRecentId);
        if (reqIssue != null) {
            return reqIssue;
        }
        AlmIssueEntity subtask = (AlmIssueEntity)context.getRightSubtask().get(linkedRecentId);
        if (subtask != null) {
            return this.findParentReqIssue(subtask, context);
        }
        return null;
    }

    private void processLinkedIssuesForTreeMapV3(AlmIssueEntity currentIssue, String accountId, String displayName, TreeMapContextV3 context) {
        List linkedIssues = currentIssue.getLinkedIssues();
        if (linkedIssues == null || linkedIssues.isEmpty()) {
            return;
        }
        for (String linkedRecentId : linkedIssues) {
            AlmIssueEntity reqIssue = this.findReqFromLinkedIssue(linkedRecentId, context);
            if (reqIssue == null) continue;
            this.addContribution(accountId, displayName, reqIssue.getKey(), currentIssue.getRecentId(), context);
        }
    }

    private void processParentLinkedIssues(AlmIssueEntity issue, String accountId, String displayName, TreeMapContextV3 context) {
        if (ObjectUtils.isEmpty((Object)issue.getParentReqKey())) {
            return;
        }
        String parentRecentId = this.getRecentIdFromSubLinkIssue(issue);
        AlmIssueEntity parent = (AlmIssueEntity)context.getJustLinkedKeyIssues().get(parentRecentId);
        if (parent != null && parent.getLinkedIssues() != null) {
            for (String linkedRecentId : parent.getLinkedIssues()) {
                AlmIssueEntity reqIssue = this.findReqFromLinkedIssue(linkedRecentId, context);
                if (reqIssue == null) continue;
                this.addContribution(accountId, displayName, reqIssue.getKey(), issue.getRecentId(), context);
            }
        }
    }

    private void addContribution(String accountId, String displayName, String reqKey, String currentIssueRecentId, TreeMapContextV3 context) {
        String duplicateKey = reqKey + "::" + currentIssueRecentId;
        Set processedKeys = context.getProcessedIssuesByAssignee().computeIfAbsent(accountId, k -> new HashSet());
        if (processedKeys.contains(duplicateKey)) {
            return;
        }
        processedKeys.add(duplicateKey);
        TreeMapWorkerVO worker = context.getContributionMap().computeIfAbsent(accountId, id -> {
            HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
            dataMap.put("totalInvolvedCount", 0);
            return TreeMapWorkerVO.builder().id(accountId).name(displayName).data(dataMap).children(new ArrayList()).build();
        });
        Map taskMap = context.getWorkerTaskMap().computeIfAbsent(accountId, k -> new HashMap());
        TreeMapTaskListVO taskList = taskMap.computeIfAbsent(reqKey, k -> {
            ReqDisplayInfo info = (ReqDisplayInfo)context.getReqInfoCache().get(reqKey);
            Object taskName = info != null ? info.getDisplayName() : "[ Unknown ] - " + reqKey;
            HashMap<String, Integer> dataList = new HashMap<String, Integer>();
            dataList.put("involvedCount", 0);
            return TreeMapTaskListVO.builder().id(reqKey).name((String)taskName).data(dataList).build();
        });
        taskList.getData().put("involvedCount", (Integer)taskList.getData().get("involvedCount") + 1);
        worker.getData().put("totalInvolvedCount", (Integer)worker.getData().get("totalInvolvedCount") + 1);
    }

    private List<TreeMapWorkerVO> buildSortedResultForTreeMap(TreeMapContextV3 context, int size) {
        for (Map.Entry entry : context.getContributionMap().entrySet()) {
            String accountId = (String)entry.getKey();
            TreeMapWorkerVO worker = (TreeMapWorkerVO)entry.getValue();
            Map taskMap = (Map)context.getWorkerTaskMap().get(accountId);
            if (taskMap == null) continue;
            worker.getChildren().clear();
            worker.getChildren().addAll(taskMap.values());
        }
        Stream sortedStream = context.getContributionMap().values().stream().sorted((w1, w2) -> ((Integer)w2.getData().get("totalInvolvedCount")).compareTo((Integer)w1.getData().get("totalInvolvedCount")));
        if (size > 0) {
            sortedStream = sortedStream.limit(size);
        }
        return sortedStream.toList();
    }

    public List<TreeMapWorkerVO> findTreeMapChartDataV2(ResourceWithVersionIdNamesDTO dto) {
        ResourceRequestDTO resourceDTO = new ResourceRequestDTO();
        resourceDTO.setSize(dto.getSize());
        resourceDTO.setPdServiceAndIsReq(dto.getPdServiceAndIsReq());
        resourceDTO.setAccounts(dto.getAccounts());
        List retrieveIssues = this.retrieveRelevantIssuesRegardsLessOfAssignee(resourceDTO);
        if (retrieveIssues.isEmpty()) {
            log.info("findTreeMapChartDataV2 :: retrieveIssues.size => 0");
            return Collections.emptyList();
        }
        TreeMapContextV2 context = TreeMapContextV2.builder().rightReqIssues(new HashMap()).rightSubtask(new HashMap()).notReqIssuesHasPd(new HashMap()).justLinkedKeyIssues(new HashMap()).contributionMap(new HashMap()).processedIssuesByAssignee(new HashMap()).pdServiceId(resourceDTO.getPdServiceAndIsReq().getPdServiceId()).versionIdNames(dto.getVersionIdNames()).build();
        for (AlmIssueEntity issue : retrieveIssues) {
            IssueTypeV3 type = this.categorizeIssueV3(issue, resourceDTO, context.getPdServiceId());
            this.storeIssueByTypeForTreeMap(issue, type, context);
        }
        for (AlmIssueEntity issue : retrieveIssues) {
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            this.processIssueForTreeMap(issue, resourceDTO, context);
        }
        Stream sortedVOList = context.getContributionMap().values().stream().sorted((w1, w2) -> ((Integer)w2.getData().get("totalInvolvedCount")).compareTo((Integer)w1.getData().get("totalInvolvedCount")));
        if (dto.getSize() > 0) {
            sortedVOList = sortedVOList.limit(dto.getSize());
        }
        return sortedVOList.toList();
    }

    private void storeIssueByTypeForTreeMap(AlmIssueEntity issue, IssueTypeV3 type, TreeMapContextV2 context) {
        switch (type.ordinal()) {
            case 0: {
                context.getRightReqIssues().put(issue.getRecentId(), issue);
                break;
            }
            case 1: {
                context.getRightSubtask().put(issue.getRecentId(), issue);
                break;
            }
            case 2: {
                context.getNotReqIssuesHasPd().put(issue.getRecentId(), issue);
                break;
            }
            case 3: 
            case 4: {
                context.getJustLinkedKeyIssues().put(issue.getRecentId(), issue);
            }
        }
    }

    private void processIssueForTreeMap(AlmIssueEntity issue, ResourceRequestDTO resourceDTO, TreeMapContextV2 context) {
        IssueTypeV3 type = this.categorizeIssueV3(issue, resourceDTO, context.getPdServiceId());
        String accountId = issue.getAssignee().getAccountId();
        String displayName = issue.getAssignee().getDisplayName();
        switch (type.ordinal()) {
            case 0: {
                this.addContributionWithDuplicateCheck(accountId, displayName, issue, issue.getRecentId(), context);
                this.processLinkedIssuesForTreeMap(issue, context);
                break;
            }
            case 1: {
                String parentReqRecentId = this.getRecentIdFromSubLinkIssue(issue);
                AlmIssueEntity parentReqIssue = (AlmIssueEntity)context.getRightReqIssues().get(parentReqRecentId);
                if (parentReqIssue != null) {
                    this.addContributionWithDuplicateCheck(accountId, displayName, parentReqIssue, issue.getRecentId(), context);
                }
                this.processLinkedIssuesForTreeMap(issue, context);
                break;
            }
            case 2: {
                this.processLinkedIssuesForTreeMap(issue, context);
                break;
            }
            case 3: {
                this.processLinkedIssuesForTreeMap(issue, context);
                break;
            }
            case 4: {
                this.processLinkedIssuesForTreeMap(issue, context);
                this.processParentLinkedIssuesForTreeMap(issue, context);
            }
        }
    }

    private void processLinkedIssuesForTreeMap(AlmIssueEntity currentIssue, TreeMapContextV2 context) {
        if (currentIssue.getLinkedIssues() == null || currentIssue.getLinkedIssues().isEmpty()) {
            return;
        }
        String accountId = currentIssue.getAssignee().getAccountId();
        String displayName = currentIssue.getAssignee().getDisplayName();
        this.processLinkedIssuesForTreeMapWithAssignee(currentIssue.getLinkedIssues(), accountId, displayName, currentIssue.getRecentId(), context);
    }

    private void processLinkedIssuesForTreeMapWithAssignee(List<String> linkedIssueRecentIds, String accountId, String displayName, String currentIssueRecentId, TreeMapContextV2 context) {
        if (linkedIssueRecentIds == null || linkedIssueRecentIds.isEmpty()) {
            return;
        }
        for (String linkedRecentId : linkedIssueRecentIds) {
            AlmIssueEntity linkedReqIssue = (AlmIssueEntity)context.getRightReqIssues().get(linkedRecentId);
            if (linkedReqIssue != null) {
                this.addContributionWithDuplicateCheck(accountId, displayName, linkedReqIssue, currentIssueRecentId, context);
                continue;
            }
            AlmIssueEntity linkedSubtask = (AlmIssueEntity)context.getRightSubtask().get(linkedRecentId);
            if (linkedSubtask == null) continue;
            String parentReqRecentId = this.getRecentIdFromSubLinkIssue(linkedSubtask);
            AlmIssueEntity parentReqIssue = (AlmIssueEntity)context.getRightReqIssues().get(parentReqRecentId);
            if (parentReqIssue == null) continue;
            this.addContributionWithDuplicateCheck(accountId, displayName, parentReqIssue, currentIssueRecentId, context);
        }
    }

    private void processParentLinkedIssuesForTreeMap(AlmIssueEntity issue, TreeMapContextV2 context) {
        if (ObjectUtils.isEmpty((Object)issue.getParentReqKey())) {
            return;
        }
        String parentLinkedIssueRecentId = this.getRecentIdFromSubLinkIssue(issue);
        AlmIssueEntity parent = (AlmIssueEntity)context.getJustLinkedKeyIssues().get(parentLinkedIssueRecentId);
        if (parent != null) {
            this.processLinkedIssuesForTreeMapWithAssignee(parent.getLinkedIssues(), issue.getAssignee().getAccountId(), issue.getAssignee().getDisplayName(), issue.getRecentId(), context);
        }
    }

    private void addContributionWithDuplicateCheck(String accountId, String displayName, AlmIssueEntity reqIssue, String currentIssueRecentId, TreeMapContextV2 context) {
        String duplicateKey = reqIssue.getKey() + "::" + currentIssueRecentId;
        Set processedKeys = context.getProcessedIssuesByAssignee().computeIfAbsent(accountId, k -> new HashSet());
        if (processedKeys.contains(duplicateKey)) {
            return;
        }
        processedKeys.add(duplicateKey);
        TreeMapWorkerVO worker = context.getContributionMap().computeIfAbsent(accountId, id -> {
            HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
            dataMap.put("totalInvolvedCount", 0);
            return TreeMapWorkerVO.builder().id(accountId).name(displayName).data(dataMap).children(new ArrayList()).build();
        });
        String versionNames = AnalysisResourceImpl.getVersionName((List)reqIssue.getPdServiceVersions(), (List)context.getVersionIdNames());
        String summary = reqIssue.getSummary() != null ? reqIssue.getSummary() : "Requirement-Issue not found.";
        TreeMapTaskListVO taskList = worker.getChildren().stream().filter(task -> task.getId().equals(reqIssue.getKey())).findFirst().orElseGet(() -> {
            HashMap<String, Integer> dataList = new HashMap<String, Integer>();
            dataList.put("involvedCount", 0);
            TreeMapTaskListVO newTask = TreeMapTaskListVO.builder().id(reqIssue.getKey()).name("[ " + versionNames + " ] - " + summary).data(dataList).build();
            worker.getChildren().add(newTask);
            return newTask;
        });
        taskList.getData().put("involvedCount", (Integer)taskList.getData().get("involvedCount") + 1);
        worker.getData().put("totalInvolvedCount", (Integer)worker.getData().get("totalInvolvedCount") + 1);
    }

    private static String getVersionName(List<Long> pdServiceVersions, List<VersionIdNameDTO> versionIdNames) {
        return pdServiceVersions.stream().map(versionId -> versionIdNames.stream().filter(p -> p.getC_id().equals(versionId.toString())).findFirst().map(VersionIdNameDTO::getC_title).orElse(null)).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    private List<AlmIssueEntity> retrieveReqIssues(ResourceRequestDTO resourceDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust((String)"pdServiceId", (Object)pdServiceId).andTermsQueryFilter("pdServiceVersions", pdServiceVersions).andTermQueryFilter("isReq", (Object)Boolean.TRUE).andTermsQueryFilter("assignee.assignee_accountId.keyword", resourceDTO.getAccounts()).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(resourceDTO.getStartDate(), resourceDTO.getEndDate())).andExistsQueryFilter("assignee")).toDocs();
    }

    private List<AlmIssueEntity> retrieveRelevantIssues(ResourceRequestDTO resourceDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter((String)"linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", pdServiceVersions).andTermsQueryFilter("assignee.assignee_accountId.keyword", resourceDTO.getAccounts()).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(resourceDTO.getStartDate(), resourceDTO.getEndDate())).andExistsQueryFilter("assignee")).toDocs();
    }

    private List<AlmIssueEntity> retrieveRelevantIssuesRegardsLessOfAssignee(ResourceRequestDTO resourceDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter((String)"linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", pdServiceVersions).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(resourceDTO.getStartDate(), resourceDTO.getEndDate()))).toDocs();
    }

    private List<AlmIssueEntity> excludeRightReqIssue(List<AlmIssueEntity> targetList, ResourceRequestDTO resourceDTO) {
        if (ObjectUtils.isEmpty(targetList)) {
            return Collections.emptyList();
        }
        return targetList.stream().filter(issue -> !this.isRightReqIssue(issue, resourceDTO)).collect(Collectors.toList());
    }

    private boolean isRightReqIssue(AlmIssueEntity issue, ResourceRequestDTO resourceDTO) {
        if (ObjectUtils.isEmpty((Object)issue.getPdServiceId())) {
            return false;
        }
        return Boolean.TRUE.equals(issue.getIsReq()) && Objects.equals(issue.getPdServiceId(), resourceDTO.getPdServiceAndIsReq().getPdServiceId());
    }

    private String resolveStatusName(AlmIssueEntity issue) {
        String name;
        String string = name = issue.getStatus() == null ? null : issue.getStatus().getName();
        if (name == null || name.isBlank()) {
            return "Unknown Status";
        }
        return name;
    }

    private String resolvePriorityName(AlmIssueEntity issue) {
        String name;
        String string = name = issue.getPriority() == null ? null : issue.getPriority().getName();
        if (name == null || name.isBlank()) {
            return "Unknown Priority";
        }
        return name;
    }

    private String resolveIssueTypeName(AlmIssueEntity issue) {
        String name;
        String string = name = issue.getIssuetype() == null ? null : issue.getIssuetype().getName();
        if (name == null || name.isBlank()) {
            return "Unknown IssueType";
        }
        return name;
    }

    private String getRecentIdFromSubLinkIssue(AlmIssueEntity issue) {
        String serverProjectPrefix = ParseUtil.getPrefixIncludingLastDelimiter((String)issue.recentId());
        if (ObjectUtils.isEmpty((Object)serverProjectPrefix)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(serverProjectPrefix);
        sb.append(issue.getParentReqKey());
        return sb.toString();
    }

    private List<Long> getVersionsSafely(AlmIssueEntity issue) {
        return Optional.ofNullable(issue.getPdServiceVersions()).filter(list -> !list.isEmpty()).orElse(Collections.emptyList());
    }

    private void decodeAccountsIfNeeded(ResourceRequestDTO resourceDTO) {
        List accounts = resourceDTO.getAccounts();
        if (!ObjectUtils.isEmpty((Object)accounts)) {
            accounts = this.decodeAccountId(accounts);
            resourceDTO.setAccounts(accounts);
        }
    }

    private boolean isIssueValid(AlmIssueEntity issue, ResourceRequestDTO dto) {
        String accountId;
        if (issue == null || issue.getAssignee() == null) {
            return false;
        }
        List accounts = dto.getAccounts();
        if (!(accounts == null || accounts.isEmpty() || (accountId = issue.getAssignee().getAccountId()) != null && accounts.contains(accountId))) {
            return false;
        }
        String startDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        return (startDate == null || startDate.isBlank()) && (endDate == null || endDate.isBlank()) || !DateRangeUtil.isNotWithinDateRange((Date)issue.getUpdated(), (String)startDate, (String)endDate);
    }

    public List<SankeyChartBaseVO> sankeyChartBaseDataV3(ResourceRequestDTO resourceDTO) {
        this.decodeAccountsIfNeeded(resourceDTO);
        List retrieveIssues = this.retrieveRelevantIssues(resourceDTO);
        if (retrieveIssues.isEmpty()) {
            log.info("sankeyChartBaseDataV3Refactor :: retrieveIssues.size => 0");
            return Collections.emptyList();
        }
        SankeyContextV3 context = SankeyContextV3.builder().rightReqIssues(new HashMap()).rightSubtask(new HashMap()).notReqIssuesHasPd(new HashMap()).justLinkedKeyIssues(new HashMap()).summaryMap(new HashMap()).pdServiceId(resourceDTO.getPdServiceAndIsReq().getPdServiceId()).build();
        for (AlmIssueEntity issue : retrieveIssues) {
            IssueTypeV3 type = this.categorizeIssueV3(issue, resourceDTO, context.getPdServiceId());
            this.storeIssueByTypeForSankey(issue, type, context);
        }
        for (AlmIssueEntity issue : retrieveIssues) {
            if (!this.isIssueValid(issue, resourceDTO)) continue;
            this.processIssueForSankeyV3(issue, resourceDTO, context);
        }
        return this.buildSankeyChartBaseListV3(context.getSummaryMap());
    }

    private void processIssueForSankeyV3(AlmIssueEntity issue, ResourceRequestDTO resourceDTO, SankeyContextV3 context) {
        IssueTypeV3 type = this.categorizeIssueV3(issue, resourceDTO, context.getPdServiceId());
        switch (type.ordinal()) {
            case 0: {
                this.processRightReqIssueForSankeyV3(issue, context, true);
                break;
            }
            case 1: {
                this.processRightReqIssueForSankeyV3(issue, context, false);
                break;
            }
            case 2: {
                this.processNotReqWithPdIssueV3(issue, context);
                break;
            }
            case 3: {
                this.processLinkedOnlyIssueV3(issue, context, false);
                break;
            }
            case 4: {
                this.processLinkedOnlyIssueV3(issue, context, true);
            }
        }
    }

    private IssueTypeV3 categorizeIssueV3(AlmIssueEntity issue, ResourceRequestDTO resourceDTO, Long pdServiceId) {
        if (this.isRightReqIssue(issue, resourceDTO)) {
            return IssueTypeV3.RIGHT_REQ;
        }
        if (!ObjectUtils.isEmpty((Object)issue.getPdServiceId()) && Objects.equals(issue.getPdServiceId(), pdServiceId) && Boolean.FALSE.equals(issue.getIsReq())) {
            return IssueTypeV3.RIGHT_SUBTASK;
        }
        if (!ObjectUtils.isEmpty((Object)issue.getPdServiceId())) {
            return IssueTypeV3.NOT_REQ_WITH_PD;
        }
        if (!ObjectUtils.isEmpty((Object)issue.getParentReqKey())) {
            return IssueTypeV3.LINKED_SUBTASK;
        }
        return IssueTypeV3.LINKED_ONLY;
    }

    private void storeIssueByTypeForSankey(AlmIssueEntity issue, IssueTypeV3 type, SankeyContextV3 context) {
        switch (type.ordinal()) {
            case 0: {
                context.getRightReqIssues().put(issue.getRecentId(), issue);
                break;
            }
            case 1: {
                context.getRightSubtask().put(issue.getRecentId(), issue);
                break;
            }
            case 2: {
                context.getNotReqIssuesHasPd().put(issue.getRecentId(), issue);
                break;
            }
            case 3: 
            case 4: {
                context.getJustLinkedKeyIssues().put(issue.getRecentId(), issue);
            }
        }
    }

    private void processRightReqIssueForSankeyV3(AlmIssueEntity issue, SankeyContextV3 context, boolean isReqIssue) {
        this.getVersionsSafely(issue).forEach(versionId -> this.updateVersionSummary(versionId, issue, context.getSummaryMap(), isReqIssue));
        this.processLinkedIssuesV3(issue, context);
    }

    private void processNotReqWithPdIssueV3(AlmIssueEntity issue, SankeyContextV3 context) {
        this.processLinkedIssuesV3(issue, context);
    }

    private void processLinkedOnlyIssueV3(AlmIssueEntity issue, SankeyContextV3 context, boolean hasParent) {
        this.processLinkedIssuesV3(issue, context);
        if (hasParent) {
            this.findParentAndProcessLinked(issue, context);
        }
    }

    private void processLinkedIssuesV3(AlmIssueEntity currentIssue, SankeyContextV3 context) {
        if (currentIssue.getLinkedIssues() == null || currentIssue.getLinkedIssues().isEmpty()) {
            return;
        }
        for (String linkedRecentId : currentIssue.getLinkedIssues()) {
            this.processLinkedIssue(currentIssue, linkedRecentId, context);
        }
    }

    private void processLinkedIssue(AlmIssueEntity currentIssue, String linkedRecentId, SankeyContextV3 context) {
        boolean isReqIssue;
        AlmIssueEntity linkedIssue = (AlmIssueEntity)context.getRightReqIssues().get(linkedRecentId);
        if (linkedIssue == null) {
            linkedIssue = (AlmIssueEntity)context.getRightSubtask().get(linkedRecentId);
            isReqIssue = false;
        } else {
            isReqIssue = true;
        }
        if (linkedIssue == null) {
            return;
        }
        this.getVersionsSafely(linkedIssue).forEach(versionId -> this.updateVersionSummaryWithDuplicateCheck(versionId, currentIssue, context.getSummaryMap(), isReqIssue));
    }

    private void updateVersionSummaryWithDuplicateCheck(Long versionId, AlmIssueEntity issue, Map<Long, VersionAssigneeSummary> summaryMap, boolean isReqIssue) {
        VersionAssigneeSummary summary = summaryMap.computeIfAbsent(versionId, k -> VersionAssigneeSummary.builder().versionId(versionId).treatedIssue(new HashSet()).accountIdSummaryMap(new HashMap()).build());
        if (summary.getTreatedIssue().contains(issue.getRecentId())) {
            return;
        }
        if (issue.getAssignee() == null || issue.getAssignee().getAccountId() == null) {
            return;
        }
        this.updateCount(summary, issue.getAssignee(), isReqIssue);
        summary.getTreatedIssue().add(issue.getRecentId());
    }

    private void updateVersionSummary(Long versionId, AlmIssueEntity issue, Map<Long, VersionAssigneeSummary> summaryMap, boolean isReqIssue) {
        VersionAssigneeSummary summary = summaryMap.computeIfAbsent(versionId, k -> VersionAssigneeSummary.builder().versionId(versionId).treatedIssue(new HashSet()).accountIdSummaryMap(new HashMap()).build());
        if (summary.getTreatedIssue().contains(issue.getRecentId())) {
            return;
        }
        this.updateCount(summary, issue.getAssignee(), isReqIssue);
        summary.getTreatedIssue().add(issue.getRecentId());
    }

    private void updateCount(VersionAssigneeSummary summary, AlmIssueEntity.Assignee assignee, boolean isReqIssue) {
        String accountId = assignee.getAccountId();
        VersionAssigneeSummaryVO vo = summary.getAccountIdSummaryMap().computeIfAbsent(accountId, k -> {
            VersionAssigneeSummaryVO newVo = VersionAssigneeSummaryVO.builder().versionId(summary.getVersionId()).accountId(accountId).name(assignee.getDisplayName()).emailAddress(assignee.getEmailAddress()).totalIssue(Long.valueOf(0L)).reqIssueCount(Long.valueOf(0L)).notReqIssueCount(Long.valueOf(0L)).build();
            newVo.setVersionAccountId(summary.getVersionId(), accountId);
            return newVo;
        });
        if (isReqIssue) {
            vo.addReqIssueCount();
            vo.sumReqIssueCountToTotal(Long.valueOf(1L));
        } else {
            vo.addNotReqIssueCount();
            vo.sumNotReqIssueCountToTotal(Long.valueOf(1L));
        }
    }

    private void findParentAndProcessLinked(AlmIssueEntity issue, SankeyContextV3 context) {
        if (ObjectUtils.isEmpty((Object)issue.getParentReqKey())) {
            return;
        }
        String parentLinkedIssueRecentId = this.getRecentIdFromSubLinkIssue(issue);
        AlmIssueEntity parent = context.getJustLinkedKeyIssues().values().stream().filter(i -> parentLinkedIssueRecentId.equals(i.getKey())).findFirst().orElse(null);
        if (parent != null) {
            this.processLinkedIssuesV3(parent, context);
        }
    }

    private void processLinkedIssuesOnly(AlmIssueEntity currentIssue, Map<String, AlmIssueEntity> rightReqIssues, Map<String, AlmIssueEntity> rightSubtask, Map<Long, VersionAssigneeSummary> summaryMap) {
        if (currentIssue.getLinkedIssues() == null || currentIssue.getLinkedIssues().isEmpty()) {
            return;
        }
        for (String linkedRecentId : currentIssue.getLinkedIssues()) {
            AlmIssueEntity linkedIssue = null;
            boolean isReqIssue = false;
            if (rightReqIssues.containsKey(linkedRecentId)) {
                linkedIssue = rightReqIssues.get(linkedRecentId);
                isReqIssue = true;
            } else if (rightSubtask.containsKey(linkedRecentId)) {
                linkedIssue = rightSubtask.get(linkedRecentId);
                isReqIssue = false;
            }
            if (linkedIssue == null || linkedIssue.getPdServiceVersions() == null || linkedIssue.getPdServiceVersions().isEmpty()) continue;
            for (Long versionId : linkedIssue.getPdServiceVersions()) {
                this.countLinkedIssueForVersion(versionId, currentIssue, summaryMap, isReqIssue);
            }
        }
    }

    private void countLinkedIssueForVersion(Long versionId, AlmIssueEntity currentIssue, Map<Long, VersionAssigneeSummary> summaryMap, boolean isReqIssue) {
        VersionAssigneeSummary summary = summaryMap.get(versionId);
        if (summary == null) {
            summary = VersionAssigneeSummary.builder().versionId(versionId).treatedIssue(new HashSet()).accountIdSummaryMap(new HashMap()).build();
            summaryMap.put(versionId, summary);
        }
        if (summary.getTreatedIssue().contains(currentIssue.getRecentId())) {
            return;
        }
        if (currentIssue.getAssignee() == null || currentIssue.getAssignee().getAccountId() == null) {
            return;
        }
        String accountId = currentIssue.getAssignee().getAccountId();
        VersionAssigneeSummaryVO vo = summary.getAccountIdSummaryMap().computeIfAbsent(accountId, k -> {
            VersionAssigneeSummaryVO newVo = VersionAssigneeSummaryVO.builder().versionId(versionId).accountId(accountId).name(currentIssue.getAssignee().getDisplayName()).emailAddress(currentIssue.getAssignee().getEmailAddress()).totalIssue(Long.valueOf(0L)).reqIssueCount(Long.valueOf(0L)).notReqIssueCount(Long.valueOf(0L)).build();
            newVo.setVersionAccountId(versionId, accountId);
            return newVo;
        });
        if (isReqIssue) {
            vo.addReqIssueCount();
            vo.sumReqIssueCountToTotal(Long.valueOf(1L));
        } else {
            vo.addNotReqIssueCount();
            vo.sumNotReqIssueCountToTotal(Long.valueOf(1L));
        }
        summary.getTreatedIssue().add(currentIssue.getRecentId());
    }

    private void processJustLinkedIssue(AlmIssueEntity issue, Map<String, AlmIssueEntity> rightReqIssues, Map<String, AlmIssueEntity> rightSubtask, Map<String, AlmIssueEntity> justLinkedKeyIssues, Map<Long, VersionAssigneeSummary> summaryMap) {
        AlmIssueEntity parentIssue;
        this.processLinkedIssuesOnly(issue, rightReqIssues, rightSubtask, summaryMap);
        if (!ObjectUtils.isEmpty((Object)issue.getParentReqKey()) && (parentIssue = this.findParentIssueInJustLinked(issue.getParentReqKey(), justLinkedKeyIssues)) != null) {
            this.processLinkedIssuesOnly(parentIssue, rightReqIssues, rightSubtask, summaryMap);
        }
    }

    private AlmIssueEntity findParentIssueInJustLinked(String parentReqKey, Map<String, AlmIssueEntity> justLinkedKeyIssues) {
        for (AlmIssueEntity issue : justLinkedKeyIssues.values()) {
            if (!parentReqKey.equals(issue.getKey())) continue;
            return issue;
        }
        return null;
    }

    private List<SankeyChartBaseVO> buildSankeyChartBaseListV3(Map<Long, VersionAssigneeSummary> summaryMap) {
        if (summaryMap == null || summaryMap.isEmpty()) {
            return Collections.emptyList();
        }
        return summaryMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            Long versionId = (Long)entry.getKey();
            VersionAssigneeSummary summary = (VersionAssigneeSummary)entry.getValue();
            List sortedList = summary.getAccountIdSummaryMap().values().stream().filter(Objects::nonNull).sorted(Comparator.comparingLong(vo -> Optional.ofNullable(vo.getTotalIssue()).orElse(0L)).reversed().thenComparing(vo -> Optional.ofNullable(vo.getAccountId()).orElse(""))).collect(Collectors.toList());
            return SankeyChartBaseVO.builder().versionId(versionId).versionAssigneeSummaryVOList(sortedList).build();
        }).collect(Collectors.toList());
    }

    @Generated
    public AnalysisResourceImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

