/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;

public class ShadedClassLoader
extends URLClassLoader {
    public static final String SHADED_CLASS_EXTENSION = ".esclazz";
    private static final String CLASS_EXTENSION = ".class";
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private final String customPrefix;
    private final Manifest manifest;
    private final URL jarUrl;
    private final ThreadLocal<Set<String>> locallyNonAvailableResources = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    public ShadedClassLoader(File jar, ClassLoader parent, String customPrefix) throws IOException {
        super(new URL[]{jar.toURI().toURL()}, parent);
        this.customPrefix = customPrefix;
        this.jarUrl = jar.toURI().toURL();
        try (JarFile jarFile = new JarFile(jar, false);){
            this.manifest = jarFile.getManifest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            try {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, resolve);
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.getShadedClassBytes(name);
        if (classBytes != null) {
            return this.defineClass(name, classBytes);
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> defineClass(String name, byte[] classBytes) {
        block5: {
            String packageName = this.getPackageName(name);
            if (packageName != null && !this.isPackageDefined(packageName)) {
                try {
                    if (this.manifest != null) {
                        this.definePackage(packageName, this.manifest, this.jarUrl);
                    } else {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (this.isPackageDefined(packageName)) break block5;
                    throw e;
                }
            }
        }
        return this.defineClass(name, classBytes, 0, classBytes.length, PROTECTION_DOMAIN);
    }

    private boolean isPackageDefined(String packageName) {
        return this.getPackage(packageName) != null;
    }

    @Nullable
    public String getPackageName(String className) {
        int i = className.lastIndexOf(46);
        if (i != -1) {
            return className.substring(0, i);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getShadedClassBytes(String name) throws ClassNotFoundException {
        try (InputStream is = this.getPrivilegedResourceAsStream(this.customPrefix + name.replace('.', '/') + SHADED_CLASS_EXTENSION);){
            int n;
            if (is == null) return null;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((n = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, n);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private InputStream getPrivilegedResourceAsStream(final String name) {
        if (System.getSecurityManager() == null) {
            return this.getResourceAsStreamInternal(name);
        }
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return ShadedClassLoader.this.getResourceAsStreamInternal(name);
            }
        });
    }

    private InputStream getResourceAsStreamInternal(String name) {
        return super.getResourceAsStream(name);
    }

    @Override
    public URL findResource(final String name) {
        if (this.locallyNonAvailableResources.get().contains(name)) {
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.findResourceInternal(this.getShadedResourceName(name));
        }
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ShadedClassLoader.this.findResourceInternal(ShadedClassLoader.this.getShadedResourceName(name));
            }
        });
    }

    private URL findResourceInternal(String name) {
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.locallyNonAvailableResources.get().contains(name)) {
            return Collections.emptyEnumeration();
        }
        Enumeration<URL> result = super.findResources(this.getShadedResourceName(name));
        if (System.getSecurityManager() == null) {
            return result;
        }
        return new PrivilegedEnumeration<URL>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        URL shadedResource = this.findResource(name);
        if (shadedResource != null) {
            return shadedResource;
        }
        Set<String> locallyNonAvailableResources = this.locallyNonAvailableResources.get();
        try {
            locallyNonAvailableResources.add(name);
            URL uRL = super.getResource(name);
            return uRL;
        }
        finally {
            locallyNonAvailableResources.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> shadedResources = this.findResources(name);
        if (shadedResources.hasMoreElements()) {
            return shadedResources;
        }
        Set<String> locallyNonAvailableResources = this.locallyNonAvailableResources.get();
        try {
            locallyNonAvailableResources.add(name);
            Enumeration<URL> enumeration = super.getResources(name);
            return enumeration;
        }
        finally {
            locallyNonAvailableResources.remove(name);
        }
    }

    private String getShadedResourceName(String name) {
        if (name.startsWith(this.customPrefix)) {
            return name;
        }
        if (name.endsWith(CLASS_EXTENSION)) {
            return this.customPrefix + name.substring(0, name.length() - CLASS_EXTENSION.length()) + SHADED_CLASS_EXTENSION;
        }
        return this.customPrefix + name;
    }

    public String toString() {
        return "ShadedClassLoader{parent=" + this.getParent() + ", customPrefix='" + this.customPrefix + '\'' + ", manifest=" + this.manifest + ", jarUrl=" + this.jarUrl + '}';
    }

    static {
        ClassLoader.registerAsParallelCapable();
        PROTECTION_DOMAIN = System.getSecurityManager() == null ? ShadedClassLoader.class.getProtectionDomain() : AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return ShadedClassLoader.class.getProtectionDomain();
            }
        });
    }

    private static class PrivilegedEnumeration<E>
    implements Enumeration<E> {
        private final Enumeration<E> delegate;

        private PrivilegedEnumeration(Enumeration<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasMoreElements() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return PrivilegedEnumeration.this.delegate.hasMoreElements();
                }
            });
        }

        @Override
        public E nextElement() {
            return (E)AccessController.doPrivileged(new PrivilegedAction<E>(){

                @Override
                public E run() {
                    return PrivilegedEnumeration.this.delegate.nextElement();
                }
            });
        }
    }
}

