/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextOperation {
    private List<Object> ops = new ArrayList();
    private int baseLength = 0;
    private int targetLength = 0;

    public static boolean isRetain(Object op) {
        return op instanceof Integer && (Integer)op > 0;
    }

    public static boolean isInsert(Object op) {
        return op instanceof String;
    }

    public static boolean isDelete(Object op) {
        return op instanceof Integer && (Integer)op < 0;
    }

    public TextOperation() {
    }

    @JsonCreator
    public TextOperation(List<Object> ops) {
        this();
        for (Object op : ops) {
            if (TextOperation.isRetain((Object)op)) {
                this.retain(((Integer)op).intValue());
                continue;
            }
            if (TextOperation.isInsert((Object)op)) {
                this.insert((String)op);
                continue;
            }
            if (TextOperation.isDelete((Object)op)) {
                this.delete(((Integer)op).intValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown operation type in list: " + String.valueOf(op));
        }
    }

    public TextOperation retain(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Retain count must be non-negative.");
        }
        if (n == 0) {
            return this;
        }
        this.baseLength += n;
        this.targetLength += n;
        if (!this.ops.isEmpty() && TextOperation.isRetain(this.ops.get(this.ops.size() - 1))) {
            int lastOp = (Integer)this.ops.get(this.ops.size() - 1);
            this.ops.set(this.ops.size() - 1, lastOp + n);
        } else {
            this.ops.add(n);
        }
        return this;
    }

    public TextOperation insert(String str) {
        if (str == null || str.isEmpty()) {
            return this;
        }
        this.targetLength += str.length();
        if (!this.ops.isEmpty() && TextOperation.isInsert(this.ops.get(this.ops.size() - 1))) {
            String lastOp = (String)this.ops.get(this.ops.size() - 1);
            this.ops.set(this.ops.size() - 1, lastOp + str);
        } else if (!this.ops.isEmpty() && TextOperation.isDelete(this.ops.get(this.ops.size() - 1))) {
            if (this.ops.size() >= 2 && TextOperation.isInsert(this.ops.get(this.ops.size() - 2))) {
                String secondLastOp = (String)this.ops.get(this.ops.size() - 2);
                this.ops.set(this.ops.size() - 2, secondLastOp + str);
            } else {
                Object lastOp = this.ops.remove(this.ops.size() - 1);
                this.ops.add(str);
                this.ops.add(lastOp);
            }
        } else {
            this.ops.add(str);
        }
        return this;
    }

    public TextOperation delete(int n) {
        if (n == 0) {
            return this;
        }
        int deleteCount = n > 0 ? -n : n;
        this.baseLength -= deleteCount;
        if (!this.ops.isEmpty() && TextOperation.isDelete(this.ops.get(this.ops.size() - 1))) {
            int lastOp = (Integer)this.ops.get(this.ops.size() - 1);
            this.ops.set(this.ops.size() - 1, lastOp + deleteCount);
        } else {
            this.ops.add(deleteCount);
        }
        return this;
    }

    @JsonValue
    public List<Object> getOps() {
        return new ArrayList<Object>(this.ops);
    }

    public int getBaseLength() {
        return this.baseLength;
    }

    public int getTargetLength() {
        return this.targetLength;
    }

    public boolean isNoop() {
        return this.ops.isEmpty() || this.ops.size() == 1 && TextOperation.isRetain(this.ops.get(0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextOperation that = (TextOperation)o;
        return this.baseLength == that.baseLength && this.targetLength == that.targetLength && Objects.equals(this.ops, that.ops);
    }

    public int hashCode() {
        return Objects.hash(this.ops, this.baseLength, this.targetLength);
    }

    public String toString() {
        return this.ops.stream().map(op -> {
            if (TextOperation.isRetain((Object)op)) {
                return "retain(" + String.valueOf(op) + ")";
            }
            if (TextOperation.isInsert((Object)op)) {
                return "insert(\"" + String.valueOf(op) + "\")";
            }
            if (TextOperation.isDelete((Object)op)) {
                return "delete(" + -((Integer)op).intValue() + ")";
            }
            return "unknown";
        }).collect(Collectors.joining(", ", "TextOperation[", "]"));
    }

    public void setOps(List<Object> ops) {
        this.ops = new ArrayList<Object>(ops);
    }

    public void setBaseLength(int baseLength) {
        this.baseLength = baseLength;
    }

    public void setTargetLength(int targetLength) {
        this.targetLength = targetLength;
    }
}

