/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class ChatMessage {
    private String sessionId;
    private String userId;
    private String userName;
    private String userColor;
    private String message;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime timestamp;

    @JsonProperty(value="formattedTimestamp")
    public String getFormattedTimestamp() {
        if (this.timestamp != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
            return this.timestamp.format(formatter);
        }
        return "";
    }

    public ChatMessage() {
    }

    public ChatMessage(String sessionId, String userId, String userName, String userColor, String message) {
        this.sessionId = sessionId;
        this.userId = userId;
        this.userName = userName;
        this.userColor = userColor;
        this.message = message;
        this.timestamp = LocalDateTime.now();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserColor() {
        return this.userColor;
    }

    public void setUserColor(String userColor) {
        this.userColor = userColor;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }
}

