package com.arms.api.backoffice.information.timeoff.controller;

import com.arms.api.backoffice.information.timeoff.entity.HolidayEntity;
import com.arms.api.backoffice.information.timeoff.model.dto.TimeoffDTO;
import com.arms.api.backoffice.information.timeoff.model.vo.UsersInfoVO;
import com.arms.api.backoffice.information.timeoff.service.TimeoffService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@RestController
@RequestMapping("/arms/backoffice/timeoff")
@AllArgsConstructor
public class TimeOffController {

	private final TimeoffService timeoffService;

	@GetMapping("/getUsersInfo")
	public ResponseEntity<List<UsersInfoVO>> getUsersInfo() {
		log.info("[ TimeOffController :: getUserInfo ] :: get users info");
		List<UsersInfoVO> userInfo = timeoffService.getUsersInfo();
		return ResponseEntity.ok(userInfo);
	}

	/*@PostMapping("/updateHolidayYearInfo")
	public ResponseEntity<List<HolidayEntity>> updateHolidayYearInfo(@RequestBody TimeoffDTO timeoffDTO) throws Exception{
		log.info("[ TimeOffController :: updateHolidayYearInfo ] :: Update Holiday Info");
		List<HolidayEntity> holidayInfo = timeoffService.updateHolidayYearInfo(timeoffDTO.getYear());
		return ResponseEntity.ok(holidayInfo);
	}

	@PostMapping("/updateHolidayMonthInfo")
	public ResponseEntity<List<HolidayEntity>> updateHolidayMonthInfo(@RequestBody TimeoffDTO timeoffDTO) throws Exception{
		log.info("[ TimeOffController :: updateHolidayMonthInfo ] :: Update Holiday Info");
		List<HolidayEntity> holidayInfo = timeoffService.updateHolidayMonthInfo(timeoffDTO.getYear(), timeoffDTO.getMonth());
		return ResponseEntity.ok(holidayInfo);
	}*/

}