package com.arms.api.backoffice.information.timeoff.controller;

import com.arms.api.backoffice.information.timeoff.model.dto.HolidayDTO;
import com.arms.api.backoffice.information.timeoff.entity.HolidayEntity;
import com.arms.api.backoffice.information.timeoff.service.HolidayService;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;

@Slf4j
@RestController
@RequestMapping(value = {"/arms/backoffice/holiday"})
public class HolidayController extends TreeAbstractController<HolidayService, HolidayDTO, HolidayEntity> {

    @Autowired
    @Qualifier("holidayService")
    private HolidayService holidayService;

    @PostConstruct
    public void initialize() {
        setTreeService(holidayService);
        setTreeEntity(HolidayEntity.class);
    }
}
