package com.arms.api.analysis.topmenu.controller;

import com.arms.api.analysis.topmenu.model.dto.TopMenuAnalysisDTO;
import com.arms.api.analysis.topmenu.model.vo.TopMenuVO;
import com.arms.api.analysis.topmenu.service.TopMenuService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/arms/analysis")
@RequiredArgsConstructor
@Slf4j
public class TopMenuController {

    private final TopMenuService topMenuService;

    // TopMenuApi용 - setReqStatus Data
    @PostMapping("/top-menu/{changeReqTableName}/getReqAddListByFilter")
    public ResponseEntity<?> analysisTopMenuReqStatusSummary(@PathVariable(value = "changeReqTableName") String changeReqTableName
            , @RequestBody TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {

        String pdServiceStr = StringUtils.replace(changeReqTableName, "T_ARMS_REQADD_", "");
        log.info("TopMenuController :: analysisTopMenuReqStatusSummary.pdServiceId ==> {}, pdServiceVersionLinks ==> {}"
                , pdServiceStr, topMenuAnalysisDTO.pdServiceVersionLinks());

        return ResponseEntity.ok(
                    CommonResponse.success(
                        topMenuService.analysisTopMenuReqStatusSummary(changeReqTableName, topMenuAnalysisDTO.pdServiceLink(), topMenuAnalysisDTO.pdServiceVersionLinks())));
    }

    @PostMapping("/top-menu/{changeReqTableName}/comprehensive-data")
    public ResponseEntity<TopMenuVO> analysisTopMenuData(
            @PathVariable(value = "changeReqTableName") String changeReqTableName,
            @RequestBody TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {

        log.info("TopMenuController :: pdServiceId ==> {}, pdServiceVersionLinks ==> {}",
                topMenuAnalysisDTO.pdServiceLink(), topMenuAnalysisDTO.pdServiceVersionLinks());

        return ResponseEntity.ok(topMenuService.getTopMenuData(changeReqTableName, topMenuAnalysisDTO));
    }

    @GetMapping("/top-menu/issue/req-and-subtask")
    public ResponseEntity<?> analysisTopMenuSubTaskStatusSummary(TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        log.info("TopMenuController :: 분석_톱메뉴_이슈_집계.pdServiceId ==> {}, pdServiceVersionLinks ==> {}", topMenuAnalysisDTO.pdServiceLink(), topMenuAnalysisDTO.pdServiceVersionLinks());

        return ResponseEntity.ok(CommonResponse.success(topMenuService.topMenuTotalCountWithReqAndSubtask(topMenuAnalysisDTO)));
    }

    @GetMapping("/top-menu/resource-info")
    public ResponseEntity<?> topMenuResourceInfoWithReqAndSubtask(TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {

        log.info("TopMenuController :: 톱메뉴_작업자별_요구사항_하위이슈_집계 ==> {}, pdServiceVersionLinks ==> {}",
                topMenuAnalysisDTO.pdServiceLink(), topMenuAnalysisDTO.pdServiceVersionLinks());


        return ResponseEntity.ok(topMenuService.topMenuResourceInfoWithReqAndSubtask(topMenuAnalysisDTO));
    }

    @GetMapping("/top-menu/version/period")
    public ResponseEntity<?> analysisTopMenuVersionPeriod(TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {

        if (topMenuAnalysisDTO == null) {
            throw new RuntimeException("parameter is null");
        }

        if (topMenuAnalysisDTO.pdServiceVersionLinks() == null) {
            throw new RuntimeException("parameter pdSerivceVersionIds is null");
        }

        log.info("TopMenuController :: analysisTopMenuVersionPeriod.pdServiceVersionLinks ==> {}", topMenuAnalysisDTO.pdServiceVersionLinks());

        return ResponseEntity.ok(
                CommonResponse.success(
                        topMenuService.topMenuVersionPeriod(topMenuAnalysisDTO)
                )
        );
    }
}
