package com.arms.api.analysis.time.controller;

import com.arms.api.analysis.time.model.RidgeLineVO;
import com.arms.api.analysis.time.model.dto.TimeDTO;
import com.arms.api.analysis.time.model.vo.AlmIssueStatVO;
import com.arms.api.analysis.time.model.vo.AlmIssuesByVersionVO;
import com.arms.api.analysis.time.model.vo.HeatMapVO;
import com.arms.api.analysis.time.model.vo.ScatterChartVO;
import com.arms.api.analysis.time.service.TimeService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

@Slf4j
@RestController
@RequestMapping(value = "/admin/arms/analysis/time")
@RequiredArgsConstructor
public class TimeController {

    private final TimeService timeService;

    // 히트맵
    @PostMapping(value = "/heatmap-data")
    public ModelAndView getHeatMapDataForYear(@RequestBody TimeDTO timeDTO) {

        HeatMapVO result = timeService.getHeatMapDataByUpdated(timeDTO);

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", result);

        return modelAndView;
    }

    // 스캐터 차트
    @PostMapping("/scatter-data")
    public ModelAndView getScatterChartData(@RequestBody TimeDTO timeDTO) {

        List<ScatterChartVO> result = timeService.getScatterChartData(timeDTO);

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", result);

        return modelAndView;
    }

    // 멀티 콤비네이션 차트
    @PostMapping("/updated-issue/multi-combination-data")
    public ModelAndView getMultiCombinationChartData(@RequestBody TimeDTO timeDTO) {

        List<AlmIssueStatVO> result = timeService.getMultiCombinationChartData(timeDTO);

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", result);

        return modelAndView;
    }

    // 이슈 타임라인 차트
    @PostMapping("/updated-timeline")
    public ModelAndView getUpdatedPdServiceVersionAlmIssueByDate(@RequestBody TimeDTO timeDTO) {

        List<AlmIssuesByVersionVO> versionGroupedResult = timeService.getUpdatedPdServiceVersionAlmIssueByDate(timeDTO);

        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", versionGroupedResult);

        return modelAndView;
    }

    // 능선 차트
    @PostMapping("/updated-ridgeline")
    public ResponseEntity<CommonResponse.ApiResult<List<RidgeLineVO>>> getRidgeLineData(@RequestBody TimeDTO timeDTO) throws Exception {

        return ResponseEntity.ok(CommonResponse.success(timeService.getRidgeLineData(timeDTO)));
    }

}
