package com.arms.api.util.communicate.external.response.jira;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;
import org.springframework.beans.BeanUtils;

import java.util.*;
import java.util.stream.Collectors;

@Setter
@Getter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AlmIssue {

    private String id;

    @JsonProperty("recent_id")
    private String recentId;

    private boolean recent;

    private String jira_server_id;

    @JsonProperty("@timestamp")
    private Date timestamp;

    private String issueID;
    private String key;
    private String upperKey;
    private String connectType;
    private String self;
    private String parentReqKey;
    private Boolean isReq;

    private Object etc;

    @JsonProperty("queries")
    private List<String> percolatorQueries;

    private AlmIssue.프로젝트 project;
    private AlmIssue.이슈유형 issuetype;
    private AlmIssue.생성자 creator;
    private AlmIssue.보고자 reporter;
    private AlmIssue.담당자 assignee;
    private List<String> labels;
    private AlmIssue.우선순위 priority;
    private AlmIssue.상태 status;
    private AlmIssue.해결책 resolution;
    private String resolutiondate;
    private String created;

    private String updated;
    private String overallUpdatedDate;

    private AlmIssue.삭제 deleted;

    public String projectName(){
        return Optional.ofNullable(project).map(프로젝트::getName).orElse("");
    }

    public String statusName(){
        return Optional.ofNullable(status).map(상태::getName).orElse("");
    }

    public String 지라이슈_삭제_일자_가져오기(){
        if(deleted == null){
            return "";
        }
        return deleted.삭제되었으면_일자리턴();
    }

    private List<AlmIssue.워크로그> worklogs;

    private Integer timespent;

    private String summary;

    private Long pdServiceId;

    private Long[] pdServiceVersions;

    private Long[] linkedIssuePdServiceIds;

    private Long[] linkedIssuePdServiceVersions;

    private Long pdServiceVersion;

    private String[] linkedIssues;

    private Long cReqLink;

    private Long cReqStatusId;

    private 암스_요구사항_속성 cReqProperty;

    private String armsStateCategory;

    public Boolean etcBoolean(){
        if(etc instanceof Boolean){
            return (Boolean)etc;
        }else{
            return false;
        }
    }

    private String _class; //추가
    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 삭제 {

        @JsonProperty("deleted_isDeleted")
        private Boolean isDeleted;

        @JsonProperty("deleted_date")
        private String date;

        public String 삭제되었으면_일자리턴(){
            if(isDeleted){
                return date;
            }else{
                return "";
            }
        }
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class 프로젝트 {

        @JsonProperty("project_self")
        private String self;

        @JsonProperty("project_id")
        private String id;

        @JsonProperty("project_key")
        private String key;

        @JsonProperty("project_name")
        private String name;
    }
    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 이슈유형 {
        // 온프레미스, 클라우드 공통
        @JsonProperty("issuetype_self")
        private String self;
        @JsonProperty("issuetype_id")
        private String id;
        @JsonProperty("issuetype_description")
        private String description;
        @JsonProperty("issuetype_name")
        private String name;
        @JsonProperty("issuetype_subtask")
        private Boolean subtask;

        // 클라우드만 사용
        @JsonProperty("issuetype_untranslatedName")
        private String untranslatedName;
        @JsonProperty("issuetype_hierarchyLevel")
        private Integer hierarchyLevel;
    }


    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 생성자 {

        @JsonProperty("creator_accountId")
        private String accountId;
        @JsonProperty("creator_emailAddress")
        private String emailAddress;
        @JsonProperty("creator_displayName")
        private String displayName;

    }
    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 보고자 {

        @JsonProperty("reporter_accountId")
        private String accountId;
        @JsonProperty("reporter_emailAddress")
        private String emailAddress;
        @JsonProperty("reporter_displayName")
        private String displayName;

    }
    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 담당자 {

        @JsonProperty("assignee_accountId")
        private String accountId;
        @JsonProperty("assignee_emailAddress")
        private String emailAddress;
        @JsonProperty("assignee_displayName")
        private String displayName;

    }
    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class 우선순위 {

        // 온프레미스, 클라우드 공통
        @JsonProperty("priority_self")
        private String self;

        @JsonProperty("priority_id")
        private String id;

        @JsonProperty("priority_name")
        private String name;

        @JsonProperty("priority_description")
        private String description;

        // 클라우드
        @JsonProperty("priority_isDefault")
        private boolean isDefault;
    }

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 상태 {

        // 온프레미스, 클라우드 공통
        @JsonProperty("status_self")
        private String self;

        @JsonProperty("status_id")
        private String id;

        @JsonProperty("status_name")
        private String name;

        @JsonProperty("status_description")
        private String description;
    }

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class 해결책 {


        // 온프레미스, 클라우드 공통
        @JsonProperty("resolution_self")
        private String self;

        @JsonProperty("resolution_id")
        private String id;

        @JsonProperty("resolution_name")
        private String name;

        @JsonProperty("resolution_description")
        private String description;

        // 클라우드
        @JsonProperty("resolution_isDefault")
        private boolean isDefault;
    }


    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 워크로그 {

        @JsonProperty("worklogs_self")
        private String self;

        private 저자 author;

        private 수정한_저자 updateAuthor;

        @JsonProperty("worklogs_created")
        private String created;

        @JsonProperty("worklogs_updated")
        private String updated;

        @JsonProperty("worklogs_started")
        private String started;

        @JsonProperty("worklogs_timeSpent")
        private String timeSpent;

        @JsonProperty("worklogs_timeSpentSeconds")
        private Integer timeSpentSeconds;

        @JsonProperty("worklogs_id")
        private String id;

        @JsonProperty("worklogs_issueId")
        private String issueId;
    }


    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 저자 {

        @JsonProperty("worklogs_author_accountId")
        private String accountId;

        @JsonProperty("worklogs_author_emailAddress")
        private String emailAddress;

    }
    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 수정한_저자 {

        @JsonProperty("worklogs_updateAuthor_accountId")
        private String accountId;
        @JsonProperty("worklogs_updateAuthor_emailAddress")
        private String emailAddress;
    }

    public List<AlmIssue> flattenPerVersionByVersions(){
        Long[] versions = this.getPdServiceVersions();
        if (versions == null || versions.length == 0) {
            // 버전 정보가 없으면 원본을 그대로 단일 요소로 반환
            return Collections.singletonList(this);
        }

        return Arrays.stream(versions)
                .filter(Objects::nonNull)
                .map(version -> {
                    AlmIssue copy = new AlmIssue();
                    // 얕은 복사
                    BeanUtils.copyProperties(this, copy);
                    copy.setPdServiceVersion(version);
                    return copy;
                })
                .collect(Collectors.toList());


    }

    public String 프로젝트아이디_가져오기(){
        return this.project.id;
    }

    public String 이슈타입별_키_가져오기(){
        if(Boolean.TRUE.equals(isReq)&&etc==null){
            return key;
        }else{
            return parentReqKey;
        }
    }

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class 암스_요구사항_속성 {

        @JsonProperty("cReqPriorityLink")
        private Long cReqPriorityLink;
        @JsonProperty("cReqPriorityName")
        private String cReqPriorityName;

        @JsonProperty("cReqDifficultyLink")
        private Long cReqDifficultyLink;
        @JsonProperty("cReqDifficultyName")
        private String cReqDifficultyName;

        @JsonProperty("cReqStateLink")
        private Long cReqStateLink;
        @JsonProperty("cReqStateName")
        private String cReqStateName;
    }

    public AlmIssue create연결이슈(){
        프로젝트 프로젝트 = new 프로젝트();
        프로젝트.setName(this.project.name);
        상태 상태 = new 상태();
        상태.setName(this.status.name);
        암스_요구사항_속성 암스_요구사항_속성 = new 암스_요구사항_속성();
        암스_요구사항_속성.setCReqStateName(Optional.ofNullable(this.cReqProperty).orElseGet(AlmIssue.암스_요구사항_속성::new).cReqStateName);
        return AlmIssue.builder()
                .pdServiceVersions(this.pdServiceVersions)
                .pdServiceId(this.pdServiceId)
                .cReqLink(this.cReqLink)
                .upperKey(this.upperKey)
                .project(프로젝트)
                .key(this.key)
                .issueID(this.issueID)
                .recentId(this.recentId)
                .summary(this.summary)
                .status(상태)
                .assignee(this.assignee)
                .created(this.created)
                .updated(this.updated)
                .resolutiondate(this.resolutiondate)
                .isReq(false)
                .cReqProperty(암스_요구사항_속성)
                .etc(this.etc)
                .parentReqKey(this.parentReqKey)
                .upperKey(this.upperKey)
                .armsStateCategory(this.armsStateCategory)
            .build();
    }

    public AlmIssue 현황관리_연결이슈생성(){
        프로젝트 프로젝트 = new 프로젝트();
        프로젝트.setName(this.project.name);

        우선순위 우선순위 = new 우선순위();
        우선순위.setName(this.priority.name);
        상태 상태 = new 상태();
        상태.setName(this.status.name);
        이슈유형 유형 = new 이슈유형();
        유형.setName(this.issuetype.name);


        암스_요구사항_속성 암스_요구사항_속성 = new 암스_요구사항_속성();
        암스_요구사항_속성.setCReqStateName(Optional.ofNullable(this.cReqProperty).orElseGet(AlmIssue.암스_요구사항_속성::new).cReqStateName);
        return AlmIssue.builder()
                .pdServiceVersions(this.pdServiceVersions)
                .pdServiceId(this.pdServiceId)
                .cReqLink(this.cReqLink)
                .upperKey(this.upperKey)
                .project(프로젝트)
                .key(this.key)
                .issueID(this.issueID)
                .recentId(this.recentId)
                .summary(this.summary)
                .status(상태)
                .priority(우선순위)
                .issuetype(유형)
                .assignee(this.assignee)
                .created(this.created)
                .updated(this.updated)
                .resolutiondate(this.resolutiondate)
                .deleted(this.deleted)
                .isReq(false)
                .cReqProperty(암스_요구사항_속성)
                .etc(this.etc)
                .parentReqKey(this.parentReqKey)
                .upperKey(this.upperKey)
                .armsStateCategory(this.armsStateCategory)
                .build();
    }

}
