package com.arms.api.report.mail.service.mail;

import com.arms.api.report.mail.modal.EmailSendResult;
import com.arms.api.report.mail.modal.dto.sender.SenderDTO;
import com.arms.api.report.mail.modal.entity.sender.SenderEntity;
import org.springframework.mail.javamail.JavaMailSenderImpl;

import java.util.List;

public interface MailService {

    public EmailSendResult validateSmtpConfig(SenderDTO senderDTO) throws Exception;

    List<EmailSendResult> sendTestEmailsToAllUsers() throws Exception ;

    EmailSendResult sendTestEmail(String userEmail) throws Exception;

    List<EmailSendResult> sendEmailsToAllUsers() throws Exception ;

    // SMTP 설정
    JavaMailSenderImpl createMailSender(SenderEntity smtpConfig);

    String fetchHtmlData() throws Exception;

    String generateChartImage() throws Exception;

    SenderEntity getSenderConfig() throws Exception;
}
