package com.arms.api.report.mail.controller.receiver;

import com.arms.api.report.mail.modal.dto.receiver.ReceiverDTO;
import com.arms.api.report.mail.modal.entity.receiver.ReceiverEntity;
import com.arms.api.report.mail.service.receiver.ReceiverService;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.PostConstruct;


@Slf4j
@Controller
@RequestMapping(value = {"/arms/report/mail-receiver"})
public class ReceiverController extends TreeAbstractController<ReceiverService, ReceiverDTO, ReceiverEntity> {

    @Autowired
    @Qualifier("receiverService")
    private ReceiverService receiverService;

    @PostConstruct
    public void initialize() {
        setTreeService(receiverService);
        setTreeEntity(ReceiverEntity.class);
    }



}
