package com.arms.api.report.mail.controller;

import com.arms.api.report.mail.modal.EmailSendResult;
import com.arms.api.report.mail.modal.dto.sender.SenderDTO;
import com.arms.api.report.mail.service.mail.MailService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Controller
@RequestMapping(value = {"/arms/mail"})
public class MailController {
    @Autowired
    @Qualifier("mailService")
    private MailService mailService;

    /* 테스트용 API */
    @PostMapping("/send-all-test")
    public ResponseEntity<List<EmailSendResult>> sendAllEmailTest() throws Exception{

        log.info("MailController :: sendAllEmailTest");

        List<EmailSendResult> results = mailService.sendTestEmailsToAllUsers();

        return ResponseEntity.ok(results);
    }

    @PostMapping("/send-test")
    public ResponseEntity<EmailSendResult> sendTestEmail(@RequestParam String userEmail) throws Exception{

        log.info("MailController :: sendTestEmail");

        EmailSendResult results = mailService.sendTestEmail(userEmail);

        return ResponseEntity.ok(results);
    }

    @GetMapping("/fetch-html-test")
    public ResponseEntity<String> fetchHtmlData() throws Exception{

        log.info("MailController :: fetchHtmlData");

        String results = mailService.fetchHtmlData();

        return ResponseEntity.ok(results);
    }


    @PostMapping("/validate")
    public ResponseEntity<EmailSendResult> validateSmtpConfig(@RequestBody SenderDTO senderDTO) throws Exception{

        log.info("MailController :: validateSmtpConfig");

        EmailSendResult result = mailService.validateSmtpConfig(senderDTO);

        return ResponseEntity.ok(result);
    }

    @GetMapping("/send-to-registered-users")
    public ResponseEntity<List<EmailSendResult>> sendEmailsToAllUsers() throws Exception{

        log.info("MailController :: sendEmailsToAllUsers");

        List<EmailSendResult> results = mailService.sendEmailsToAllUsers();

        return ResponseEntity.ok(results);
    }

   @GetMapping("/save-chart-image")
    public ResponseEntity<String> saveChartImage() throws Exception{

        log.info("MailController :: saveChartImage");

        String results = mailService.generateChartImage();

        return ResponseEntity.ok(results);
    }
}
