package com.arms.api.report.mail.controller;

import com.arms.api.report.mail.modal.vo.ChartVO;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;
import java.util.Map;

// todo 12/19 차트에 데이터를 전달하고, 이미지를 반환했을 떄 처리하는 컨트롤러 샘플 코드로 실제 차트 적용 필요
@Controller
@RequestMapping("/html/mail")
public class GenerateChartImageController {
    @GetMapping("/chart.html")
    public String getChartPage(Model model) {
        // 더미 데이터
        List<ChartVO> chartData = List.of(
                new ChartVO("A", 43.3, 85.8, 93.7),
                new ChartVO("B", 83.1, 73.4, 55.1),
                new ChartVO("C", 86.4, 65.2, 82.5),
                new ChartVO("D", 72.4, 53.9, 39.1)
        );

        model.addAttribute("chartData", chartData);
        return "chart";
    }
    /*
    *  todo 기능 확인을 위한 샘플 코드로, 데이터 베이스에 이미지 저장 로직 추가 구현 필요
    * */
    @PostMapping("/save-chart")
    public ResponseEntity<String> saveChart(@RequestBody Map<String, String> payload) throws Exception {
        String base64Image = payload.get("image");
        try {
            // Base64 디코딩
            byte[] imageBytes = Base64.getDecoder().decode(base64Image.split(",")[1]);
            // 저장 경로 설정
            Path outputPath = Paths.get("src/main/resources/static/saved-chart.png");
            // 이미지 저장
            Files.write(outputPath, imageBytes);

            return ResponseEntity.ok("차트 이미지 저장에 성공하였습니다. 경로:" + outputPath.toAbsolutePath());
        } catch (Exception e) {
            throw new Exception("차트 이미지 저장에 실패하였습니다.");
        }
    }


}
