/*
 * @author Dongmin.lee
 * @since 2023-03-28
 * @version 23.03.28
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.jira.jiraserver_project_pure.controller;

import com.arms.api.jira.jiraserver_project_pure.model.ALMServerProjectPureWithDateVO;
import com.arms.api.jira.jiraserver_project_pure.model.JiraServerProjectPureDTO;
import com.arms.api.jira.jiraserver_project_pure.model.JiraServerProjectPureEntity;
import com.arms.api.jira.jiraserver_project_pure.service.JiraServerProjectPure;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Slf4j
@Controller
@RequestMapping(value = {"/arms/jiraServerProjectPure"})
public class JiraServerProjectPureController extends TreeAbstractController<JiraServerProjectPure, JiraServerProjectPureDTO, JiraServerProjectPureEntity> {

    @Autowired
    @Qualifier("jiraServerProjectPure")
    private JiraServerProjectPure jiraServerProjectPure;

    @PostConstruct
    public void initialize() {
        setTreeService(jiraServerProjectPure);
        setTreeEntity(JiraServerProjectPureEntity.class);
    }

    @ResponseBody
    @RequestMapping(value = "/getNodeWithoutSoftDelete.do", method = RequestMethod.GET)
    public ResponseEntity<?> getNodeWithoutSoftDelete(JiraServerProjectPureDTO jiraServerProjectPureDTO, HttpServletRequest request)
            throws Exception {

        log.info("JiraServerProjectPureController :: getNodeWithoutSoftDelete");

        ParameterParser parser = new ParameterParser(request);

        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }

        JiraServerProjectPureEntity jiraServerProjectPureEntity
                = modelMapper.map(jiraServerProjectPureDTO, JiraServerProjectPureEntity.class);

        return ResponseEntity.ok(jiraServerProjectPure.getNodeWithoutSoftDelete(jiraServerProjectPureEntity));
    }

    @ResponseBody
    @RequestMapping(value = "/getALMServerProjectPureListWithSoftDelete.do", method = RequestMethod.GET)
    public ResponseEntity<List<ALMServerProjectPureWithDateVO>> getALMServerProjectPureListWithSoftDelete(JiraServerProjectPureDTO jiraServerProjectPureDTO) throws Exception {

        log.info("JiraServerProjectPureController :: getALMServerProjectPureListWithSoftDelete");

        JiraServerProjectPureEntity jiraServerProjectPureEntity
                = modelMapper.map(jiraServerProjectPureDTO, JiraServerProjectPureEntity.class);
        return ResponseEntity.ok(jiraServerProjectPure.getNodesWithoutRootAndSoftDeleteWithDate(jiraServerProjectPureEntity));
    }

    @ResponseBody
    @RequestMapping(
            value = {"/getJiraProjectList.do"},
            method={RequestMethod.GET}
    )
    public ResponseEntity<?> getJiraProjectList(JiraServerProjectPureDTO jiraServerProjectPureDTO,
                                                HttpServletRequest request) throws Exception {

        log.info("JiraServerProjectPureController :: getJiraProjectList");

        ParameterParser parser = new ParameterParser(request);

        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }

        JiraServerProjectPureEntity jiraServerProjectPureEntity = modelMapper.map(jiraServerProjectPureDTO, JiraServerProjectPureEntity.class);

        return ResponseEntity.ok(jiraServerProjectPure.서버_프로젝트_가져오기(jiraServerProjectPureEntity));
    }
}
