package com.arms.api.analysis.scope.model.vo;

import lombok.*;

import java.util.List;
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class NetworkChartVO {
    List<Link> links;
    List<Node> nodes;

    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class Link {
        String source;
        String target;
        String relation;
    }

    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class Node {
        String id;
        String type;
        String key;
        String parentReqKey;
        Boolean isReq;
        List<Long> versions;
        String serverId;
        Long reqLink;
    }
}
