package com.arms.api.analysis.cost.controller;

import com.arms.api.analysis.cost.model.dto.CalculationCostDTO;
import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.vo.*;
import com.arms.api.analysis.cost.service.CostService;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping(value = "/admin/arms/analysis/cost")
public class CostController {

    private final CostService costService;

    /**
     * 버전별 요구사항별 담당자 조회 API
     */
    @PostMapping("/version-req-assignees")
    public ResponseEntity<AllAssigneeVO> getAssigneeList(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok(costService.getAssigneeList(costDTO));
    }

    /**
     * 버전별 요구사항별 연결된 지라 지라 이슈 아이디 조회 API (버블 차트)
     */
    @PostMapping("/req-linked-issue")
    public ResponseEntity<LinkedJiraIssueVO> getLinkedJiraIssuesByVersionAndRequirement(@RequestBody CostDTO costDTO) throws Exception {
        Long pdServiceLink = costDTO.pdServiceLink();

        String 조회대상_지라이슈상태_테이블 = "T_ARMS_REQSTATUS_" + pdServiceLink;
        SessionUtil.setAttribute("req-linked-issue", 조회대상_지라이슈상태_테이블);

        LinkedJiraIssueVO linkedJiraIssuesByVersionAndRequirement = costService.getLinkedJiraIssuesByVersionAndRequirement(costDTO);

        SessionUtil.removeAttribute("req-linked-issue");

        return ResponseEntity.ok(linkedJiraIssuesByVersionAndRequirement);
    }

    // 요구사항(reqAdd), 난이도, 우선순위
    @PostMapping("/{changeReqTableName}/req-difficulty-priority-list")
    public ResponseEntity<RequirementDifficultyAndPriorityVO> getRequirementListStats(
            @PathVariable(value = "changeReqTableName") String changeReqTableName,
            @RequestBody CostDTO costDTO
    ) throws Exception {
        SessionUtil.setAttribute("req-difficulty-priority-list", changeReqTableName);
        RequirementDifficultyAndPriorityVO result = costService.getRequirementListStats(costDTO);
        SessionUtil.removeAttribute("req-difficulty-priority-list");
        return ResponseEntity.ok(result);
    }

    /**
     * 제품에 대한 누적 월 별 비용 조회 API
     */
    @PostMapping("/product-accumulate-cost-by-month")
    public ResponseEntity<ProductCostResponseVO> candleStickChartAPI(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok(costService.candleStickChartAPI(costDTO));
    }

    /**
     * 작업자별 - 작업일 수 및 비용 일할계산
     */
    @PostMapping("/personal-estimated-period-cost")
    public ResponseEntity<List<AssigneeTimeDiffVO>> getEstimatedPeriodCostByAccountId(@RequestBody CostDTO costDTO) throws Exception {
        List<AssigneeTimeDiffVO> resultList = costService.getEstimatedPeriodCostByAccountId(costDTO);
        return ResponseEntity.ok(resultList);
    }

    @PostMapping("/calculation")
    public ResponseEntity<?> calculateCost(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok(costService.calculateCostAll(costDTO));
    }

    @PostMapping("/version-calculation")
    public ResponseEntity<?> calculateVersionCost(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok(costService.calculateVersionCost(costDTO));
    }

    @PostMapping("/requirement-calculation")
    public ResponseEntity<?> calculateRequirementCost(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok(costService.calculateRequirementCost(costDTO));
    }

    @PostMapping("/assignee-calculation")
    public ResponseEntity<?> calculateAssigneeCost(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok(costService.calculateAssigneeCost(costDTO));
    }

    @PostMapping("/to-be/calculation")
    public ResponseEntity<?> toBeCalculateCost(@RequestBody CalculationCostDTO calculationCostDTO) throws Exception {
        return ResponseEntity.ok(costService.toBeCalculateCost(calculationCostDTO));
    }
}