-- T_ARMS_SENDER_EMAIL_LOG 테이블에 c_send_time 컬럼 추가
ALTER TABLE `aRMS`.`T_ARMS_SENDER_EMAIL_LOG`
ADD COLUMN `c_send_time` TIME NULL COMMENT '발신 시간';

-- T_ARMS_SENDER_EMAIL 테이블에 c_send_time 컬럼 추가
ALTER TABLE `aRMS`.`T_ARMS_SENDER_EMAIL`
ADD COLUMN  `c_send_time` TIME NULL COMMENT '발신 시간';


--
-- Table structure for table `T_ARMS_SENDER_EMAIL`
--
CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_RECEIVER_EMAIL_LOG` (

    `c_id`                                   bigint(20) NOT NULL COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

	`c_method`                               text NULL COMMENT '노드 변경 행위',
    `c_state`                                text NULL COMMENT '노드 상태값 ( 이전인지. 이후인지)',
    `c_date`                                 DATETIME NULL COMMENT '노드 변경 시',

	`c_receiver_name`                          VARCHAR(255) COMMENT '수신사 이름',
    `c_receiver_email` 						 VARCHAR(255) COMMENT '수신자 이메일',
    `c_receiver_activate`                    text COMMENT '리포트 수신 여부',

    `c_check`                                text NULL,
    `c_contents`                             longtext NULL,
    `c_desc`                                 text NULL,
    `c_etc`                                  text NULL

) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='수신 메일 정보(메일 리포트) 트리거 로그';


CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_RECEIVER_EMAIL` (

    `c_id`                                   bigint(20) AUTO_INCREMENT primary key COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

	`c_receiver_name`                         VARCHAR(255) COMMENT '수신사 이름',
    `c_receiver_email` 						 VARCHAR(255) COMMENT '수신자 이메일',
    `c_receiver_activate`                    text COMMENT '리포트 수신 여부',

    `c_check`                                text NULL,
    `c_contents`                             longtext NULL,
    `c_desc`                                 text NULL,
    `c_etc`                                  text NULL

) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='수신 메일 정보(메일 리포트)';

DELIMITER $$
CREATE TRIGGER TG_INSERT_T_ARMS_RECEIVER_EMAIL
    BEFORE  INSERT ON T_ARMS_RECEIVER_EMAIL
    FOR EACH ROW
BEGIN
    insert into T_ARMS_RECEIVER_EMAIL_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이전데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_UPDATE_T_ARMS_RECEIVER_EMAIL
    BEFORE  UPDATE ON T_ARMS_RECEIVER_EMAIL
    FOR EACH ROW
BEGIN
    insert into T_ARMS_RECEIVER_EMAIL_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'update','변경이전데이터',now());

    insert into T_ARMS_RECEIVER_EMAIL_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이후데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_DELETE_T_ARMS_RECEIVER_EMAIL
    BEFORE  DELETE ON T_ARMS_RECEIVER_EMAIL
    FOR EACH ROW
BEGIN
    insert into T_ARMS_RECEIVER_EMAIL_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'delete','삭제된데이터',now());
END $$
DELIMITER ;

Insert into `aRMS`.`T_ARMS_RECEIVER_EMAIL` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (1, 0, 0, 1, 18, 0, 'T_ARMS_RECEIVER_EMAIL', 'root');
Insert into `aRMS`.`T_ARMS_RECEIVER_EMAIL` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
Values (2, 1, 0, 2, 17, 1, '수신 메일 정보(메일 리포트)', 'drive');