package com.arms.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

@Configuration
public class RouteTableConfig {
    @Bean
    public Map<String, String> reqAddRoute() {
        Map<String, String> map = new HashMap<>();
        map.put("getMonitor.do", "getMonitor");
        map.put("getNode.do", "getNode");
        map.put("getNodeDetail.do", "getNodeDetail");
        map.put("getDetail.do", "getDetail");
        map.put("getChildNode.do", "getChildNode");
        map.put("getReqNodesWithoutRoot.do", "getReqNodesWithoutRoot");
        map.put("getNodesWithoutRoot.do", "getNodesWithoutRoot");
        map.put("getChildNodeWithParent.do", "getChildNodeWithParent");
        map.put("addNode.do", "addNode");
        map.put("addFolderNode.do", "addReqFolderNode");
        map.put("updateNode.do", "updateNode");
        map.put("updateDate.do", "updateDate");
        map.put("updateDataBase.do", "updateDataBase");
        map.put("getNodesWhereInIds.do", "getNodesWhereInIds");
        map.put("removeNode.do", "removeNode");
        map.put("moveNode.do", "moveNode");
        map.put("getHistory.do", "getHistory");
        map.put("getReqAddListByFilter", "getReqAddListByFilter");
        map.put("issue-network", "issue-network");
        map.put("req-property-list", "req-property-list");
        map.put("comprehensive-data", "comprehensive-data");
        map.put("reqProgress.do", "reqProgress");
        map.put("calculateProgress.do", "reqProgress");
        map.put("reportReqStatus", "reportReqStatus");
        map.put("weeklyReportReqStatus", "weeklyReportReqStatus");
        map.put("req-difficulty-priority-list", "req-difficulty-priority-list");
        map.put("estimated-period-cost", "estimated-period-cost");
        map.put("updateReqAddOnly.do", "updateReqAddOnly");
        map.put("updateDrawIOContents.do", "updateDrawIOContents");
        map.put("updateDrawDBContents.do", "updateDrawDBContents");
        map.put("excel-data", "excel-data");
        map.put("updateReqAddState.do", "updateReqAddState");

        return map;
    }

    @Bean
    public Map<String, String> reqStatusRoute() {
        Map<String, String> map = new HashMap<>();
        map.put("getStatusMonitor.do", "getStatusMonitor");
        map.put("getStatistics.do", "getStatistics");
        map.put("getStatusNode.do", "getStatusNode");
        map.put("getStatusChildNode.do", "getStatusChildNode");
        map.put("getStatusChildNodeWithParent.do", "getStatusChildNodeWithParent");
        map.put("addStatusNode.do", "addStatusNode");
        map.put("updateStatusNode.do", "updateStatusNode");
        map.put("removeStatusNode.do", "removeStatusNode");
        map.put("updateDate.do", "updateDate");
        map.put("updateDataBase.do", "updateDataBase");
        map.put("removeNode.do", "removeNode");
        map.put("moveStatusNode.do", "moveStatusNode");
        map.put("getStatusHistory.do", "getStatusHistory");
        map.put("getPdRelatedReqStats.do", "getPdRelatedReqStats");
        map.put("getReqStatusListByCReqLink.do", "getReqStatusListByCReqLink");
        map.put("reqStatusCheckAfterAlmProcess.do","reqStatusCheckAfterAlmProcess");

        return map;
    }

    @Bean
    public Map<String, String> wikiRoute() {
        Map<String, String> map = new HashMap<>();
        map.put("getNode.do", "getNode");
        map.put("getChildNode.do", "getChildNode");
        map.put("getNodesWithoutRoot.do", "getNodesWithoutRoot");
        map.put("getPaginatedChildNode.do", "getPaginatedChildNode");
        map.put("searchNode.do", "searchNode");
        map.put("addNode.do", "addNode");
        map.put("removeNode.do", "removeNode");
        map.put("updateNode.do", "updateNode");
        map.put("alterNode.do", "alterNode");
        map.put("alterNodeType.do", "alterNodeType");
        map.put("moveNode.do", "moveNode");
        map.put("getMonitor.do", "getMonitor");

        return map;
    }

    @Bean
    public Map<String, String> reqLinkedIssueRoute() {
        Map<String, String> map = new HashMap<>();
        map.put("req-linked-issue", "req-linked-issue");
        return map;
    }

    @Bean
    public Map<String, String> costRoute() {
        Map<String, String> map = new HashMap<>();
        map.put("calculation", "cost-calculation");
        map.put("version-calculation", "cost-calculation");
        map.put("requirement-calculation", "cost-calculation");
        map.put("assignee-calculation", "cost-calculation");

        return map;
    }
}
