/*
 * @author Dongmin.lee
 * @since 2023-03-21
 * @version 23.03.21
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.requirement.reqstatus.service;

import com.arms.api.jira.jiraserver.model.JiraServerEntity;
import com.arms.api.requirement.reqstatus.model.*;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;

import java.util.List;

public interface ReqStatus extends TreeService {

    void ALM서버_요구사항_처리_및_REQSTATUS_업데이트(ReqStatusEntity reqStatusEntity, Long 제품서비스_아이디);

    JiraServerEntity ALM서버_검색(Long ALM서버_아이디);

    void ALM_이슈상태_업데이트(ReqStatusEntity reqStatusEntity);

    void reqStatusCheckAfterAlmProcess(ReqStatusDTO reqStatusDTO, Long 제품서비스_아이디) throws Exception;

    ReqStatusDashboardVO reqStatusDashboard(Long pdServiceId, List<Long> pdServiceVersionIds) throws Exception;

    // 현황관리 Issue List 가져오기
    List<IssueListVO> reqStatusIssueList(Long pdServiceId, List<Long> pdServiceVersionIds) throws Exception;

    List<HierarchicalAlmIssue> getHierarchicalAlmIssuesByAdvancedDiscovery(Long pdServiceId, List<Long> pdServiceVersionIds) throws Exception;
    // 계층 - 하위/연결 이슈 조회
    List<HierarchicalAlmIssue> getSubtasksAndLinkedIssues(SubtaskAndLinkedIssuesRequestDTO requestDTO) throws Exception;

}
