package com.arms.api.requirement.reqadd_state_pure.model.vo;

import lombok.*;

@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class WeeklyReportReqAddVO {
    private String key;
    private String weekLabel;
    private int year;
    private int week;
    private PlanAmount plan;
    private ActualAmount actual;

    @Builder
    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class PlanAmount {
        private int count;
        private int total;
        private int resource;
        private double progress;
    }

    @Builder
    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ActualAmount {
        private int count;
        private int resource;
        private double progress;
    }
}
