package com.arms.api.report.export_service.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * 테이블 데이터 모델
 *
 * @author HS.Yang
 * @since 2025.12.02
 */
@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TableData {

    /** 테이블 ID */
    private String tableId;

    /** 테이블 이름 */
    private String tableName;

    /** 캡션 */
    private String caption;

    /** 헤더 목록 */
    @Builder.Default
    private List<String> headers = new ArrayList<>();

    /** 데이터 행 목록 */
    @Builder.Default
    private List<List<String>> rows = new ArrayList<>();

    /** 열 스타일 */
    @Builder.Default
    private List<ColumnStyle> columnStyles = new ArrayList<>();

    /** 테이블 스타일 */
    @Builder.Default
    private TableStyle style = new TableStyle();

    /**
     * 열 스타일 클래스
     */
    @Getter
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ColumnStyle {
        @Builder.Default
        private float widthPercent = 0;

        @Builder.Default
        private Alignment alignment = Alignment.LEFT;

        @Builder.Default
        private boolean bold = false;
    }

    /**
     * 테이블 스타일 클래스
     */
    @Getter
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TableStyle {
        /** 헤더 배경색 (HEX) */
        @Builder.Default
        private String headerBackgroundColor = "#4285F4";

        /** 헤더 텍스트 색상 */
        @Builder.Default
        private String headerTextColor = "#FFFFFF";

        /** 교대 행 배경색 */
        @Builder.Default
        private String alternateRowColor = "#F8F9FA";

        /** 교대 행 색상 사용 여부 */
        @Builder.Default
        private boolean hasAlternateRowColor = true;

        /** 테두리 표시 여부 */
        @Builder.Default
        private boolean hasBorder = true;
    }

    public enum Alignment {
        LEFT, CENTER, RIGHT
    }

    public void addHeader(String header) {
        this.headers.add(header);
    }

    public void addRow(List<String> row) {
        this.rows.add(row);
    }

    public void addRow(String... cells) {
        this.rows.add(List.of(cells));
    }

    public int getColumnCount() {
        return headers.size();
    }

    public int getRowCount() {
        return rows.size();
    }
}
