/*
 * @author Dongmin.lee
 * @since 2022-11-20
 * @version 22.11.20
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.product_service.pdserviceversion.service;

import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionVO;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service("pdServiceVersion")
@RequiredArgsConstructor
public class PdServiceVersionImpl extends TreeServiceImpl implements PdServiceVersion {

    private final GlobalTreeMapService globalTreeMapService;


    @Override
    public List<PdServiceVersionVO> findAllByPdServiceId(Long pdServiceId) throws Exception {

        List<GlobalTreeMapEntity> globalTreeMapEntities = globalTreeMapService.findAllByIds(List.of(pdServiceId), "pdservice_link");

        List<Long> cids = globalTreeMapEntities.stream()
                .filter(globalTreeMapEntity -> globalTreeMapEntity.getPdserviceversion_link() != null)
                .map(GlobalTreeMapEntity::getPdserviceversion_link)
                .collect(Collectors.toList());

        if (cids.isEmpty()) {
            return Collections.emptyList();
        }

        PdServiceVersionEntity pdServiceVersionEntity = new PdServiceVersionEntity();

        Criterion criterion = Restrictions.in("c_id", cids);

        pdServiceVersionEntity.getCriterions().add(criterion);

        List<PdServiceVersionEntity> pdServiceVersionEntities = this.getNodesWithoutRoot(pdServiceVersionEntity);

        return pdServiceVersionEntities.stream().map(PdServiceVersionVO::toVO).collect(Collectors.toList());
    }

    @Override
    public List<PdServiceVersionEntity> getVersionListByCids(List<Long> cids) throws Exception {

        PdServiceVersionEntity 검색용_엔티티 = new PdServiceVersionEntity();
        Criterion criterion = Restrictions.in("c_id", cids);

        검색용_엔티티.getCriterions().add(criterion);

        List<PdServiceVersionEntity> fetchedVersions = this.getChildNode(검색용_엔티티);

        if (fetchedVersions.isEmpty()) {
            return Collections.emptyList();
        }

        log.info("[ PdServiceVersionImpl :: getVersionListByCids ] :: 가져온 버전엔티티의 수 = {}", fetchedVersions.size());

        return fetchedVersions;
    }

    @Override
    public Map<String, String> versionPeriod(List<Long> c_ids) throws Exception {
        PdServiceVersionEntity 버전_검색세팅 = new PdServiceVersionEntity();
        버전_검색세팅.setWhereIn("c_id", c_ids);
        List<PdServiceVersionEntity> 검색결과_목록 = this.getChildNode(버전_검색세팅);
        log.info("PdServiceVersionImpl ::  versionPeriod.size = {}", 검색결과_목록.size());

        Map<String, String> map = new HashMap<>();
        String earliestDate = null;
        String latestDate = null;
        for (PdServiceVersionEntity 버전엔티티 : 검색결과_목록) {
            String start = 버전엔티티.getC_pds_version_start_date();
            String end = 버전엔티티.getC_pds_version_end_date();
            if (earliestDate == null || start.compareTo(earliestDate) < 0) {
                earliestDate = start;
            }
            if (latestDate == null || end.compareTo(latestDate) > 0) {
                latestDate = end;
            }
        }
        map.put("earliestDate", earliestDate);
        map.put("latestDate", latestDate);
        log.info("[PdServiceVersionImpl ::  versionPeriod] :: earliestDate -> {}, latestDate -> {}",
                earliestDate, latestDate);
        return map;
    }


}