package com.arms.api.poc.model;

import lombok.*;

import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PocEntity implements Serializable {

    private String id;
    private String c_poc_first_name;
    private String c_poc_last_name;
    private String c_poc_full_name;
    private String c_poc_company_name;
    private String c_poc_company_size;
    private String c_poc_job_title;
    private String c_poc_email_address;
    private String c_poc_country;
    private Long c_poc_country_code;
    private String c_poc_contact_number;
    private String c_poc_inquiry_reason;
    private String c_poc_inquiry_content;
    private Date c_poc_inquiry_date;
    private String c_poc_assignee_id;
    private String c_poc_assignee_username;
    private String c_poc_assignee_name;
    private String c_poc_assignee_email;
    private Long c_poc_assignee_link;

    @Builder.Default
    private String c_poc_status = "PENDING";

    private String c_poc_status_memo;
    private Date c_poc_status_updated;
    private Boolean c_poc_marketing_consent;
    private String c_poc_etc;
    private String c_poc_desc;
    private String c_poc_contents;
    private Date createdDate;
    private Date updatedDate;
}